/*
 * Decompiled with CFR 0.152.
 */
package com.box.sdkgen.managers.collections;

import com.box.sdkgen.internal.utils.Entry;
import com.box.sdkgen.internal.utils.UtilsManager;
import com.box.sdkgen.managers.collections.GetCollectionByIdHeaders;
import com.box.sdkgen.managers.collections.GetCollectionItemsHeaders;
import com.box.sdkgen.managers.collections.GetCollectionItemsQueryParams;
import com.box.sdkgen.managers.collections.GetCollectionsHeaders;
import com.box.sdkgen.managers.collections.GetCollectionsQueryParams;
import com.box.sdkgen.networking.auth.Authentication;
import com.box.sdkgen.networking.fetchoptions.FetchOptions;
import com.box.sdkgen.networking.fetchoptions.ResponseFormat;
import com.box.sdkgen.networking.fetchresponse.FetchResponse;
import com.box.sdkgen.networking.network.NetworkSession;
import com.box.sdkgen.schemas.collection.Collection;
import com.box.sdkgen.schemas.collections.Collections;
import com.box.sdkgen.schemas.itemsoffsetpaginated.ItemsOffsetPaginated;
import com.box.sdkgen.serialization.json.JsonManager;
import java.util.Map;

public class CollectionsManager {
    public Authentication auth;
    public NetworkSession networkSession;

    public CollectionsManager() {
        this.networkSession = new NetworkSession();
    }

    protected CollectionsManager(Builder builder) {
        this.auth = builder.auth;
        this.networkSession = builder.networkSession;
    }

    public Collections getCollections() {
        return this.getCollections(new GetCollectionsQueryParams(), new GetCollectionsHeaders());
    }

    public Collections getCollections(GetCollectionsQueryParams queryParams) {
        return this.getCollections(queryParams, new GetCollectionsHeaders());
    }

    public Collections getCollections(GetCollectionsHeaders headers) {
        return this.getCollections(new GetCollectionsQueryParams(), headers);
    }

    public Collections getCollections(GetCollectionsQueryParams queryParams, GetCollectionsHeaders headers) {
        Map<String, String> queryParamsMap = UtilsManager.prepareParams(UtilsManager.mapOf(UtilsManager.entryOf("fields", UtilsManager.convertToString(queryParams.getFields())), UtilsManager.entryOf("offset", UtilsManager.convertToString(queryParams.getOffset())), UtilsManager.entryOf("limit", UtilsManager.convertToString(queryParams.getLimit()))));
        Map<String, String> headersMap = UtilsManager.prepareParams(UtilsManager.mergeMaps(UtilsManager.mapOf(new Entry[0]), headers.getExtraHeaders()));
        FetchResponse response = this.networkSession.getNetworkClient().fetch(new FetchOptions.Builder(String.join((CharSequence)"", this.networkSession.getBaseUrls().getBaseUrl(), "/2.0/collections"), "GET").params(queryParamsMap).headers(headersMap).responseFormat(ResponseFormat.JSON).auth(this.auth).networkSession(this.networkSession).build());
        return JsonManager.deserialize(response.getData(), Collections.class);
    }

    public ItemsOffsetPaginated getCollectionItems(String collectionId) {
        return this.getCollectionItems(collectionId, new GetCollectionItemsQueryParams(), new GetCollectionItemsHeaders());
    }

    public ItemsOffsetPaginated getCollectionItems(String collectionId, GetCollectionItemsQueryParams queryParams) {
        return this.getCollectionItems(collectionId, queryParams, new GetCollectionItemsHeaders());
    }

    public ItemsOffsetPaginated getCollectionItems(String collectionId, GetCollectionItemsHeaders headers) {
        return this.getCollectionItems(collectionId, new GetCollectionItemsQueryParams(), headers);
    }

    public ItemsOffsetPaginated getCollectionItems(String collectionId, GetCollectionItemsQueryParams queryParams, GetCollectionItemsHeaders headers) {
        Map<String, String> queryParamsMap = UtilsManager.prepareParams(UtilsManager.mapOf(UtilsManager.entryOf("fields", UtilsManager.convertToString(queryParams.getFields())), UtilsManager.entryOf("offset", UtilsManager.convertToString(queryParams.getOffset())), UtilsManager.entryOf("limit", UtilsManager.convertToString(queryParams.getLimit()))));
        Map<String, String> headersMap = UtilsManager.prepareParams(UtilsManager.mergeMaps(UtilsManager.mapOf(new Entry[0]), headers.getExtraHeaders()));
        FetchResponse response = this.networkSession.getNetworkClient().fetch(new FetchOptions.Builder(String.join((CharSequence)"", this.networkSession.getBaseUrls().getBaseUrl(), "/2.0/collections/", UtilsManager.convertToString(collectionId), "/items"), "GET").params(queryParamsMap).headers(headersMap).responseFormat(ResponseFormat.JSON).auth(this.auth).networkSession(this.networkSession).build());
        return JsonManager.deserialize(response.getData(), ItemsOffsetPaginated.class);
    }

    public Collection getCollectionById(String collectionId) {
        return this.getCollectionById(collectionId, new GetCollectionByIdHeaders());
    }

    public Collection getCollectionById(String collectionId, GetCollectionByIdHeaders headers) {
        Map<String, String> headersMap = UtilsManager.prepareParams(UtilsManager.mergeMaps(UtilsManager.mapOf(new Entry[0]), headers.getExtraHeaders()));
        FetchResponse response = this.networkSession.getNetworkClient().fetch(new FetchOptions.Builder(String.join((CharSequence)"", this.networkSession.getBaseUrls().getBaseUrl(), "/2.0/collections/", UtilsManager.convertToString(collectionId)), "GET").headers(headersMap).responseFormat(ResponseFormat.JSON).auth(this.auth).networkSession(this.networkSession).build());
        return JsonManager.deserialize(response.getData(), Collection.class);
    }

    public Authentication getAuth() {
        return this.auth;
    }

    public NetworkSession getNetworkSession() {
        return this.networkSession;
    }

    public static class Builder {
        protected Authentication auth;
        protected NetworkSession networkSession = new NetworkSession();

        public Builder auth(Authentication auth) {
            this.auth = auth;
            return this;
        }

        public Builder networkSession(NetworkSession networkSession) {
            this.networkSession = networkSession;
            return this;
        }

        public CollectionsManager build() {
            return new CollectionsManager(this);
        }
    }
}

