/*
 * Decompiled with CFR 0.152.
 */
package com.basho.riak.client.util;

import java.io.IOException;
import java.io.InputStream;

public class OneTokenInputStream
extends InputStream {
    int maxBufferLen;
    InputStream impl;
    boolean eof = false;
    int pos = 0;
    int dataLen = 0;
    int bufOffset = 0;
    StringBuilder buf = null;
    String delimiter;

    public OneTokenInputStream(InputStream in, String delimiter) {
        this.impl = in;
        this.maxBufferLen = Math.max(1024, delimiter.length() * 2);
        this.delimiter = delimiter;
    }

    public int read() throws IOException {
        while (!this.eof && this.pos >= this.dataLen) {
            this.buffer();
        }
        if (this.pos >= this.dataLen) {
            return -1;
        }
        char c = this.buf.charAt(this.pos - this.bufOffset);
        ++this.pos;
        return c;
    }

    public void close() throws IOException {
        this.impl.close();
        this.impl = null;
        this.eof = true;
    }

    public boolean done() {
        return this.eof;
    }

    private void buffer() throws IOException {
        if (this.eof) {
            return;
        }
        if (this.buf == null) {
            this.initBuffer();
        }
        if (!this.eof) {
            int c = this.impl.read();
            if (c == -1) {
                this.dataLen = this.buf.length();
                this.eof = true;
            } else {
                this.buf.append((char)c);
                if (this.buf.length() > this.maxBufferLen) {
                    this.bufOffset += this.buf.length() - this.delimiter.length();
                    this.buf.delete(0, this.buf.length() - this.delimiter.length());
                }
                if (this.buf.indexOf(this.delimiter) >= 0) {
                    this.eof = true;
                } else {
                    ++this.dataLen;
                }
            }
        }
    }

    private void initBuffer() throws IOException {
        int bytesRead;
        byte[] headStart = new byte[this.delimiter.length() - 1];
        for (int offset = 0; offset < headStart.length; offset += bytesRead) {
            bytesRead = this.impl.read(headStart, offset, headStart.length - offset);
            if (bytesRead != -1) continue;
            this.eof = true;
            return;
        }
        this.buf = new StringBuilder(new String(headStart));
    }
}

