/*
 * Decompiled with CFR 0.152.
 */
package com.basho.riak.client.response;

import com.basho.riak.client.RiakBucketInfo;
import com.basho.riak.client.response.HttpResponse;
import com.basho.riak.client.response.HttpResponseDecorator;
import com.basho.riak.client.response.StreamedKeysCollection;
import com.basho.riak.client.util.ClientUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Collection;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;

public class BucketResponse
extends HttpResponseDecorator
implements HttpResponse {
    private RiakBucketInfo bucketInfo = null;

    public BucketResponse(HttpResponse r) throws JSONException, IOException {
        super(r);
        if (r != null && r.isSuccess()) {
            Collection<String> keys;
            JSONObject props;
            if (!r.isStreamed()) {
                JSONObject json = new JSONObject(r.getBodyAsString());
                JSONArray jsonKeys = json.optJSONArray("keys");
                props = json.optJSONObject("props");
                keys = ClientUtils.jsonArrayAsList(jsonKeys);
            } else {
                InputStream stream = r.getStream();
                JSONTokener tokens = new JSONTokener(new InputStreamReader(stream));
                props = new JSONObject(tokens).optJSONObject("props");
                keys = new StreamedKeysCollection(tokens);
            }
            this.bucketInfo = new RiakBucketInfo(props, keys);
        }
    }

    public boolean hasBucketInfo() {
        return this.bucketInfo != null;
    }

    public RiakBucketInfo getBucketInfo() {
        return this.bucketInfo;
    }
}

