/*
 * Decompiled with CFR 0.152.
 */
package com.azure.xml.implementation.aalto.stax;

import com.azure.xml.implementation.aalto.out.AsciiXmlWriter;
import com.azure.xml.implementation.aalto.out.CharXmlWriter;
import com.azure.xml.implementation.aalto.out.Latin1XmlWriter;
import com.azure.xml.implementation.aalto.out.StreamWriterBase;
import com.azure.xml.implementation.aalto.out.Utf8XmlWriter;
import com.azure.xml.implementation.aalto.out.WNameTable;
import com.azure.xml.implementation.aalto.out.WriterConfig;
import com.azure.xml.implementation.aalto.out.XmlWriter;
import com.azure.xml.implementation.aalto.util.CharsetNames;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Result;

public final class OutputFactoryImpl
extends XMLOutputFactory {
    public static final String P_AUTOMATIC_EMPTY_ELEMENTS = "com.azure.xml.implementation.stax2.automaticEmptyElements";
    public static final String P_AUTO_CLOSE_OUTPUT = "com.azure.xml.implementation.stax2.autoCloseOutput";
    public static final String P_AUTOMATIC_NS_PREFIX = "com.azure.xml.implementation.stax2.automaticNsPrefix";
    public static final String P_TEXT_ESCAPER = "com.azure.xml.implementation.stax2.textEscaper";
    public static final String P_ATTR_VALUE_ESCAPER = "com.azure.xml.implementation.stax2.attrValueEscaper";
    private final WriterConfig _config = new WriterConfig();

    @Override
    public XMLEventWriter createXMLEventWriter(OutputStream out) {
        throw new UnsupportedOperationException();
    }

    @Override
    public XMLEventWriter createXMLEventWriter(OutputStream out, String enc) {
        throw new UnsupportedOperationException();
    }

    @Override
    public XMLEventWriter createXMLEventWriter(Result result) {
        throw new UnsupportedOperationException();
    }

    @Override
    public XMLEventWriter createXMLEventWriter(Writer w) {
        throw new UnsupportedOperationException();
    }

    @Override
    public XMLStreamWriter createXMLStreamWriter(OutputStream out) throws XMLStreamException {
        return this.createXMLStreamWriter(out, null);
    }

    @Override
    public XMLStreamWriter createXMLStreamWriter(OutputStream out, String enc) throws XMLStreamException {
        return this.createSW(out, null, enc);
    }

    @Override
    public XMLStreamWriter createXMLStreamWriter(Result result) {
        throw new UnsupportedOperationException();
    }

    @Override
    public XMLStreamWriter createXMLStreamWriter(Writer w) throws XMLStreamException {
        return this.createSW(null, w, null);
    }

    @Override
    public Object getProperty(String name) {
        return this._config.getProperty(name, true);
    }

    @Override
    public boolean isPropertySupported(String name) {
        return this._config.isPropertySupported(name);
    }

    @Override
    public void setProperty(String name, Object value) {
        this._config.setProperty(name, value);
    }

    private StreamWriterBase createSW(OutputStream out, Writer w, String enc) throws XMLStreamException {
        WNameTable symbols;
        XmlWriter xw;
        WriterConfig cfg = this._config.createNonShared();
        if (w == null) {
            if (enc == null) {
                enc = "UTF-8";
            } else if (!(enc.equals("UTF-8") || enc.equals("ISO-8859-1") || enc.equals("US-ASCII"))) {
                enc = CharsetNames.normalize(enc);
            }
            cfg.setActualEncodingIfNotSet(enc);
            try {
                if (enc.equals("UTF-8")) {
                    xw = new Utf8XmlWriter(cfg, out);
                    symbols = this._config.getUtf8Symbols(xw);
                }
                if (enc.equals("ISO-8859-1")) {
                    xw = new Latin1XmlWriter(cfg, out);
                    symbols = this._config.getLatin1Symbols(xw);
                }
                if (enc.equals("US-ASCII")) {
                    xw = new AsciiXmlWriter(cfg, out);
                    symbols = this._config.getAsciiSymbols(xw);
                }
                w = new OutputStreamWriter(out, enc);
                xw = new CharXmlWriter(cfg, w);
                symbols = this._config.getCharSymbols(xw);
            }
            catch (IOException ioe) {
                throw new XMLStreamException(ioe);
            }
        } else {
            if (enc == null) {
                enc = CharsetNames.findEncodingFor(w);
            }
            if (enc != null) {
                cfg.setActualEncodingIfNotSet(enc);
            }
            xw = new CharXmlWriter(cfg, w);
            symbols = this._config.getCharSymbols(xw);
        }
        return new StreamWriterBase(cfg, xw, symbols);
    }
}

