/*
 * Decompiled with CFR 0.152.
 */
package com.azure.xml.implementation.aalto.in;

import com.azure.xml.implementation.aalto.impl.ErrorConsts;
import com.azure.xml.implementation.aalto.impl.LocationImpl;
import com.azure.xml.implementation.aalto.impl.StreamExceptionBase;
import com.azure.xml.implementation.aalto.in.ByteBasedPNameTable;
import com.azure.xml.implementation.aalto.in.ElementScope;
import com.azure.xml.implementation.aalto.in.PName;
import com.azure.xml.implementation.aalto.in.PNameC;
import com.azure.xml.implementation.aalto.in.ReaderConfig;
import com.azure.xml.implementation.aalto.in.XmlScanner;
import com.azure.xml.implementation.aalto.util.DataUtil;
import com.azure.xml.implementation.aalto.util.XmlCharTypes;
import com.azure.xml.implementation.aalto.util.XmlChars;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;

public final class StreamScanner
extends XmlScanner {
    private static final byte BYTE_SPACE = 32;
    private static final byte BYTE_LF = 10;
    private static final byte BYTE_CR = 13;
    private static final byte BYTE_TAB = 9;
    private static final byte BYTE_LT = 60;
    private static final byte BYTE_GT = 62;
    private static final byte BYTE_AMP = 38;
    private static final byte BYTE_HASH = 35;
    private static final byte BYTE_EXCL = 33;
    private static final byte BYTE_HYPHEN = 45;
    private static final byte BYTE_QMARK = 63;
    private static final byte BYTE_SLASH = 47;
    private static final byte BYTE_LBRACKET = 91;
    private static final byte BYTE_RBRACKET = 93;
    private static final byte BYTE_SEMICOLON = 59;
    private static final byte BYTE_a = 97;
    private static final byte BYTE_g = 103;
    private static final byte BYTE_l = 108;
    private static final byte BYTE_m = 109;
    private static final byte BYTE_o = 111;
    private static final byte BYTE_p = 112;
    private static final byte BYTE_q = 113;
    private static final byte BYTE_s = 115;
    private static final byte BYTE_t = 116;
    private static final byte BYTE_u = 117;
    private static final byte BYTE_x = 120;
    private static final byte BYTE_D = 68;
    private static final byte BYTE_P = 80;
    private static final byte BYTE_S = 83;
    private int _inputPtr;
    private int _inputEnd;
    private int _tmpChar = 0;
    private InputStream _in;
    private byte[] _inputBuffer;
    private final XmlCharTypes _charTypes;
    private final ByteBasedPNameTable _symbols;
    private int[] _quadBuffer = new int[32];

    public StreamScanner(ReaderConfig cfg, InputStream in, byte[] buffer, int ptr, int last) {
        super(cfg);
        this._charTypes = cfg.getCharTypes();
        this._symbols = cfg.getBBSymbols();
        this._in = in;
        this._inputBuffer = buffer;
        this._inputPtr = ptr;
        this._inputEnd = last;
        this._pastBytesOrChars = 0L;
        this._rowStartOffset = 0;
    }

    @Override
    protected void _releaseBuffers() {
        super._releaseBuffers();
        if (this._symbols.maybeDirty()) {
            this._config.updateBBSymbols(this._symbols);
        }
        if (this._in != null && this._inputBuffer != null) {
            this._config.freeFullBBuffer(this._inputBuffer);
            this._inputBuffer = null;
        }
    }

    @Override
    protected void _closeSource() throws IOException {
        if (this._in != null) {
            this._in.close();
            this._in = null;
        }
    }

    @Override
    public Location getCurrentLocation() {
        return LocationImpl.fromZeroBased(this._pastBytesOrChars + (long)this._inputPtr, this._currRow, this._inputPtr - this._rowStartOffset);
    }

    private void markLF(int offset) {
        this._rowStartOffset = offset;
        ++this._currRow;
    }

    private void markLF() {
        this._rowStartOffset = this._inputPtr;
        ++this._currRow;
    }

    private void setStartLocation() {
        this._startRawOffset = this._pastBytesOrChars + (long)this._inputPtr;
        this._startRow = this._currRow;
        this._startColumn = this._inputPtr - this._rowStartOffset;
    }

    private int handleEntityInText() throws XMLStreamException {
        int cix;
        String start;
        byte b;
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        if ((b = this._inputBuffer[this._inputPtr++]) == 35) {
            return this.handleCharEntity();
        }
        if (b == 97) {
            byte by = b = this._inputPtr < this._inputEnd ? this._inputBuffer[this._inputPtr++] : this.loadOne();
            if (b == 109) {
                byte by2 = b = this._inputPtr < this._inputEnd ? this._inputBuffer[this._inputPtr++] : this.loadOne();
                if (b == 112) {
                    byte by3 = b = this._inputPtr < this._inputEnd ? this._inputBuffer[this._inputPtr++] : this.loadOne();
                    if (b == 59) {
                        return 38;
                    }
                    start = "amp";
                } else {
                    start = "am";
                }
            } else if (b == 112) {
                byte by4 = b = this._inputPtr < this._inputEnd ? this._inputBuffer[this._inputPtr++] : this.loadOne();
                if (b == 111) {
                    byte by5 = b = this._inputPtr < this._inputEnd ? this._inputBuffer[this._inputPtr++] : this.loadOne();
                    if (b == 115) {
                        byte by6 = b = this._inputPtr < this._inputEnd ? this._inputBuffer[this._inputPtr++] : this.loadOne();
                        if (b == 59) {
                            return 39;
                        }
                        start = "apos";
                    } else {
                        start = "apo";
                    }
                } else {
                    start = "ap";
                }
            } else {
                start = "a";
            }
        } else if (b == 108) {
            byte by = b = this._inputPtr < this._inputEnd ? this._inputBuffer[this._inputPtr++] : this.loadOne();
            if (b == 116) {
                byte by7 = b = this._inputPtr < this._inputEnd ? this._inputBuffer[this._inputPtr++] : this.loadOne();
                if (b == 59) {
                    return 60;
                }
                start = "lt";
            } else {
                start = "l";
            }
        } else if (b == 103) {
            byte by = b = this._inputPtr < this._inputEnd ? this._inputBuffer[this._inputPtr++] : this.loadOne();
            if (b == 116) {
                byte by8 = b = this._inputPtr < this._inputEnd ? this._inputBuffer[this._inputPtr++] : this.loadOne();
                if (b == 59) {
                    return 62;
                }
                start = "gt";
            } else {
                start = "g";
            }
        } else if (b == 113) {
            byte by = b = this._inputPtr < this._inputEnd ? this._inputBuffer[this._inputPtr++] : this.loadOne();
            if (b == 117) {
                byte by9 = b = this._inputPtr < this._inputEnd ? this._inputBuffer[this._inputPtr++] : this.loadOne();
                if (b == 111) {
                    byte by10 = b = this._inputPtr < this._inputEnd ? this._inputBuffer[this._inputPtr++] : this.loadOne();
                    if (b == 116) {
                        byte by11 = b = this._inputPtr < this._inputEnd ? this._inputBuffer[this._inputPtr++] : this.loadOne();
                        if (b == 59) {
                            return 34;
                        }
                        start = "quot";
                    } else {
                        start = "quo";
                    }
                } else {
                    start = "qu";
                }
            } else {
                start = "q";
            }
        } else {
            start = "";
        }
        int[] TYPES = this._charTypes.NAME_CHARS;
        char[] cbuf = this._nameBuffer;
        int len = start.length();
        for (cix = 0; cix < len; ++cix) {
            cbuf[cix] = start.charAt(cix);
        }
        while (b != 59) {
            boolean ok;
            int c = b & 0xFF;
            switch (TYPES[c]) {
                case 0: 
                case 1: 
                case 2: {
                    ok = cix > 0;
                    break;
                }
                case 3: {
                    ok = true;
                    break;
                }
                case 5: {
                    c = this.decodeUtf8_2(c);
                    ok = XmlChars.is10NameStartChar(c);
                    break;
                }
                case 6: {
                    c = this.decodeUtf8_3(c);
                    ok = XmlChars.is10NameStartChar(c);
                    break;
                }
                case 7: {
                    c = this.decodeUtf8_4(c);
                    ok = XmlChars.is10NameStartChar(c);
                    if (!ok) break;
                    if (cix >= cbuf.length) {
                        this._nameBuffer = cbuf = DataUtil.growArrayBy(cbuf, cbuf.length);
                    }
                    cbuf[cix++] = (char)(0xD800 | (c -= 65536) >> 10);
                    c = 0xDC00 | c & 0x3FF;
                    break;
                }
                default: {
                    ok = false;
                }
            }
            if (!ok) {
                this.reportInvalidNameChar(c, cix);
            }
            if (cix >= cbuf.length) {
                this._nameBuffer = cbuf = DataUtil.growArrayBy(cbuf, cbuf.length);
            }
            cbuf[cix++] = (char)c;
            if (this._inputPtr >= this._inputEnd) {
                this.loadMoreGuaranteed();
            }
            b = this._inputBuffer[this._inputPtr++];
        }
        String pname = new String(cbuf, 0, cix);
        this._tokenName = new PNameC(pname, null, pname, 0);
        if (this._config.willExpandEntities()) {
            this.reportInputProblem("General entity reference (&" + pname + ";) encountered in entity expanding mode: operation not (yet) implemented");
        }
        return 0;
    }

    private String parsePublicId(byte quoteChar) throws XMLStreamException {
        char[] outputBuffer = this._nameBuffer;
        int outPtr = 0;
        int[] TYPES = XmlCharTypes.PUBID_CHARS;
        boolean addSpace = false;
        while (true) {
            byte b;
            if (this._inputPtr >= this._inputEnd) {
                this.loadMoreGuaranteed();
            }
            if ((b = this._inputBuffer[this._inputPtr++]) == quoteChar) break;
            int c = b & 0xFF;
            if (TYPES[c] != 1) {
                this.throwUnexpectedChar(c, " in public identifier");
            }
            if (c <= 32) {
                addSpace = true;
                continue;
            }
            if (addSpace) {
                if (outPtr >= outputBuffer.length) {
                    this._nameBuffer = outputBuffer = DataUtil.growArrayBy(outputBuffer, outputBuffer.length);
                    outPtr = 0;
                }
                outputBuffer[outPtr++] = 32;
                addSpace = false;
            }
            if (outPtr >= outputBuffer.length) {
                this._nameBuffer = outputBuffer = DataUtil.growArrayBy(outputBuffer, outputBuffer.length);
                outPtr = 0;
            }
            outputBuffer[outPtr++] = (char)c;
        }
        return new String(outputBuffer, 0, outPtr);
    }

    /*
     * Enabled aggressive block sorting
     */
    private String parseSystemId(byte quoteChar) throws XMLStreamException {
        char[] outputBuffer = this._nameBuffer;
        int outPtr = 0;
        int[] TYPES = this._charTypes.ATTR_CHARS;
        while (true) {
            int c;
            if (this._inputPtr >= this._inputEnd) {
                this.loadMoreGuaranteed();
            }
            if (TYPES[c = this._inputBuffer[this._inputPtr++] & 0xFF] != 0) {
                switch (TYPES[c]) {
                    case 1: {
                        this.handleInvalidXmlChar(c);
                    }
                    case 2: {
                        if (this._inputPtr >= this._inputEnd) {
                            this.loadMoreGuaranteed();
                        }
                        if (this._inputBuffer[this._inputPtr] == 10) {
                            ++this._inputPtr;
                        }
                        this.markLF();
                        c = 10;
                        break;
                    }
                    case 3: {
                        this.markLF();
                        break;
                    }
                    case 5: {
                        c = this.decodeUtf8_2(c);
                        break;
                    }
                    case 6: {
                        c = this.decodeUtf8_3(c);
                        break;
                    }
                    case 7: {
                        c = this.decodeUtf8_4(c);
                        if (outPtr >= outputBuffer.length) {
                            outputBuffer = this._textBuilder.finishCurrentSegment();
                            outPtr = 0;
                        }
                        outputBuffer[outPtr++] = (char)(0xD800 | c >> 10);
                        c = 0xDC00 | c & 0x3FF;
                        break;
                    }
                    case 4: {
                        this.reportInvalidInitial(c);
                    }
                    case 14: {
                        if (c != quoteChar) break;
                        return new String(outputBuffer, 0, outPtr);
                    }
                }
            }
            if (outPtr >= outputBuffer.length) {
                this._nameBuffer = outputBuffer = DataUtil.growArrayBy(outputBuffer, outputBuffer.length);
                outPtr = 0;
            }
            outputBuffer[outPtr++] = (char)c;
        }
    }

    @Override
    public int nextFromProlog(boolean isProlog) throws XMLStreamException {
        byte b;
        if (this._tokenIncomplete) {
            this.skipToken();
        }
        this.setStartLocation();
        while (true) {
            int c;
            if (this._inputPtr >= this._inputEnd && !this.loadMore()) {
                this.setStartLocation();
                return -1;
            }
            if ((c = this._inputBuffer[this._inputPtr++] & 0xFF) == 60) break;
            if (c == 32) continue;
            if (c == 10) {
                this.markLF();
                continue;
            }
            if (c == 13) {
                if (this._inputPtr >= this._inputEnd && !this.loadMore()) {
                    this.markLF();
                    this.setStartLocation();
                    return -1;
                }
                if (this._inputBuffer[this._inputPtr] == 10) {
                    ++this._inputPtr;
                }
                this.markLF();
                continue;
            }
            if (c == 9) continue;
            this.reportPrologUnexpChar(isProlog, this.decodeCharForError((byte)c), null);
        }
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed(5);
        }
        if ((b = this._inputBuffer[this._inputPtr++]) == 33) {
            return this.handlePrologDeclStart(isProlog);
        }
        if (b == 63) {
            return this.handlePIStart();
        }
        if (b == 47 || !isProlog) {
            this.reportPrologUnexpElement(isProlog, b);
        }
        return this.handleStartElement(b);
    }

    @Override
    public int nextFromTree() throws XMLStreamException {
        if (this._tokenIncomplete) {
            if (this.skipToken()) {
                return this._nextEntity();
            }
        } else if (this._currToken == 1) {
            if (this._isEmptyTag) {
                --this._depth;
                this._currToken = 2;
                return 2;
            }
        } else if (this._currToken == 2) {
            this._currElem = this._currElem.getParent();
            while (this._lastNsDecl != null && this._lastNsDecl.getLevel() >= this._depth) {
                this._lastNsDecl = this._lastNsDecl.unbind();
            }
        } else if (this._entityPending) {
            this._entityPending = false;
            return this._nextEntity();
        }
        this.setStartLocation();
        if (this._inputPtr >= this._inputEnd && !this.loadMore()) {
            this.setStartLocation();
            return -1;
        }
        byte b = this._inputBuffer[this._inputPtr];
        if (b == 60) {
            ++this._inputPtr;
            byte by = b = this._inputPtr < this._inputEnd ? this._inputBuffer[this._inputPtr++] : this.loadOne(5);
            if (b == 33) {
                return this.handleCommentOrCdataStart();
            }
            if (b == 63) {
                return this.handlePIStart();
            }
            if (b == 47) {
                return this.handleEndElement();
            }
            return this.handleStartElement(b);
        }
        if (b == 38) {
            ++this._inputPtr;
            int i = this.handleEntityInText();
            if (i == 0) {
                this._currToken = 9;
                return 9;
            }
            this._tmpChar = -i;
        } else {
            this._tmpChar = b & 0xFF;
        }
        this._tokenIncomplete = true;
        this._currToken = 4;
        return 4;
    }

    private int _nextEntity() {
        this._textBuilder.resetWithEmpty();
        this._currToken = 9;
        return 9;
    }

    private int handlePrologDeclStart(boolean isProlog) throws XMLStreamException {
        byte b;
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        if ((b = this._inputBuffer[this._inputPtr++]) == 45) {
            if (this._inputPtr >= this._inputEnd) {
                this.loadMoreGuaranteed();
            }
            if ((b = this._inputBuffer[this._inputPtr++]) == 45) {
                this._tokenIncomplete = true;
                this._currToken = 5;
                return 5;
            }
        } else if (b == 68 && isProlog) {
            this.handleDtdStart();
            return 11;
        }
        this._tokenIncomplete = true;
        this._currToken = 4;
        this.reportPrologUnexpChar(isProlog, this.decodeCharForError(b), " (expected '-' for COMMENT)");
        return this._currToken;
    }

    private void handleDtdStart() throws XMLStreamException {
        this.matchAsciiKeyword("DOCTYPE");
        byte b = this.skipInternalWs(true, "after DOCTYPE keyword, before root name");
        this._tokenName = this.parsePName(b);
        b = this.skipInternalWs(false, null);
        if (b == 80) {
            this.matchAsciiKeyword("PUBLIC");
            b = this.skipInternalWs(true, null);
            this._publicId = this.parsePublicId(b);
            b = this.skipInternalWs(true, null);
            this._systemId = this.parseSystemId(b);
            b = this.skipInternalWs(false, null);
        } else if (b == 83) {
            this.matchAsciiKeyword("SYSTEM");
            b = this.skipInternalWs(true, null);
            this._publicId = null;
            this._systemId = this.parseSystemId(b);
            b = this.skipInternalWs(false, null);
        } else {
            this._systemId = null;
            this._publicId = null;
        }
        if (b == 62) {
            this._tokenIncomplete = false;
            this._currToken = 11;
            return;
        }
        if (b != 91) {
            String msg = this._systemId != null ? " (expected '[' for the internal subset, or '>' to end DOCTYPE declaration)" : " (expected a 'PUBLIC' or 'SYSTEM' keyword, '[' for the internal subset, or '>' to end DOCTYPE declaration)";
            this.reportTreeUnexpChar(this.decodeCharForError(b), msg);
        }
        this._tokenIncomplete = true;
        this._currToken = 11;
    }

    private int handleCommentOrCdataStart() throws XMLStreamException {
        byte b;
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        if ((b = this._inputBuffer[this._inputPtr++]) == 45) {
            if (this._inputPtr >= this._inputEnd) {
                this.loadMoreGuaranteed();
            }
            if ((b = this._inputBuffer[this._inputPtr++]) != 45) {
                this.reportTreeUnexpChar(this.decodeCharForError(b), " (expected '-' for COMMENT)");
            }
            this._tokenIncomplete = true;
            this._currToken = 5;
            return 5;
        }
        if (b == 91) {
            this._currToken = 12;
            for (int i = 0; i < 6; ++i) {
                if (this._inputPtr >= this._inputEnd) {
                    this.loadMoreGuaranteed();
                }
                if ((b = this._inputBuffer[this._inputPtr++]) == (byte)"CDATA[".charAt(i)) continue;
                int ch = this.decodeCharForError(b);
                this.reportTreeUnexpChar(ch, " (expected '" + "CDATA[".charAt(i) + "' for CDATA section)");
            }
            this._tokenIncomplete = true;
            return 12;
        }
        this.reportTreeUnexpChar(this.decodeCharForError(b), " (expected either '-' for COMMENT or '[CDATA[' for CDATA section)");
        return -1;
    }

    private int handlePIStart() throws XMLStreamException {
        int c;
        this._currToken = 3;
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        byte b = this._inputBuffer[this._inputPtr++];
        this._tokenName = this.parsePName(b);
        String ln = this._tokenName.getLocalName();
        if (ln.equalsIgnoreCase("xml") && this._tokenName.getPrefix() == null) {
            this.reportInputProblem(ErrorConsts.ERR_WF_PI_XML_TARGET);
        }
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        if ((c = this._inputBuffer[this._inputPtr++] & 0xFF) <= 32) {
            while (true) {
                if (c == 10) {
                    this.markLF();
                } else if (c == 13) {
                    if (this._inputPtr >= this._inputEnd) {
                        this.loadMoreGuaranteed();
                    }
                    if (this._inputBuffer[this._inputPtr] == 10) {
                        ++this._inputPtr;
                    }
                    this.markLF();
                } else if (c != 32 && c != 9) {
                    this.throwInvalidSpace(c);
                }
                if (this._inputPtr >= this._inputEnd) {
                    this.loadMoreGuaranteed();
                }
                if ((c = this._inputBuffer[this._inputPtr] & 0xFF) > 32) break;
                ++this._inputPtr;
            }
            this._tokenIncomplete = true;
        } else {
            if (c != 63) {
                this.reportMissingPISpace(this.decodeCharForError((byte)c));
            }
            if (this._inputPtr >= this._inputEnd) {
                this.loadMoreGuaranteed();
            }
            if ((b = this._inputBuffer[this._inputPtr++]) != 62) {
                this.reportMissingPISpace(this.decodeCharForError(b));
            }
            this._textBuilder.resetWithEmpty();
            this._tokenIncomplete = false;
        }
        return 3;
    }

    private int handleCharEntity() throws XMLStreamException {
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        byte b = this._inputBuffer[this._inputPtr++];
        int value = 0;
        if (b == 120) {
            while (true) {
                if (this._inputPtr >= this._inputEnd) {
                    this.loadMoreGuaranteed();
                }
                if ((b = this._inputBuffer[this._inputPtr++]) != 59) {
                    value <<= 4;
                    byte c = b;
                    if (c <= 57 && c >= 48) {
                        value += c - 48;
                    } else if (c >= 97 && c <= 102) {
                        value += 10 + (c - 97);
                    } else if (c >= 65 && c <= 70) {
                        value += 10 + (c - 65);
                    } else {
                        this.throwUnexpectedChar(this.decodeCharForError(b), "; expected a hex digit (0-9a-fA-F)");
                    }
                    if (value <= 0x10FFFF) continue;
                    this.reportEntityOverflow();
                    continue;
                }
                break;
            }
        } else {
            while (b != 59) {
                byte c = b;
                if (c <= 57 && c >= 48) {
                    if ((value = value * 10 + (c - 48)) > 0x10FFFF) {
                        this.reportEntityOverflow();
                    }
                } else {
                    this.throwUnexpectedChar(this.decodeCharForError(b), "; expected a decimal number");
                }
                if (this._inputPtr >= this._inputEnd) {
                    this.loadMoreGuaranteed();
                }
                b = this._inputBuffer[this._inputPtr++];
            }
        }
        this.verifyXmlChar(value);
        return value;
    }

    private int handleStartElement(byte b) throws XMLStreamException {
        boolean allBound;
        this._currToken = 1;
        this._currNsCount = 0;
        PName elemName = this.parsePName(b);
        String prefix = elemName.getPrefix();
        if (prefix == null) {
            allBound = true;
        } else {
            elemName = this.bindName(elemName, prefix);
            allBound = elemName.isBound();
        }
        this._tokenName = elemName;
        this._currElem = new ElementScope(elemName, this._currElem);
        int attrPtr = 0;
        while (true) {
            boolean isNsDecl;
            PName attrName;
            int c;
            if (this._inputPtr >= this._inputEnd) {
                this.loadMoreGuaranteed();
            }
            if ((c = (b = this._inputBuffer[this._inputPtr++]) & 0xFF) <= 32) {
                do {
                    if (c == 10) {
                        this.markLF();
                    } else if (c == 13) {
                        if (this._inputPtr >= this._inputEnd) {
                            this.loadMoreGuaranteed();
                        }
                        if (this._inputBuffer[this._inputPtr] == 10) {
                            ++this._inputPtr;
                        }
                        this.markLF();
                    } else if (c != 32 && c != 9) {
                        this.throwInvalidSpace(c);
                    }
                    if (this._inputPtr < this._inputEnd) continue;
                    this.loadMoreGuaranteed();
                } while ((c = (b = this._inputBuffer[this._inputPtr++]) & 0xFF) <= 32);
            } else if (c != 47 && c != 62) {
                c = this.decodeCharForError(b);
                this.throwUnexpectedChar(c, " expected space, or '>' or \"/>\"");
            }
            if (c == 47) {
                if (this._inputPtr >= this._inputEnd) {
                    this.loadMoreGuaranteed();
                }
                if ((b = this._inputBuffer[this._inputPtr++]) != 62) {
                    c = this.decodeCharForError(b);
                    this.throwUnexpectedChar(c, " expected '>'");
                }
                this._isEmptyTag = true;
                break;
            }
            if (c == 62) {
                this._isEmptyTag = false;
                break;
            }
            if (c == 60) {
                this.reportInputProblem("Unexpected '<' character in element (missing closing '>'?)");
            }
            if ((prefix = (attrName = this.parsePName(b)).getPrefix()) == null) {
                isNsDecl = Objects.equals(attrName.getLocalName(), "xmlns");
            } else if (prefix.equals("xmlns")) {
                isNsDecl = true;
            } else {
                attrName = this.bindName(attrName, prefix);
                if (allBound) {
                    allBound = attrName.isBound();
                }
                isNsDecl = false;
            }
            while (true) {
                if (this._inputPtr >= this._inputEnd) {
                    this.loadMoreGuaranteed();
                }
                if ((c = (b = this._inputBuffer[this._inputPtr++]) & 0xFF) > 32) break;
                if (c == 10) {
                    this.markLF();
                    continue;
                }
                if (c == 13) {
                    if (this._inputPtr >= this._inputEnd) {
                        this.loadMoreGuaranteed();
                    }
                    if (this._inputBuffer[this._inputPtr] == 10) {
                        ++this._inputPtr;
                    }
                    this.markLF();
                    continue;
                }
                if (c == 32 || c == 9) continue;
                this.throwInvalidSpace(c);
            }
            if (c != 61) {
                c = this.decodeCharForError(b);
                this.throwUnexpectedChar(c, " expected '='");
            }
            while (true) {
                if (this._inputPtr >= this._inputEnd) {
                    this.loadMoreGuaranteed();
                }
                if ((c = (b = this._inputBuffer[this._inputPtr++]) & 0xFF) > 32) break;
                if (c == 10) {
                    this.markLF();
                    continue;
                }
                if (c == 13) {
                    if (this._inputPtr >= this._inputEnd) {
                        this.loadMoreGuaranteed();
                    }
                    if (this._inputBuffer[this._inputPtr] == 10) {
                        ++this._inputPtr;
                    }
                    this.markLF();
                    continue;
                }
                if (c == 32 || c == 9) continue;
                this.throwInvalidSpace(c);
            }
            if (c != 34 && c != 39) {
                c = this.decodeCharForError(b);
                this.throwUnexpectedChar(c, " Expected a quote");
            }
            if (isNsDecl) {
                this.handleNsDeclaration(attrName, b);
                ++this._currNsCount;
                continue;
            }
            attrPtr = this.collectValue(attrPtr, b, attrName);
        }
        int act = this._attrCollector.finishLastValue(attrPtr);
        if (act < 0) {
            act = this._attrCollector.getCount();
            this.reportInputProblem(this._attrCollector.getErrorMsg());
        }
        this._attrCount = act;
        ++this._depth;
        if (!allBound) {
            if (!elemName.isBound()) {
                this.reportUnboundPrefix(this._tokenName, false);
            }
            int len = this._attrCount;
            for (int i = 0; i < len; ++i) {
                PName attrName = this._attrCollector.getName(i);
                if (attrName.isBound()) continue;
                this.reportUnboundPrefix(attrName, true);
            }
        }
        return 1;
    }

    /*
     * Unable to fully structure code
     */
    private int collectValue(int attrPtr, byte quoteByte, PName attrName) throws XMLStreamException {
        attrBuffer = this._attrCollector.startNewValue(attrName, attrPtr);
        TYPES = this._charTypes.ATTR_CHARS;
        block13: while (true) {
            block25: {
                if ((ptr = this._inputPtr) >= this._inputEnd) {
                    this.loadMoreGuaranteed();
                    ptr = this._inputPtr;
                }
                if (attrPtr >= attrBuffer.length) {
                    attrBuffer = this._attrCollector.valueBufferFull();
                }
                if ((max2 = ptr + (attrBuffer.length - attrPtr)) < (max = this._inputEnd)) {
                    max = max2;
                }
                while (ptr < max) {
                    if (TYPES[c = this._inputBuffer[ptr++] & 255] == 0) {
                        attrBuffer[attrPtr++] = (char)c;
                        continue;
                    }
                    break block25;
                }
                this._inputPtr = ptr;
                continue;
            }
            this._inputPtr = ptr;
            switch (TYPES[c]) {
                case 1: {
                    this.handleInvalidXmlChar(c);
                }
                case 2: {
                    if (this._inputPtr >= this._inputEnd) {
                        this.loadMoreGuaranteed();
                    }
                    if (this._inputBuffer[this._inputPtr] == 10) {
                        ++this._inputPtr;
                    }
                }
                case 3: {
                    this.markLF();
                }
                case 8: {
                    c = 32;
                    ** GOTO lbl63
                }
                case 5: {
                    c = this.decodeUtf8_2(c);
                    ** GOTO lbl63
                }
                case 6: {
                    c = this.decodeUtf8_3(c);
                    ** GOTO lbl63
                }
                case 7: {
                    c = this.decodeUtf8_4(c);
                    attrBuffer[attrPtr++] = (char)(55296 | c >> 10);
                    c = 56320 | c & 1023;
                    if (attrPtr >= attrBuffer.length) {
                        attrBuffer = this._attrCollector.valueBufferFull();
                    }
                    ** GOTO lbl63
                }
                case 4: {
                    this.reportInvalidInitial(c);
                }
                case 9: {
                    this.throwUnexpectedChar(c, "'<' not allowed in attribute value");
                }
                case 10: {
                    c = this.handleEntityInText();
                    if (c == 0) {
                        this.reportUnexpandedEntityInAttr(false);
                    }
                    if (c >> 16 != 0) {
                        attrBuffer[attrPtr++] = (char)(55296 | (c -= 65536) >> 10);
                        c = 56320 | c & 1023;
                        if (attrPtr >= attrBuffer.length) {
                            attrBuffer = this._attrCollector.valueBufferFull();
                        }
                    }
                    ** GOTO lbl63
                }
                case 14: {
                    if (c == quoteByte) break block13;
                }
lbl63:
                // 7 sources

                default: {
                    attrBuffer[attrPtr++] = (char)c;
                    continue block13;
                }
            }
            break;
        }
        return attrPtr;
    }

    private void handleNsDeclaration(PName name, byte quoteByte) throws XMLStreamException {
        int attrPtr = 0;
        char[] attrBuffer = this._nameBuffer;
        while (true) {
            int c;
            int b;
            if (this._inputPtr >= this._inputEnd) {
                this.loadMoreGuaranteed();
            }
            if ((b = this._inputBuffer[this._inputPtr++]) == quoteByte) break;
            if (b == 38) {
                c = this.handleEntityInText();
                if (c == 0) {
                    this.reportUnexpandedEntityInAttr(true);
                }
                if (c >> 16 != 0) {
                    if (attrPtr >= attrBuffer.length) {
                        this._nameBuffer = attrBuffer = DataUtil.growArrayBy(attrBuffer, attrBuffer.length);
                    }
                    attrBuffer[attrPtr++] = (char)(0xD800 | (c -= 65536) >> 10);
                    c = 0xDC00 | c & 0x3FF;
                }
            } else if (b == 60) {
                c = b;
                this.throwUnexpectedChar(c, "'<' not allowed in attribute value");
            } else {
                c = b & 0xFF;
                if (c < 32) {
                    if (c == 10) {
                        this.markLF();
                    } else if (c == 13) {
                        if (this._inputPtr >= this._inputEnd) {
                            this.loadMoreGuaranteed();
                        }
                        if (this._inputBuffer[this._inputPtr] == 10) {
                            ++this._inputPtr;
                        }
                        this.markLF();
                    } else if (c != 9) {
                        this.throwInvalidSpace(c);
                    }
                } else if (c > 127 && (c = this.decodeMultiByteChar(c, this._inputPtr)) < 0) {
                    c = -c;
                    if (attrPtr >= attrBuffer.length) {
                        this._nameBuffer = attrBuffer = DataUtil.growArrayBy(attrBuffer, attrBuffer.length);
                    }
                    attrBuffer[attrPtr++] = (char)(0xD800 | (c -= 65536) >> 10);
                    c = 0xDC00 | c & 0x3FF;
                }
            }
            if (attrPtr >= attrBuffer.length) {
                this._nameBuffer = attrBuffer = DataUtil.growArrayBy(attrBuffer, attrBuffer.length);
            }
            attrBuffer[attrPtr++] = (char)c;
        }
        if (attrPtr == 0) {
            this.bindNs(name, "");
        } else {
            String uri = this._config.canonicalizeURI(attrBuffer, attrPtr);
            this.bindNs(name, uri);
        }
    }

    private int handleEndElement() throws XMLStreamException {
        int q;
        --this._depth;
        this._currToken = 2;
        this._tokenName = this._currElem.getName();
        int size = this._tokenName.sizeInQuads();
        if (this._inputEnd - this._inputPtr < (size << 2) + 1) {
            return this.handleEndElementSlow(size);
        }
        int ptr = this._inputPtr;
        byte[] buf = this._inputBuffer;
        --size;
        for (int qix = 0; qix < size; ++qix) {
            q = buf[ptr] << 24 | (buf[ptr + 1] & 0xFF) << 16 | (buf[ptr + 2] & 0xFF) << 8 | buf[ptr + 3] & 0xFF;
            ptr += 4;
            if (q == this._tokenName.getQuad(qix)) continue;
            this._inputPtr = ptr;
            this.reportUnexpectedEndTag(this._tokenName.getPrefixedName());
        }
        int lastQ = this._tokenName.getQuad(size);
        if ((q = buf[ptr++] & 0xFF) != lastQ && (q = q << 8 | buf[ptr++] & 0xFF) != lastQ && (q = q << 8 | buf[ptr++] & 0xFF) != lastQ && (q = q << 8 | buf[ptr++] & 0xFF) != lastQ) {
            this._inputPtr = ptr;
            this.reportUnexpectedEndTag(this._tokenName.getPrefixedName());
        }
        int i2 = this._inputBuffer[ptr] & 0xFF;
        this._inputPtr = ptr + 1;
        while (i2 <= 32) {
            if (i2 == 10) {
                this.markLF();
            } else if (i2 == 13) {
                byte b;
                byte by = b = this._inputPtr < this._inputEnd ? this._inputBuffer[this._inputPtr++] : this.loadOne();
                if (b != 10) {
                    this.markLF(this._inputPtr - 1);
                    i2 = b & 0xFF;
                    continue;
                }
                this.markLF();
            } else if (i2 != 32 && i2 != 9) {
                this.throwInvalidSpace(i2);
            }
            i2 = (this._inputPtr < this._inputEnd ? this._inputBuffer[this._inputPtr++] : this.loadOne()) & 0xFF;
        }
        if (i2 != 62) {
            this.throwUnexpectedChar(this.decodeCharForError((byte)i2), " expected space or closing '>'");
        }
        return 2;
    }

    private int handleEndElementSlow(int size) throws XMLStreamException {
        block14: {
            int i;
            int q;
            --size;
            for (int qix = 0; qix < size; ++qix) {
                q = 0;
                for (i = 0; i < 4; ++i) {
                    if (this._inputPtr >= this._inputEnd) {
                        this.loadMoreGuaranteed();
                    }
                    q = q << 8 | this._inputBuffer[this._inputPtr++] & 0xFF;
                }
                if (q == this._tokenName.getQuad(qix)) continue;
                this.reportUnexpectedEndTag(this._tokenName.getPrefixedName());
            }
            int lastQ = this._tokenName.getQuad(size);
            q = 0;
            i = 0;
            do {
                if (this._inputPtr >= this._inputEnd) {
                    this.loadMoreGuaranteed();
                }
                if ((q = q << 8 | this._inputBuffer[this._inputPtr++] & 0xFF) == lastQ) break block14;
            } while (++i <= 3);
            this.reportUnexpectedEndTag(this._tokenName.getPrefixedName());
        }
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        int i2 = this._inputBuffer[this._inputPtr++];
        while (i2 <= 32) {
            if (i2 == 10) {
                this.markLF();
            } else if (i2 == 13) {
                byte b;
                byte by = b = this._inputPtr < this._inputEnd ? this._inputBuffer[this._inputPtr++] : this.loadOne();
                if (b != 10) {
                    this.markLF(this._inputPtr - 1);
                    i2 = b & 0xFF;
                    continue;
                }
                this.markLF();
            } else if (i2 != 32 && i2 != 9) {
                this.throwInvalidSpace(i2);
            }
            i2 = (this._inputPtr < this._inputEnd ? this._inputBuffer[this._inputPtr++] : this.loadOne()) & 0xFF;
        }
        if (i2 != 62) {
            this.throwUnexpectedChar(this.decodeCharForError((byte)i2), " expected space or closing '>'");
        }
        return 2;
    }

    private PName parsePName(byte b) throws XMLStreamException {
        int i2;
        if (this._inputEnd - this._inputPtr < 8) {
            return this.parsePNameSlow(b);
        }
        int q = b & 0xFF;
        if (q < 65) {
            this.throwUnexpectedChar(q, "; expected a name start character");
        }
        if ((i2 = this._inputBuffer[this._inputPtr++] & 0xFF) < 65 && (i2 < 45 || i2 > 58 || i2 == 47)) {
            return this.findPName(q, 1);
        }
        q = q << 8 | i2;
        if ((i2 = this._inputBuffer[this._inputPtr++] & 0xFF) < 65 && (i2 < 45 || i2 > 58 || i2 == 47)) {
            return this.findPName(q, 2);
        }
        q = q << 8 | i2;
        if ((i2 = this._inputBuffer[this._inputPtr++] & 0xFF) < 65 && (i2 < 45 || i2 > 58 || i2 == 47)) {
            return this.findPName(q, 3);
        }
        q = q << 8 | i2;
        if ((i2 = this._inputBuffer[this._inputPtr++] & 0xFF) < 65 && (i2 < 45 || i2 > 58 || i2 == 47)) {
            return this.findPName(q, 4);
        }
        return this.parsePNameMedium(i2, q);
    }

    private PName parsePNameMedium(int i2, int q1) throws XMLStreamException {
        int q2 = i2;
        if ((i2 = this._inputBuffer[this._inputPtr++] & 0xFF) < 65 && (i2 < 45 || i2 > 58 || i2 == 47)) {
            return this.findPName(q1, q2, 1);
        }
        q2 = q2 << 8 | i2;
        if ((i2 = this._inputBuffer[this._inputPtr++] & 0xFF) < 65 && (i2 < 45 || i2 > 58 || i2 == 47)) {
            return this.findPName(q1, q2, 2);
        }
        q2 = q2 << 8 | i2;
        if ((i2 = this._inputBuffer[this._inputPtr++] & 0xFF) < 65 && (i2 < 45 || i2 > 58 || i2 == 47)) {
            return this.findPName(q1, q2, 3);
        }
        q2 = q2 << 8 | i2;
        if ((i2 = this._inputBuffer[this._inputPtr++] & 0xFF) < 65 && (i2 < 45 || i2 > 58 || i2 == 47)) {
            return this.findPName(q1, q2, 4);
        }
        int[] quads = this._quadBuffer;
        quads[0] = q1;
        quads[1] = q2;
        return this.parsePNameLong(i2, quads);
    }

    private PName parsePNameLong(int q, int[] quads) throws XMLStreamException {
        int qix = 2;
        while (true) {
            int i2;
            if (this._inputPtr >= this._inputEnd) {
                this.loadMoreGuaranteed();
            }
            if ((i2 = this._inputBuffer[this._inputPtr++] & 0xFF) < 65 && (i2 < 45 || i2 > 58 || i2 == 47)) {
                return this.findPName(q, quads, qix, 1);
            }
            q = q << 8 | i2;
            i2 = (this._inputPtr < this._inputEnd ? this._inputBuffer[this._inputPtr++] : this.loadOne()) & 0xFF;
            if (i2 < 65 && (i2 < 45 || i2 > 58 || i2 == 47)) {
                return this.findPName(q, quads, qix, 2);
            }
            q = q << 8 | i2;
            i2 = (this._inputPtr < this._inputEnd ? this._inputBuffer[this._inputPtr++] : this.loadOne()) & 0xFF;
            if (i2 < 65 && (i2 < 45 || i2 > 58 || i2 == 47)) {
                return this.findPName(q, quads, qix, 3);
            }
            q = q << 8 | i2;
            i2 = (this._inputPtr < this._inputEnd ? this._inputBuffer[this._inputPtr++] : this.loadOne()) & 0xFF;
            if (i2 < 65 && (i2 < 45 || i2 > 58 || i2 == 47)) {
                return this.findPName(q, quads, qix, 4);
            }
            if (qix >= quads.length) {
                quads = DataUtil.growArrayBy(quads, quads.length);
                this._quadBuffer = quads;
            }
            quads[qix] = q;
            ++qix;
            q = i2;
        }
    }

    private PName parsePNameSlow(byte b) throws XMLStreamException {
        int q = b & 0xFF;
        if (q < 65) {
            this.throwUnexpectedChar(q, "; expected a name start character");
        }
        int[] quads = this._quadBuffer;
        int qix = 0;
        int firstQuad = 0;
        while (true) {
            int i2;
            if (this._inputPtr >= this._inputEnd) {
                this.loadMoreGuaranteed();
            }
            if ((i2 = this._inputBuffer[this._inputPtr++] & 0xFF) < 65 && (i2 < 45 || i2 > 58 || i2 == 47)) {
                return this.findPName(q, 1, firstQuad, qix, quads);
            }
            q = q << 8 | i2;
            i2 = (this._inputPtr < this._inputEnd ? this._inputBuffer[this._inputPtr++] : this.loadOne()) & 0xFF;
            if (i2 < 65 && (i2 < 45 || i2 > 58 || i2 == 47)) {
                return this.findPName(q, 2, firstQuad, qix, quads);
            }
            q = q << 8 | i2;
            i2 = (this._inputPtr < this._inputEnd ? this._inputBuffer[this._inputPtr++] : this.loadOne()) & 0xFF;
            if (i2 < 65 && (i2 < 45 || i2 > 58 || i2 == 47)) {
                return this.findPName(q, 3, firstQuad, qix, quads);
            }
            q = q << 8 | i2;
            i2 = (this._inputPtr < this._inputEnd ? this._inputBuffer[this._inputPtr++] : this.loadOne()) & 0xFF;
            if (i2 < 65 && (i2 < 45 || i2 > 58 || i2 == 47)) {
                return this.findPName(q, 4, firstQuad, qix, quads);
            }
            if (qix == 0) {
                firstQuad = q;
            } else if (qix == 1) {
                quads[0] = firstQuad;
                quads[1] = q;
            } else {
                if (qix >= quads.length) {
                    this._quadBuffer = quads = DataUtil.growArrayBy(quads, quads.length);
                }
                quads[qix] = q;
            }
            ++qix;
            q = i2;
        }
    }

    private PName findPName(int onlyQuad, int lastByteCount) throws XMLStreamException {
        --this._inputPtr;
        int hash = ByteBasedPNameTable.calcHash(onlyQuad);
        PName name = this._symbols.findSymbol(hash, onlyQuad, 0);
        if (name == null) {
            this._quadBuffer[0] = onlyQuad;
            name = this.addPName(hash, this._quadBuffer, 1, lastByteCount);
        }
        return name;
    }

    private PName findPName(int firstQuad, int secondQuad, int lastByteCount) throws XMLStreamException {
        --this._inputPtr;
        int hash = ByteBasedPNameTable.calcHash(firstQuad, secondQuad);
        PName name = this._symbols.findSymbol(hash, firstQuad, secondQuad);
        if (name == null) {
            this._quadBuffer[0] = firstQuad;
            this._quadBuffer[1] = secondQuad;
            name = this.addPName(hash, this._quadBuffer, 2, lastByteCount);
        }
        return name;
    }

    private PName findPName(int lastQuad, int[] quads, int qlen, int lastByteCount) throws XMLStreamException {
        --this._inputPtr;
        if (qlen >= quads.length) {
            quads = DataUtil.growArrayBy(quads, quads.length);
            this._quadBuffer = quads;
        }
        quads[qlen++] = lastQuad;
        int hash = ByteBasedPNameTable.calcHash(quads, qlen);
        PName name = this._symbols.findSymbol(hash, quads, qlen);
        if (name == null) {
            name = this.addPName(hash, quads, qlen, lastByteCount);
        }
        return name;
    }

    private PName findPName(int lastQuad, int lastByteCount, int firstQuad, int qlen, int[] quads) throws XMLStreamException {
        if (qlen <= 1) {
            if (qlen == 0) {
                return this.findPName(lastQuad, lastByteCount);
            }
            return this.findPName(firstQuad, lastQuad, lastByteCount);
        }
        return this.findPName(lastQuad, quads, qlen, lastByteCount);
    }

    private PName addPName(int hash, int[] quads, int qlen, int lastQuadBytes) throws XMLStreamException {
        return this.addUTFPName(this._symbols, this._charTypes, hash, quads, qlen, lastQuadBytes);
    }

    private byte skipInternalWs(boolean reqd, String msg) throws XMLStreamException {
        byte b;
        int c;
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        if ((c = (b = this._inputBuffer[this._inputPtr++]) & 0xFF) > 32) {
            if (!reqd) {
                return b;
            }
            this.reportTreeUnexpChar(this.decodeCharForError(b), " (expected white space " + msg + ")");
        }
        do {
            if (b == 10) {
                this.markLF();
            } else if (b == 13) {
                if (this._inputPtr >= this._inputEnd) {
                    this.loadMoreGuaranteed();
                }
                if (this._inputBuffer[this._inputPtr] == 10) {
                    ++this._inputPtr;
                }
                this.markLF();
            } else if (b != 32 && b != 9) {
                this.throwInvalidSpace(b);
            }
            if (this._inputPtr < this._inputEnd) continue;
            this.loadMoreGuaranteed();
        } while (((b = this._inputBuffer[this._inputPtr++]) & 0xFF) <= 32);
        return b;
    }

    private void matchAsciiKeyword(String keyw) throws XMLStreamException {
        int len = keyw.length();
        for (int i = 1; i < len; ++i) {
            byte b;
            if (this._inputPtr >= this._inputEnd) {
                this.loadMoreGuaranteed();
            }
            if ((b = this._inputBuffer[this._inputPtr++]) == (byte)keyw.charAt(i)) continue;
            this.reportTreeUnexpChar(this.decodeCharForError(b), " (expected '" + keyw.charAt(i) + "' for " + keyw + " keyword)");
        }
    }

    private int checkInTreeIndentation(int c) throws XMLStreamException {
        int count;
        int max;
        byte b;
        if (c == 13) {
            if (this._inputPtr >= this._inputEnd && !this.loadMore()) {
                this._textBuilder.resetWithIndentation(0, ' ');
                return -1;
            }
            if (this._inputBuffer[this._inputPtr] == 10) {
                ++this._inputPtr;
            }
        }
        this.markLF();
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        if ((b = this._inputBuffer[this._inputPtr]) != 32 && b != 9) {
            if (b == 60 && this._inputPtr + 1 < this._inputEnd && this._inputBuffer[this._inputPtr + 1] != 33) {
                this._textBuilder.resetWithIndentation(0, ' ');
                return -1;
            }
            char[] outBuf = this._textBuilder.resetWithEmpty();
            outBuf[0] = 10;
            this._textBuilder.setCurrentLength(1);
            return 1;
        }
        ++this._inputPtr;
        int n = max = b == 32 ? 32 : 8;
        for (count = 1; count <= max; ++count) {
            byte b2;
            if (this._inputPtr >= this._inputEnd) {
                this.loadMoreGuaranteed();
            }
            if ((b2 = this._inputBuffer[this._inputPtr]) != b) {
                if (b2 != 60 || this._inputPtr + 1 >= this._inputEnd || this._inputBuffer[this._inputPtr + 1] == 33) break;
                this._textBuilder.resetWithIndentation(count, (char)b);
                return -1;
            }
            ++this._inputPtr;
        }
        char[] outBuf = this._textBuilder.resetWithEmpty();
        outBuf[0] = 10;
        char ind = (char)b;
        for (int i = 1; i <= count; ++i) {
            outBuf[i] = ind;
        }
        this._textBuilder.setCurrentLength(++count);
        return count;
    }

    private int checkPrologIndentation(int c) throws XMLStreamException {
        int max;
        if (c == 13) {
            if (this._inputPtr >= this._inputEnd && !this.loadMore()) {
                this._textBuilder.resetWithIndentation(0, ' ');
                return -1;
            }
            if (this._inputBuffer[this._inputPtr] == 10) {
                ++this._inputPtr;
            }
        }
        this.markLF();
        if (this._inputPtr >= this._inputEnd && !this.loadMore()) {
            this._textBuilder.resetWithIndentation(0, ' ');
            return -1;
        }
        byte b = this._inputBuffer[this._inputPtr];
        if (b != 32 && b != 9) {
            if (b == 60) {
                this._textBuilder.resetWithIndentation(0, ' ');
                return -1;
            }
            char[] outBuf = this._textBuilder.resetWithEmpty();
            outBuf[0] = 10;
            this._textBuilder.setCurrentLength(1);
            return 1;
        }
        ++this._inputPtr;
        int count = 1;
        int n = max = b == 32 ? 32 : 8;
        while ((this._inputPtr < this._inputEnd || this.loadMore()) && this._inputBuffer[this._inputPtr] == b) {
            ++this._inputPtr;
            if (++count < max) continue;
            char[] outBuf = this._textBuilder.resetWithEmpty();
            outBuf[0] = 10;
            char ind = (char)b;
            for (int i = 1; i <= count; ++i) {
                outBuf[i] = ind;
            }
            this._textBuilder.setCurrentLength(++count);
            return count;
        }
        this._textBuilder.resetWithIndentation(count, (char)b);
        return -1;
    }

    @Override
    protected boolean loadMore() throws XMLStreamException {
        this._pastBytesOrChars += (long)this._inputEnd;
        this._rowStartOffset -= this._inputEnd;
        this._inputPtr = 0;
        if (this._in == null) {
            this._inputEnd = 0;
            return false;
        }
        try {
            int count = this._in.read(this._inputBuffer, 0, this._inputBuffer.length);
            if (count < 1) {
                this._inputEnd = 0;
                if (count == 0) {
                    this.reportInputProblem("InputStream returned 0 bytes, even when asked to read up to " + this._inputBuffer.length);
                }
                return false;
            }
            this._inputEnd = count;
            return true;
        }
        catch (IOException ioe) {
            throw new StreamExceptionBase(ioe);
        }
    }

    @Override
    protected boolean skipCharacters() throws XMLStreamException {
        int[] TYPES = this._charTypes.TEXT_CHARS;
        byte[] inputBuffer = this._inputBuffer;
        block12: while (true) {
            int c;
            int ptr;
            block19: {
                int max;
                if ((ptr = this._inputPtr) >= (max = this._inputEnd)) {
                    this.loadMoreGuaranteed();
                    ptr = this._inputPtr;
                    max = this._inputEnd;
                }
                while (ptr < max) {
                    if (TYPES[c = inputBuffer[ptr++] & 0xFF] == 0) continue;
                    break block19;
                }
                this._inputPtr = ptr;
                continue;
            }
            this._inputPtr = ptr;
            switch (TYPES[c]) {
                case 1: {
                    this.handleInvalidXmlChar(c);
                }
                case 2: {
                    if (this._inputPtr >= this._inputEnd) {
                        this.loadMoreGuaranteed();
                    }
                    if (inputBuffer[this._inputPtr] == 10) {
                        ++this._inputPtr;
                    }
                    this.markLF();
                    break;
                }
                case 3: {
                    this.markLF();
                    break;
                }
                case 5: {
                    this.skipUtf8_2();
                    break;
                }
                case 6: {
                    this.skipUtf8_3(c);
                    break;
                }
                case 7: {
                    this.skipUtf8_4();
                    break;
                }
                case 4: {
                    this.reportInvalidInitial(c);
                }
                case 9: {
                    --this._inputPtr;
                    return false;
                }
                case 10: {
                    c = this.handleEntityInText();
                    if (c != 0) break;
                    return true;
                }
                case 11: {
                    byte b;
                    int count = 1;
                    while (true) {
                        if (this._inputPtr >= this._inputEnd) {
                            this.loadMoreGuaranteed();
                        }
                        if ((b = inputBuffer[this._inputPtr]) != 93) break;
                        ++this._inputPtr;
                        ++count;
                    }
                    if (b != 62 || count <= true) continue block12;
                    this.reportIllegalCDataEnd();
                }
            }
        }
    }

    @Override
    protected void skipComment() throws XMLStreamException {
        int[] TYPES = this._charTypes.OTHER_CHARS;
        byte[] inputBuffer = this._inputBuffer;
        while (true) {
            int c;
            int ptr;
            block18: {
                int max;
                if ((ptr = this._inputPtr) >= (max = this._inputEnd)) {
                    this.loadMoreGuaranteed();
                    ptr = this._inputPtr;
                    max = this._inputEnd;
                }
                while (ptr < max) {
                    if (TYPES[c = inputBuffer[ptr++] & 0xFF] == 0) continue;
                    break block18;
                }
                this._inputPtr = ptr;
                continue;
            }
            this._inputPtr = ptr;
            switch (TYPES[c]) {
                case 1: {
                    this.handleInvalidXmlChar(c);
                }
                case 2: {
                    if (this._inputPtr >= this._inputEnd) {
                        this.loadMoreGuaranteed();
                    }
                    if (inputBuffer[this._inputPtr] == 10) {
                        ++this._inputPtr;
                    }
                    this.markLF();
                    break;
                }
                case 3: {
                    this.markLF();
                    break;
                }
                case 5: {
                    this.skipUtf8_2();
                    break;
                }
                case 6: {
                    this.skipUtf8_3(c);
                    break;
                }
                case 7: {
                    this.skipUtf8_4();
                    break;
                }
                case 4: {
                    this.reportInvalidInitial(c);
                }
                case 13: {
                    if (this._inputPtr >= this._inputEnd) {
                        this.loadMoreGuaranteed();
                    }
                    if (this._inputBuffer[this._inputPtr] != 45) break;
                    ++this._inputPtr;
                    if (this._inputPtr >= this._inputEnd) {
                        this.loadMoreGuaranteed();
                    }
                    if (this._inputBuffer[this._inputPtr++] != 62) {
                        this.reportDoubleHyphenInComments();
                    }
                    return;
                }
            }
        }
    }

    @Override
    protected void skipCData() throws XMLStreamException {
        int[] TYPES = this._charTypes.OTHER_CHARS;
        byte[] inputBuffer = this._inputBuffer;
        while (true) {
            int c;
            int ptr;
            block18: {
                int max;
                if ((ptr = this._inputPtr) >= (max = this._inputEnd)) {
                    this.loadMoreGuaranteed();
                    ptr = this._inputPtr;
                    max = this._inputEnd;
                }
                while (ptr < max) {
                    if (TYPES[c = inputBuffer[ptr++] & 0xFF] == 0) continue;
                    break block18;
                }
                this._inputPtr = ptr;
                continue;
            }
            this._inputPtr = ptr;
            switch (TYPES[c]) {
                case 1: {
                    this.handleInvalidXmlChar(c);
                }
                case 2: {
                    if (this._inputPtr >= this._inputEnd) {
                        this.loadMoreGuaranteed();
                    }
                    if (inputBuffer[this._inputPtr] == 10) {
                        ++this._inputPtr;
                    }
                    this.markLF();
                    break;
                }
                case 3: {
                    this.markLF();
                    break;
                }
                case 5: {
                    this.skipUtf8_2();
                    break;
                }
                case 6: {
                    this.skipUtf8_3(c);
                    break;
                }
                case 7: {
                    this.skipUtf8_4();
                    break;
                }
                case 4: {
                    this.reportInvalidInitial(c);
                }
                case 11: {
                    byte b;
                    int count = 0;
                    do {
                        if (this._inputPtr >= this._inputEnd) {
                            this.loadMoreGuaranteed();
                        }
                        ++count;
                    } while ((b = this._inputBuffer[this._inputPtr++]) == 93);
                    if (b == 62) {
                        if (count <= 1) break;
                        return;
                    }
                    --this._inputPtr;
                }
            }
        }
    }

    @Override
    protected void skipPI() throws XMLStreamException {
        int[] TYPES = this._charTypes.OTHER_CHARS;
        byte[] inputBuffer = this._inputBuffer;
        while (true) {
            int c;
            int ptr;
            block16: {
                int max;
                if ((ptr = this._inputPtr) >= (max = this._inputEnd)) {
                    this.loadMoreGuaranteed();
                    ptr = this._inputPtr;
                    max = this._inputEnd;
                }
                while (ptr < max) {
                    if (TYPES[c = inputBuffer[ptr++] & 0xFF] == 0) continue;
                    break block16;
                }
                this._inputPtr = ptr;
                continue;
            }
            this._inputPtr = ptr;
            switch (TYPES[c]) {
                case 1: {
                    this.handleInvalidXmlChar(c);
                }
                case 2: {
                    if (this._inputPtr >= this._inputEnd) {
                        this.loadMoreGuaranteed();
                    }
                    if (inputBuffer[this._inputPtr] == 10) {
                        ++this._inputPtr;
                    }
                    this.markLF();
                    break;
                }
                case 3: {
                    this.markLF();
                    break;
                }
                case 5: {
                    this.skipUtf8_2();
                    break;
                }
                case 6: {
                    this.skipUtf8_3(c);
                    break;
                }
                case 7: {
                    this.skipUtf8_4();
                    break;
                }
                case 4: {
                    this.reportInvalidInitial(c);
                }
                case 12: {
                    if (this._inputPtr >= this._inputEnd) {
                        this.loadMoreGuaranteed();
                    }
                    if (this._inputBuffer[this._inputPtr] != 62) break;
                    ++this._inputPtr;
                    return;
                }
            }
        }
    }

    @Override
    protected void skipSpace() throws XMLStreamException {
        int ptr = this._inputPtr;
        while (true) {
            int c;
            if (ptr >= this._inputEnd) {
                if (!this.loadMore()) break;
                ptr = this._inputPtr;
            }
            if ((c = this._inputBuffer[ptr] & 0xFF) > 32) break;
            ++ptr;
            if (c == 10) {
                this.markLF(ptr);
                continue;
            }
            if (c == 13) {
                if (ptr >= this._inputEnd) {
                    if (!this.loadMore()) break;
                    ptr = this._inputPtr;
                }
                if (this._inputBuffer[ptr] == 10) {
                    ++ptr;
                }
                this.markLF(ptr);
                continue;
            }
            if (c == 32 || c == 9) continue;
            this._inputPtr = ptr;
            this.throwInvalidSpace(c);
        }
        this._inputPtr = ptr;
    }

    private void skipUtf8_2() throws XMLStreamException {
        byte c;
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        if (((c = this._inputBuffer[this._inputPtr++]) & 0xC0) != 128) {
            this.reportInvalidOther(c & 0xFF, this._inputPtr);
        }
    }

    private void skipUtf8_3(int c) throws XMLStreamException {
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        if ((c &= 0xF) >= 13) {
            byte d;
            c <<= 6;
            if (((d = this._inputBuffer[this._inputPtr++]) & 0xC0) != 128) {
                this.reportInvalidOther(d & 0xFF, this._inputPtr);
            }
            c |= d & 0x3F;
            if (this._inputPtr >= this._inputEnd) {
                this.loadMoreGuaranteed();
            }
            if (((d = this._inputBuffer[this._inputPtr++]) & 0xC0) != 128) {
                this.reportInvalidOther(d & 0xFF, this._inputPtr);
            }
            if ((c = c << 6 | d & 0x3F) >= 55296 && (c < 57344 || c >= 65534)) {
                this.handleInvalidXmlChar(c);
            }
        } else {
            if (((c = this._inputBuffer[this._inputPtr++]) & 0xC0) != 128) {
                this.reportInvalidOther(c & 0xFF, this._inputPtr);
            }
            if (this._inputPtr >= this._inputEnd) {
                this.loadMoreGuaranteed();
            }
            if (((c = this._inputBuffer[this._inputPtr++]) & 0xC0) != 128) {
                this.reportInvalidOther(c & 0xFF, this._inputPtr);
            }
        }
    }

    private void skipUtf8_4() throws XMLStreamException {
        byte d;
        if (this._inputPtr + 4 > this._inputEnd) {
            this.skipUtf8_4Slow();
            return;
        }
        if (((d = this._inputBuffer[this._inputPtr++]) & 0xC0) != 128) {
            this.reportInvalidOther(d & 0xFF, this._inputPtr);
        }
        if (((d = this._inputBuffer[this._inputPtr++]) & 0xC0) != 128) {
            this.reportInvalidOther(d & 0xFF, this._inputPtr);
        }
        if (((d = this._inputBuffer[this._inputPtr++]) & 0xC0) != 128) {
            this.reportInvalidOther(d & 0xFF, this._inputPtr);
        }
    }

    private void skipUtf8_4Slow() throws XMLStreamException {
        byte d;
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        if (((d = this._inputBuffer[this._inputPtr++]) & 0xC0) != 128) {
            this.reportInvalidOther(d & 0xFF, this._inputPtr);
        }
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        if (((d = this._inputBuffer[this._inputPtr++]) & 0xC0) != 128) {
            this.reportInvalidOther(d & 0xFF, this._inputPtr);
        }
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        if (((d = this._inputBuffer[this._inputPtr++]) & 0xC0) != 128) {
            this.reportInvalidOther(d & 0xFF, this._inputPtr);
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    protected void finishCData() throws XMLStreamException {
        TYPES = this._charTypes.OTHER_CHARS;
        inputBuffer = this._inputBuffer;
        outputBuffer = this._textBuilder.resetWithEmpty();
        outPtr = 0;
        block10: while (true) {
            block26: {
                if ((ptr = this._inputPtr) >= this._inputEnd) {
                    this.loadMoreGuaranteed();
                    ptr = this._inputPtr;
                }
                if (outPtr >= outputBuffer.length) {
                    outputBuffer = this._textBuilder.finishCurrentSegment();
                    outPtr = 0;
                }
                if ((max2 = ptr + (outputBuffer.length - outPtr)) < (max = this._inputEnd)) {
                    max = max2;
                }
                while (ptr < max) {
                    if (TYPES[c = inputBuffer[ptr++] & 255] == 0) {
                        outputBuffer[outPtr++] = (char)c;
                        continue;
                    }
                    break block26;
                }
                this._inputPtr = ptr;
                continue;
            }
            this._inputPtr = ptr;
            switch (TYPES[c]) {
                case 1: {
                    this.handleInvalidXmlChar(c);
                }
                case 2: {
                    if (this._inputPtr >= this._inputEnd) {
                        this.loadMoreGuaranteed();
                    }
                    if (inputBuffer[this._inputPtr] == 10) {
                        ++this._inputPtr;
                    }
                    this.markLF();
                    c = 10;
                    ** GOTO lbl76
                }
                case 3: {
                    this.markLF();
                    ** GOTO lbl76
                }
                case 5: {
                    c = this.decodeUtf8_2(c);
                    ** GOTO lbl76
                }
                case 6: {
                    c = this.decodeUtf8_3(c);
                    ** GOTO lbl76
                }
                case 7: {
                    c = this.decodeUtf8_4(c);
                    outputBuffer[outPtr++] = (char)(55296 | c >> 10);
                    if (outPtr >= outputBuffer.length) {
                        outputBuffer = this._textBuilder.finishCurrentSegment();
                        outPtr = 0;
                    }
                    c = 56320 | c & 1023;
                    ** GOTO lbl76
                }
                case 4: {
                    this.reportInvalidInitial(c);
                }
                case 11: {
                    count = 0;
                    while (true) {
                        if (this._inputPtr >= this._inputEnd) {
                            this.loadMoreGuaranteed();
                        }
                        if ((b = this._inputBuffer[this._inputPtr]) != 93) break;
                        ++this._inputPtr;
                        ++count;
                    }
                    v0 = ok = b == 62 && count >= 1;
                    if (ok) {
                        --count;
                    }
                    while (count > 0) {
                        outputBuffer[outPtr++] = 93;
                        if (outPtr >= outputBuffer.length) {
                            outputBuffer = this._textBuilder.finishCurrentSegment();
                            outPtr = 0;
                        }
                        --count;
                    }
                    if (ok) {
                        ++this._inputPtr;
                        break block10;
                    }
                }
lbl76:
                // 8 sources

                default: {
                    outputBuffer[outPtr++] = (char)c;
                    continue block10;
                }
            }
            break;
        }
        this._textBuilder.setCurrentLength(outPtr);
        if (this._cfgCoalescing && !this._entityPending) {
            this.finishCoalescedText();
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    protected void finishCharacters() throws XMLStreamException {
        c = this._tmpChar;
        if (c < 0) {
            c = -c;
            outputBuffer = this._textBuilder.resetWithEmpty();
            outPtr = 0;
            if (c >> 16 != 0) {
                outputBuffer[outPtr++] = (char)(55296 | (c -= 65536) >> 10);
                c = 56320 | c & 1023;
            }
            outputBuffer[outPtr++] = (char)c;
        } else if (c == 13 || c == 10) {
            ++this._inputPtr;
            outPtr = this.checkInTreeIndentation(c);
            if (outPtr < 0) {
                return;
            }
            outputBuffer = this._textBuilder.getBufferWithoutReset();
        } else {
            outputBuffer = this._textBuilder.resetWithEmpty();
            outPtr = 0;
        }
        TYPES = this._charTypes.TEXT_CHARS;
        inputBuffer = this._inputBuffer;
        block12: while (true) {
            block35: {
                if ((ptr = this._inputPtr) >= this._inputEnd) {
                    this.loadMoreGuaranteed();
                    ptr = this._inputPtr;
                }
                if (outPtr >= outputBuffer.length) {
                    outputBuffer = this._textBuilder.finishCurrentSegment();
                    outPtr = 0;
                }
                if ((max2 = ptr + (outputBuffer.length - outPtr)) < (max = this._inputEnd)) {
                    max = max2;
                }
                while (ptr < max) {
                    if (TYPES[c = inputBuffer[ptr++] & 255] == 0) {
                        outputBuffer[outPtr++] = (char)c;
                        continue;
                    }
                    break block35;
                }
                this._inputPtr = ptr;
                continue;
            }
            this._inputPtr = ptr;
            switch (TYPES[c]) {
                case 1: {
                    this.handleInvalidXmlChar(c);
                }
                case 2: {
                    if (this._inputPtr >= this._inputEnd) {
                        this.loadMoreGuaranteed();
                    }
                    if (inputBuffer[this._inputPtr] == 10) {
                        ++this._inputPtr;
                    }
                    this.markLF();
                    c = 10;
                    ** GOTO lbl104
                }
                case 3: {
                    this.markLF();
                    ** GOTO lbl104
                }
                case 5: {
                    c = this.decodeUtf8_2(c);
                    ** GOTO lbl104
                }
                case 6: {
                    c = this._inputEnd - this._inputPtr >= 2 ? this.decodeUtf8_3fast(c) : this.decodeUtf8_3(c);
                    ** GOTO lbl104
                }
                case 7: {
                    c = this.decodeUtf8_4(c);
                    outputBuffer[outPtr++] = (char)(55296 | c >> 10);
                    if (outPtr >= outputBuffer.length) {
                        outputBuffer = this._textBuilder.finishCurrentSegment();
                        outPtr = 0;
                    }
                    c = 56320 | c & 1023;
                    ** GOTO lbl104
                }
                case 4: {
                    this.reportInvalidInitial(c);
                }
                case 9: {
                    --this._inputPtr;
                    break block12;
                }
                case 10: {
                    c = this.handleEntityInText();
                    if (c == 0) {
                        this._entityPending = true;
                        break block12;
                    }
                    if (c >> 16 == 0) ** GOTO lbl104
                    outputBuffer[outPtr++] = (char)(55296 | (c -= 65536) >> 10);
                    if (outPtr >= outputBuffer.length) {
                        outputBuffer = this._textBuilder.finishCurrentSegment();
                        outPtr = 0;
                    }
                    c = 56320 | c & 1023;
                    ** GOTO lbl104
                }
                case 11: {
                    count = 1;
                    while (true) {
                        if (this._inputPtr >= this._inputEnd) {
                            this.loadMoreGuaranteed();
                        }
                        if ((b = inputBuffer[this._inputPtr]) != 93) break;
                        ++this._inputPtr;
                        ++count;
                    }
                    if (b == 62 && count > 1) {
                        this.reportIllegalCDataEnd();
                    }
                    while (count > 1) {
                        outputBuffer[outPtr++] = 93;
                        if (outPtr >= outputBuffer.length) {
                            outputBuffer = this._textBuilder.finishCurrentSegment();
                            outPtr = 0;
                        }
                        --count;
                    }
                }
lbl104:
                // 9 sources

                default: {
                    outputBuffer[outPtr++] = (char)c;
                    continue block12;
                }
            }
            break;
        }
        this._textBuilder.setCurrentLength(outPtr);
        if (this._cfgCoalescing && !this._entityPending) {
            this.finishCoalescedText();
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    protected void finishComment() throws XMLStreamException {
        TYPES = this._charTypes.OTHER_CHARS;
        inputBuffer = this._inputBuffer;
        outputBuffer = this._textBuilder.resetWithEmpty();
        outPtr = 0;
        block10: while (true) {
            block22: {
                if ((ptr = this._inputPtr) >= this._inputEnd) {
                    this.loadMoreGuaranteed();
                    ptr = this._inputPtr;
                }
                if (outPtr >= outputBuffer.length) {
                    outputBuffer = this._textBuilder.finishCurrentSegment();
                    outPtr = 0;
                }
                if ((max2 = ptr + (outputBuffer.length - outPtr)) < (max = this._inputEnd)) {
                    max = max2;
                }
                while (ptr < max) {
                    if (TYPES[c = inputBuffer[ptr++] & 255] == 0) {
                        outputBuffer[outPtr++] = (char)c;
                        continue;
                    }
                    break block22;
                }
                this._inputPtr = ptr;
                continue;
            }
            this._inputPtr = ptr;
            switch (TYPES[c]) {
                case 1: {
                    this.handleInvalidXmlChar(c);
                }
                case 2: {
                    if (this._inputPtr >= this._inputEnd) {
                        this.loadMoreGuaranteed();
                    }
                    if (inputBuffer[this._inputPtr] == 10) {
                        ++this._inputPtr;
                    }
                    this.markLF();
                    c = 10;
                    ** GOTO lbl64
                }
                case 3: {
                    this.markLF();
                    ** GOTO lbl64
                }
                case 5: {
                    c = this.decodeUtf8_2(c);
                    ** GOTO lbl64
                }
                case 6: {
                    c = this.decodeUtf8_3(c);
                    ** GOTO lbl64
                }
                case 7: {
                    c = this.decodeUtf8_4(c);
                    outputBuffer[outPtr++] = (char)(55296 | c >> 10);
                    if (outPtr >= outputBuffer.length) {
                        outputBuffer = this._textBuilder.finishCurrentSegment();
                        outPtr = 0;
                    }
                    c = 56320 | c & 1023;
                    ** GOTO lbl64
                }
                case 4: {
                    this.reportInvalidInitial(c);
                }
                case 13: {
                    if (this._inputPtr >= this._inputEnd) {
                        this.loadMoreGuaranteed();
                    }
                    if (this._inputBuffer[this._inputPtr] == 45) {
                        ++this._inputPtr;
                        if (this._inputPtr >= this._inputEnd) {
                            this.loadMoreGuaranteed();
                        }
                        if (this._inputBuffer[this._inputPtr++] == 62) break block10;
                        this.reportDoubleHyphenInComments();
                        break block10;
                    }
                }
lbl64:
                // 8 sources

                default: {
                    outputBuffer[outPtr++] = (char)c;
                    continue block10;
                }
            }
            break;
        }
        this._textBuilder.setCurrentLength(outPtr);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    protected void finishDTD(boolean copyContents) throws XMLStreamException {
        outputBuffer = copyContents != false ? this._textBuilder.resetWithEmpty() : null;
        outPtr = 0;
        TYPES = this._charTypes.DTD_CHARS;
        inDecl = false;
        quoteChar = 0;
        block13: while (true) {
            block31: {
                if ((ptr = this._inputPtr) >= this._inputEnd) {
                    this.loadMoreGuaranteed();
                    ptr = this._inputPtr;
                }
                max = this._inputEnd;
                if (outputBuffer != null) {
                    if (outPtr >= outputBuffer.length) {
                        outputBuffer = this._textBuilder.finishCurrentSegment();
                        outPtr = 0;
                    }
                    if ((max2 = ptr + (outputBuffer.length - outPtr)) < max) {
                        max = max2;
                    }
                }
                while (ptr < max) {
                    if (TYPES[c = this._inputBuffer[ptr++] & 255] == 0) {
                        if (outputBuffer == null) continue;
                        outputBuffer[outPtr++] = (char)c;
                        continue;
                    }
                    break block31;
                }
                this._inputPtr = ptr;
                continue;
            }
            this._inputPtr = ptr;
            switch (TYPES[c]) {
                case 1: {
                    this.handleInvalidXmlChar(c);
                }
                case 2: {
                    if (this._inputPtr >= this._inputEnd) {
                        this.loadMoreGuaranteed();
                    }
                    if (this._inputBuffer[this._inputPtr] == 10) {
                        ++this._inputPtr;
                    }
                    this.markLF();
                    c = 10;
                    ** GOTO lbl76
                }
                case 3: {
                    this.markLF();
                    ** GOTO lbl76
                }
                case 5: {
                    c = this.decodeUtf8_2(c);
                    ** GOTO lbl76
                }
                case 6: {
                    c = this.decodeUtf8_3(c);
                    ** GOTO lbl76
                }
                case 7: {
                    c = this.decodeUtf8_4(c);
                    if (outputBuffer != null) {
                        outputBuffer[outPtr++] = (char)(55296 | c >> 10);
                        c = 56320 | c & 1023;
                        if (outPtr >= outputBuffer.length) {
                            outputBuffer = this._textBuilder.finishCurrentSegment();
                            outPtr = 0;
                        }
                    }
                    ** GOTO lbl76
                }
                case 4: {
                    this.reportInvalidInitial(c);
                }
                case 8: {
                    if (quoteChar == 0) {
                        quoteChar = c;
                    } else if (quoteChar == c) {
                        quoteChar = 0;
                    }
                    ** GOTO lbl76
                }
                case 9: {
                    if (!inDecl) {
                        inDecl = true;
                    }
                    ** GOTO lbl76
                }
                case 10: {
                    if (quoteChar == 0) {
                        inDecl = false;
                    }
                    ** GOTO lbl76
                }
                case 11: {
                    if (!inDecl && quoteChar == 0) break block13;
                }
lbl76:
                // 11 sources

                default: {
                    if (outputBuffer == null) continue block13;
                    outputBuffer[outPtr++] = (char)c;
                    continue block13;
                }
            }
            break;
        }
        if (outputBuffer != null) {
            this._textBuilder.setCurrentLength(outPtr);
        }
        if ((b = this.skipInternalWs(false, null)) != 62) {
            this.throwUnexpectedChar(this.decodeCharForError(b), " expected '>' after the internal subset");
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    protected void finishPI() throws XMLStreamException {
        TYPES = this._charTypes.OTHER_CHARS;
        inputBuffer = this._inputBuffer;
        outputBuffer = this._textBuilder.resetWithEmpty();
        outPtr = 0;
        block10: while (true) {
            block21: {
                if ((ptr = this._inputPtr) >= this._inputEnd) {
                    this.loadMoreGuaranteed();
                    ptr = this._inputPtr;
                }
                if (outPtr >= outputBuffer.length) {
                    outputBuffer = this._textBuilder.finishCurrentSegment();
                    outPtr = 0;
                }
                if ((max2 = ptr + (outputBuffer.length - outPtr)) < (max = this._inputEnd)) {
                    max = max2;
                }
                while (ptr < max) {
                    if (TYPES[c = inputBuffer[ptr++] & 255] == 0) {
                        outputBuffer[outPtr++] = (char)c;
                        continue;
                    }
                    break block21;
                }
                this._inputPtr = ptr;
                continue;
            }
            this._inputPtr = ptr;
            switch (TYPES[c]) {
                case 1: {
                    this.handleInvalidXmlChar(c);
                }
                case 2: {
                    if (this._inputPtr >= this._inputEnd) {
                        this.loadMoreGuaranteed();
                    }
                    if (inputBuffer[this._inputPtr] == 10) {
                        ++this._inputPtr;
                    }
                    this.markLF();
                    c = 10;
                    ** GOTO lbl60
                }
                case 3: {
                    this.markLF();
                    ** GOTO lbl60
                }
                case 5: {
                    c = this.decodeUtf8_2(c);
                    ** GOTO lbl60
                }
                case 6: {
                    c = this.decodeUtf8_3(c);
                    ** GOTO lbl60
                }
                case 7: {
                    c = this.decodeUtf8_4(c);
                    outputBuffer[outPtr++] = (char)(55296 | c >> 10);
                    if (outPtr >= outputBuffer.length) {
                        outputBuffer = this._textBuilder.finishCurrentSegment();
                        outPtr = 0;
                    }
                    c = 56320 | c & 1023;
                    ** GOTO lbl60
                }
                case 4: {
                    this.reportInvalidInitial(c);
                }
                case 12: {
                    if (this._inputPtr >= this._inputEnd) {
                        this.loadMoreGuaranteed();
                    }
                    if (this._inputBuffer[this._inputPtr] == 62) {
                        ++this._inputPtr;
                        break block10;
                    }
                }
lbl60:
                // 8 sources

                default: {
                    outputBuffer[outPtr++] = (char)c;
                    continue block10;
                }
            }
            break;
        }
        this._textBuilder.setCurrentLength(outPtr);
    }

    @Override
    protected void finishSpace() throws XMLStreamException {
        char[] outputBuffer;
        int outPtr;
        int tmp = this._tmpChar;
        if (tmp == 13 || tmp == 10) {
            outPtr = this.checkPrologIndentation(tmp);
            if (outPtr < 0) {
                return;
            }
            outputBuffer = this._textBuilder.getBufferWithoutReset();
        } else {
            outputBuffer = this._textBuilder.resetWithEmpty();
            outputBuffer[0] = (char)tmp;
            outPtr = 1;
        }
        int ptr = this._inputPtr;
        while (true) {
            int c;
            if (ptr >= this._inputEnd) {
                if (!this.loadMore()) break;
                ptr = this._inputPtr;
            }
            if ((c = this._inputBuffer[ptr] & 0xFF) > 32) break;
            ++ptr;
            if (c == 10) {
                this.markLF(ptr);
            } else if (c == 13) {
                if (ptr >= this._inputEnd) {
                    if (!this.loadMore()) {
                        if (outPtr >= outputBuffer.length) {
                            outputBuffer = this._textBuilder.finishCurrentSegment();
                            outPtr = 0;
                        }
                        outputBuffer[outPtr++] = 10;
                        break;
                    }
                    ptr = this._inputPtr;
                }
                if (this._inputBuffer[ptr] == 10) {
                    ++ptr;
                }
                this.markLF(ptr);
                c = 10;
            } else if (c != 32 && c != 9) {
                this._inputPtr = ptr;
                this.throwInvalidSpace(c);
            }
            if (outPtr >= outputBuffer.length) {
                outputBuffer = this._textBuilder.finishCurrentSegment();
                outPtr = 0;
            }
            outputBuffer[outPtr++] = (char)c;
        }
        this._inputPtr = ptr;
        this._textBuilder.setCurrentLength(outPtr);
    }

    private void finishCoalescedText() throws XMLStreamException {
        while (true) {
            if (this._inputPtr >= this._inputEnd && !this.loadMore()) {
                return;
            }
            if (this._inputBuffer[this._inputPtr] == 60) {
                if (this._inputPtr + 3 >= this._inputEnd && !this.loadAndRetain()) {
                    return;
                }
                if (this._inputBuffer[this._inputPtr + 1] != 33 || this._inputBuffer[this._inputPtr + 2] != 91) {
                    return;
                }
                this._inputPtr += 3;
                for (int i = 0; i < 6; ++i) {
                    byte b;
                    if (this._inputPtr >= this._inputEnd) {
                        this.loadMoreGuaranteed();
                    }
                    if ((b = this._inputBuffer[this._inputPtr++]) == (byte)"CDATA[".charAt(i)) continue;
                    int ch = this.decodeCharForError(b);
                    this.reportTreeUnexpChar(ch, " (expected '" + "CDATA[".charAt(i) + "' for CDATA section)");
                }
                this.finishCoalescedCData();
                continue;
            }
            this.finishCoalescedCharacters();
            if (this._entityPending) break;
        }
    }

    /*
     * Unable to fully structure code
     */
    private void finishCoalescedCharacters() throws XMLStreamException {
        TYPES = this._charTypes.TEXT_CHARS;
        inputBuffer = this._inputBuffer;
        outputBuffer = this._textBuilder.getBufferWithoutReset();
        outPtr = this._textBuilder.getCurrentLength();
        block12: while (true) {
            block28: {
                if ((ptr = this._inputPtr) >= this._inputEnd) {
                    this.loadMoreGuaranteed();
                    ptr = this._inputPtr;
                }
                if (outPtr >= outputBuffer.length) {
                    outputBuffer = this._textBuilder.finishCurrentSegment();
                    outPtr = 0;
                }
                if ((max2 = ptr + (outputBuffer.length - outPtr)) < (max = this._inputEnd)) {
                    max = max2;
                }
                while (ptr < max) {
                    if (TYPES[c = inputBuffer[ptr++] & 255] == 0) {
                        outputBuffer[outPtr++] = (char)c;
                        continue;
                    }
                    break block28;
                }
                this._inputPtr = ptr;
                continue;
            }
            this._inputPtr = ptr;
            switch (TYPES[c]) {
                case 1: {
                    this.handleInvalidXmlChar(c);
                }
                case 2: {
                    if (this._inputPtr >= this._inputEnd) {
                        this.loadMoreGuaranteed();
                    }
                    if (inputBuffer[this._inputPtr] == 10) {
                        ++this._inputPtr;
                    }
                    this.markLF();
                    c = 10;
                    ** GOTO lbl87
                }
                case 3: {
                    this.markLF();
                    ** GOTO lbl87
                }
                case 5: {
                    c = this.decodeUtf8_2(c);
                    ** GOTO lbl87
                }
                case 6: {
                    c = this._inputEnd - this._inputPtr >= 2 ? this.decodeUtf8_3fast(c) : this.decodeUtf8_3(c);
                    ** GOTO lbl87
                }
                case 7: {
                    c = this.decodeUtf8_4(c);
                    outputBuffer[outPtr++] = (char)(55296 | c >> 10);
                    if (outPtr >= outputBuffer.length) {
                        outputBuffer = this._textBuilder.finishCurrentSegment();
                        outPtr = 0;
                    }
                    c = 56320 | c & 1023;
                    ** GOTO lbl87
                }
                case 4: {
                    this.reportInvalidInitial(c);
                }
                case 9: {
                    --this._inputPtr;
                    break block12;
                }
                case 10: {
                    c = this.handleEntityInText();
                    if (c == 0) {
                        this._entityPending = true;
                        break block12;
                    }
                    if (c >> 16 == 0) ** GOTO lbl87
                    outputBuffer[outPtr++] = (char)(55296 | (c -= 65536) >> 10);
                    if (outPtr >= outputBuffer.length) {
                        outputBuffer = this._textBuilder.finishCurrentSegment();
                        outPtr = 0;
                    }
                    c = 56320 | c & 1023;
                    ** GOTO lbl87
                }
                case 11: {
                    count = 1;
                    while (true) {
                        if (this._inputPtr >= this._inputEnd) {
                            this.loadMoreGuaranteed();
                        }
                        if ((b = inputBuffer[this._inputPtr]) != 93) break;
                        ++this._inputPtr;
                        ++count;
                    }
                    if (b == 62 && count > 1) {
                        this.reportIllegalCDataEnd();
                    }
                    while (count > 1) {
                        outputBuffer[outPtr++] = 93;
                        if (outPtr >= outputBuffer.length) {
                            outputBuffer = this._textBuilder.finishCurrentSegment();
                            outPtr = 0;
                        }
                        --count;
                    }
                }
lbl87:
                // 9 sources

                default: {
                    outputBuffer[outPtr++] = (char)c;
                    continue block12;
                }
            }
            break;
        }
        this._textBuilder.setCurrentLength(outPtr);
    }

    /*
     * Unable to fully structure code
     */
    private void finishCoalescedCData() throws XMLStreamException {
        TYPES = this._charTypes.OTHER_CHARS;
        inputBuffer = this._inputBuffer;
        outputBuffer = this._textBuilder.getBufferWithoutReset();
        outPtr = this._textBuilder.getCurrentLength();
        block10: while (true) {
            block25: {
                if ((ptr = this._inputPtr) >= this._inputEnd) {
                    this.loadMoreGuaranteed();
                    ptr = this._inputPtr;
                }
                if (outPtr >= outputBuffer.length) {
                    outputBuffer = this._textBuilder.finishCurrentSegment();
                    outPtr = 0;
                }
                if ((max2 = ptr + (outputBuffer.length - outPtr)) < (max = this._inputEnd)) {
                    max = max2;
                }
                while (ptr < max) {
                    if (TYPES[c = inputBuffer[ptr++] & 255] == 0) {
                        outputBuffer[outPtr++] = (char)c;
                        continue;
                    }
                    break block25;
                }
                this._inputPtr = ptr;
                continue;
            }
            this._inputPtr = ptr;
            switch (TYPES[c]) {
                case 1: {
                    this.handleInvalidXmlChar(c);
                }
                case 2: {
                    if (this._inputPtr >= this._inputEnd) {
                        this.loadMoreGuaranteed();
                    }
                    if (inputBuffer[this._inputPtr] == 10) {
                        ++this._inputPtr;
                    }
                    this.markLF();
                    c = 10;
                    ** GOTO lbl76
                }
                case 3: {
                    this.markLF();
                    ** GOTO lbl76
                }
                case 5: {
                    c = this.decodeUtf8_2(c);
                    ** GOTO lbl76
                }
                case 6: {
                    c = this.decodeUtf8_3(c);
                    ** GOTO lbl76
                }
                case 7: {
                    c = this.decodeUtf8_4(c);
                    outputBuffer[outPtr++] = (char)(55296 | c >> 10);
                    if (outPtr >= outputBuffer.length) {
                        outputBuffer = this._textBuilder.finishCurrentSegment();
                        outPtr = 0;
                    }
                    c = 56320 | c & 1023;
                    ** GOTO lbl76
                }
                case 4: {
                    this.reportInvalidInitial(c);
                }
                case 11: {
                    count = 0;
                    while (true) {
                        if (this._inputPtr >= this._inputEnd) {
                            this.loadMoreGuaranteed();
                        }
                        if ((b = this._inputBuffer[this._inputPtr]) != 93) break;
                        ++this._inputPtr;
                        ++count;
                    }
                    v0 = ok = b == 62 && count >= 1;
                    if (ok) {
                        --count;
                    }
                    while (count > 0) {
                        outputBuffer[outPtr++] = 93;
                        if (outPtr >= outputBuffer.length) {
                            outputBuffer = this._textBuilder.finishCurrentSegment();
                            outPtr = 0;
                        }
                        --count;
                    }
                    if (ok) {
                        ++this._inputPtr;
                        break block10;
                    }
                }
lbl76:
                // 8 sources

                default: {
                    outputBuffer[outPtr++] = (char)c;
                    continue block10;
                }
            }
            break;
        }
        this._textBuilder.setCurrentLength(outPtr);
    }

    @Override
    protected boolean skipCoalescedText() throws XMLStreamException {
        while (true) {
            if (this._inputPtr >= this._inputEnd && !this.loadMore()) {
                return false;
            }
            if (this._inputBuffer[this._inputPtr] == 60) {
                if (this._inputPtr + 3 >= this._inputEnd && !this.loadAndRetain()) {
                    return false;
                }
                if (this._inputBuffer[this._inputPtr + 1] != 33 || this._inputBuffer[this._inputPtr + 2] != 91) {
                    return false;
                }
                this._inputPtr += 3;
                for (int i = 0; i < 6; ++i) {
                    byte b;
                    if (this._inputPtr >= this._inputEnd) {
                        this.loadMoreGuaranteed();
                    }
                    if ((b = this._inputBuffer[this._inputPtr++]) == (byte)"CDATA[".charAt(i)) continue;
                    int ch = this.decodeCharForError(b);
                    this.reportTreeUnexpChar(ch, " (expected '" + "CDATA[".charAt(i) + "' for CDATA section)");
                }
                this.skipCData();
                continue;
            }
            if (this.skipCharacters()) break;
        }
        return true;
    }

    private int decodeMultiByteChar(int c, int ptr) throws XMLStreamException {
        byte d;
        int needed;
        if ((c & 0xE0) == 192) {
            c &= 0x1F;
            needed = 1;
        } else if ((c & 0xF0) == 224) {
            c &= 0xF;
            needed = 2;
        } else if ((c & 0xF8) == 240) {
            c &= 7;
            needed = 3;
        } else {
            this.reportInvalidInitial(c & 0xFF);
            needed = 1;
        }
        if (ptr >= this._inputEnd) {
            this.loadMoreGuaranteed();
            ptr = this._inputPtr;
        }
        if (((d = this._inputBuffer[ptr++]) & 0xC0) != 128) {
            this.reportInvalidOther(d & 0xFF, ptr);
        }
        c = c << 6 | d & 0x3F;
        if (needed > 1) {
            if (ptr >= this._inputEnd) {
                this.loadMoreGuaranteed();
                ptr = this._inputPtr;
            }
            if (((d = this._inputBuffer[ptr++]) & 0xC0) != 128) {
                this.reportInvalidOther(d & 0xFF, ptr);
            }
            c = c << 6 | d & 0x3F;
            if (needed > 2) {
                if (ptr >= this._inputEnd) {
                    this.loadMoreGuaranteed();
                    ptr = this._inputPtr;
                }
                if (((d = this._inputBuffer[ptr++]) & 0xC0) != 128) {
                    this.reportInvalidOther(d & 0xFF, ptr);
                }
                c = c << 6 | d & 0x3F;
                c = -c;
            }
        }
        this._inputPtr = ptr;
        return c;
    }

    private int decodeUtf8_2(int c) throws XMLStreamException {
        byte d;
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        if (((d = this._inputBuffer[this._inputPtr++]) & 0xC0) != 128) {
            this.reportInvalidOther(d & 0xFF, this._inputPtr);
        }
        return (c & 0x1F) << 6 | d & 0x3F;
    }

    private int decodeUtf8_3(int c1) throws XMLStreamException {
        byte d;
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        c1 &= 0xF;
        if (((d = this._inputBuffer[this._inputPtr++]) & 0xC0) != 128) {
            this.reportInvalidOther(d & 0xFF, this._inputPtr);
        }
        int c = c1 << 6 | d & 0x3F;
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        if (((d = this._inputBuffer[this._inputPtr++]) & 0xC0) != 128) {
            this.reportInvalidOther(d & 0xFF, this._inputPtr);
        }
        c = c << 6 | d & 0x3F;
        if (c1 >= 13 && c >= 55296 && (c < 57344 || c >= 65534)) {
            c = this.handleInvalidXmlChar(c);
        }
        return c;
    }

    private int decodeUtf8_3fast(int c1) throws XMLStreamException {
        byte d;
        c1 &= 0xF;
        if (((d = this._inputBuffer[this._inputPtr++]) & 0xC0) != 128) {
            this.reportInvalidOther(d & 0xFF, this._inputPtr);
        }
        int c = c1 << 6 | d & 0x3F;
        if (((d = this._inputBuffer[this._inputPtr++]) & 0xC0) != 128) {
            this.reportInvalidOther(d & 0xFF, this._inputPtr);
        }
        c = c << 6 | d & 0x3F;
        if (c1 >= 13 && c >= 55296 && (c < 57344 || c >= 65534)) {
            c = this.handleInvalidXmlChar(c);
        }
        return c;
    }

    private int decodeUtf8_4(int c) throws XMLStreamException {
        byte d;
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        if (((d = this._inputBuffer[this._inputPtr++]) & 0xC0) != 128) {
            this.reportInvalidOther(d & 0xFF, this._inputPtr);
        }
        c = (c & 7) << 6 | d & 0x3F;
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        if (((d = this._inputBuffer[this._inputPtr++]) & 0xC0) != 128) {
            this.reportInvalidOther(d & 0xFF, this._inputPtr);
        }
        c = c << 6 | d & 0x3F;
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        if (((d = this._inputBuffer[this._inputPtr++]) & 0xC0) != 128) {
            this.reportInvalidOther(d & 0xFF, this._inputPtr);
        }
        return (c << 6 | d & 0x3F) - 65536;
    }

    public int decodeCharForError(byte b) throws XMLStreamException {
        int needed;
        int c = b;
        if (c >= 0) {
            return c;
        }
        if ((c & 0xE0) == 192) {
            c &= 0x1F;
            needed = 1;
        } else if ((c & 0xF0) == 224) {
            c &= 0xF;
            needed = 2;
        } else if ((c & 0xF8) == 240) {
            c &= 7;
            needed = 3;
        } else {
            this.reportInvalidInitial(c & 0xFF);
            needed = 1;
        }
        byte d = this.nextByte();
        if ((d & 0xC0) != 128) {
            this.reportInvalidOther(d & 0xFF);
        }
        c = c << 6 | d & 0x3F;
        if (needed > 1) {
            d = this.nextByte();
            if ((d & 0xC0) != 128) {
                this.reportInvalidOther(d & 0xFF);
            }
            c = c << 6 | d & 0x3F;
            if (needed > 2) {
                d = this.nextByte();
                if ((d & 0xC0) != 128) {
                    this.reportInvalidOther(d & 0xFF);
                }
                c = c << 6 | d & 0x3F;
            }
        }
        return c;
    }

    private void reportInvalidOther(int mask, int ptr) throws XMLStreamException {
        this._inputPtr = ptr;
        this.reportInvalidOther(mask);
    }

    @Override
    protected void finishToken() throws XMLStreamException {
        this._tokenIncomplete = false;
        switch (this._currToken) {
            case 3: {
                this.finishPI();
                break;
            }
            case 4: {
                this.finishCharacters();
                break;
            }
            case 5: {
                this.finishComment();
                break;
            }
            case 6: {
                this.finishSpace();
                break;
            }
            case 11: {
                this.finishDTD(true);
                break;
            }
            case 12: {
                this.finishCData();
                break;
            }
            default: {
                ErrorConsts.throwInternalError();
            }
        }
    }

    private byte nextByte() throws XMLStreamException {
        if (this._inputPtr >= this._inputEnd && !this.loadMore()) {
            this.reportInputProblem("Unexpected end-of-input when trying to parse " + ErrorConsts.tokenTypeDesc(this._currToken));
        }
        return this._inputBuffer[this._inputPtr++];
    }

    private byte loadOne() throws XMLStreamException {
        if (!this.loadMore()) {
            this.reportInputProblem("Unexpected end-of-input when trying to parse " + ErrorConsts.tokenTypeDesc(this._currToken));
        }
        return this._inputBuffer[this._inputPtr++];
    }

    private byte loadOne(int type) throws XMLStreamException {
        if (!this.loadMore()) {
            this.reportInputProblem("Unexpected end-of-input when trying to parse " + ErrorConsts.tokenTypeDesc(type));
        }
        return this._inputBuffer[this._inputPtr++];
    }

    private boolean loadAndRetain() throws XMLStreamException {
        if (this._in == null) {
            return false;
        }
        this._pastBytesOrChars += (long)this._inputPtr;
        this._rowStartOffset -= this._inputPtr;
        int remaining = this._inputEnd - this._inputPtr;
        System.arraycopy(this._inputBuffer, this._inputPtr, this._inputBuffer, 0, remaining);
        this._inputPtr = 0;
        this._inputEnd = remaining;
        try {
            do {
                int max;
                int count;
                if ((count = this._in.read(this._inputBuffer, this._inputEnd, max = this._inputBuffer.length - this._inputEnd)) < 1) {
                    if (count == 0) {
                        this.reportInputProblem("InputStream returned 0 bytes, even when asked to read up to " + max);
                    }
                    return false;
                }
                this._inputEnd += count;
            } while (this._inputEnd < 3);
            return true;
        }
        catch (IOException ioe) {
            throw new StreamExceptionBase(ioe);
        }
    }

    private PName addUTFPName(ByteBasedPNameTable symbols, XmlCharTypes charTypes, int hash, int[] quads, int qlen, int lastQuadBytes) throws XMLStreamException {
        boolean ok;
        int lastQuad;
        int byteLen = (qlen << 2) - 4 + lastQuadBytes;
        if (lastQuadBytes < 4) {
            lastQuad = quads[qlen - 1];
            quads[qlen - 1] = lastQuad << (4 - lastQuadBytes << 3);
        } else {
            lastQuad = 0;
        }
        int ch = quads[0] >>> 24;
        int ix = 1;
        char[] cbuf = this._nameBuffer;
        int cix = 0;
        int[] TYPES = charTypes.NAME_CHARS;
        switch (TYPES[ch]) {
            case 0: 
            case 1: 
            case 2: 
            case 4: {
                ok = false;
                break;
            }
            case 3: {
                ok = true;
                break;
            }
            default: {
                int needed;
                if ((ch & 0xE0) == 192) {
                    ch &= 0x1F;
                    needed = 1;
                } else if ((ch & 0xF0) == 224) {
                    ch &= 0xF;
                    needed = 2;
                } else if ((ch & 0xF8) == 240) {
                    ch &= 7;
                    needed = 3;
                } else {
                    this.reportInvalidInitial(ch);
                    ch = 1;
                    needed = 1;
                }
                if (ix + needed > byteLen) {
                    this.reportEofInName();
                }
                ix += needed;
                int q = quads[0];
                int ch2 = q >> 16 & 0xFF;
                if ((ch2 & 0xC0) != 128) {
                    this.reportInvalidOther(ch2);
                }
                ch = ch << 6 | ch2 & 0x3F;
                if (needed > 1) {
                    ch2 = q >> 8 & 0xFF;
                    if ((ch2 & 0xC0) != 128) {
                        this.reportInvalidOther(ch2);
                    }
                    ch = ch << 6 | ch2 & 0x3F;
                    if (needed > 2) {
                        ch2 = q & 0xFF;
                        if ((ch2 & 0xC0) != 128) {
                            this.reportInvalidOther(ch2 & 0xFF);
                        }
                        ch = ch << 6 | ch2 & 0x3F;
                    }
                }
                ok = XmlChars.is10NameStartChar(ch);
                if (needed <= 2) break;
                cbuf[cix++] = (char)(55296 + ((ch -= 65536) >> 10));
                ch = 0xDC00 | ch & 0x3FF;
            }
        }
        if (!ok) {
            this.reportInvalidNameChar(ch, 0);
        }
        cbuf[cix++] = (char)ch;
        int last_colon = -1;
        while (ix < byteLen) {
            ch = quads[ix >> 2];
            int byteIx = ix & 3;
            ch = ch >> (3 - byteIx << 3) & 0xFF;
            ++ix;
            switch (TYPES[ch]) {
                case 0: 
                case 4: {
                    ok = false;
                    break;
                }
                case 1: {
                    if (last_colon >= 0) {
                        this.reportMultipleColonsInName();
                    }
                    last_colon = cix;
                    ok = true;
                    break;
                }
                case 2: 
                case 3: {
                    ok = true;
                    break;
                }
                default: {
                    int needed;
                    if ((ch & 0xE0) == 192) {
                        ch &= 0x1F;
                        needed = 1;
                    } else if ((ch & 0xF0) == 224) {
                        ch &= 0xF;
                        needed = 2;
                    } else if ((ch & 0xF8) == 240) {
                        ch &= 7;
                        needed = 3;
                    } else {
                        this.reportInvalidInitial(ch);
                        ch = 1;
                        needed = 1;
                    }
                    if (ix + needed > byteLen) {
                        this.reportEofInName();
                    }
                    int ch2 = quads[ix >> 2];
                    byteIx = ix & 3;
                    ++ix;
                    if (((ch2 >>= 3 - byteIx << 3) & 0xC0) != 128) {
                        this.reportInvalidOther(ch2);
                    }
                    ch = ch << 6 | ch2 & 0x3F;
                    if (needed > 1) {
                        ch2 = quads[ix >> 2];
                        byteIx = ix & 3;
                        ++ix;
                        if (((ch2 >>= 3 - byteIx << 3) & 0xC0) != 128) {
                            this.reportInvalidOther(ch2);
                        }
                        ch = ch << 6 | ch2 & 0x3F;
                        if (needed > 2) {
                            ch2 = quads[ix >> 2];
                            byteIx = ix & 3;
                            ++ix;
                            if (((ch2 >>= 3 - byteIx << 3) & 0xC0) != 128) {
                                this.reportInvalidOther(ch2 & 0xFF);
                            }
                            ch = ch << 6 | ch2 & 0x3F;
                        }
                    }
                    ok = XmlChars.is10NameChar(ch);
                    if (needed <= 2) break;
                    ch -= 65536;
                    if (cix >= cbuf.length) {
                        this._nameBuffer = cbuf = DataUtil.growArrayBy(cbuf, cbuf.length);
                    }
                    cbuf[cix++] = (char)(55296 + (ch >> 10));
                    ch = 0xDC00 | ch & 0x3FF;
                }
            }
            if (!ok) {
                this.reportInvalidNameChar(ch, cix);
            }
            if (cix >= cbuf.length) {
                this._nameBuffer = cbuf = DataUtil.growArrayBy(cbuf, cbuf.length);
            }
            cbuf[cix++] = (char)ch;
        }
        String baseName = new String(cbuf, 0, cix);
        if (lastQuadBytes < 4) {
            quads[qlen - 1] = lastQuad;
        }
        return symbols.addSymbol(hash, baseName, last_colon, quads, qlen);
    }

    private void reportInvalidInitial(int mask) throws XMLStreamException {
        this.reportInputProblem("Invalid UTF-8 start byte 0x" + Integer.toHexString(mask));
    }

    private void reportInvalidOther(int mask) throws XMLStreamException {
        this.reportInputProblem("Invalid UTF-8 middle byte 0x" + Integer.toHexString(mask));
    }
}

