/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.blob.models;

import java.util.Locale;

public final class BlobRange {
    private static final String RANGE_HEADER_FORMAT = "bytes=%d-%d";
    private static final String BEGIN_RANGE_HEADER_FORMAT = "bytes=%d-";
    private final long offset;
    private final Long count;

    public BlobRange(long offset) {
        this(offset, null);
    }

    public BlobRange(long offset, Long count) {
        if (offset < 0L) {
            throw new IllegalArgumentException("BlobRange offset must be greater than or equal to 0.");
        }
        this.offset = offset;
        if (count != null && count < 0L) {
            throw new IllegalArgumentException("BlobRange count must be greater than or equal to 0 if specified.");
        }
        this.count = count;
    }

    public long getOffset() {
        return this.offset;
    }

    public Long getCount() {
        return this.count;
    }

    public String toString() {
        if (this.count != null) {
            long rangeEnd = this.offset + this.count - 1L;
            return String.format(Locale.ROOT, RANGE_HEADER_FORMAT, this.offset, rangeEnd);
        }
        return String.format(Locale.ROOT, BEGIN_RANGE_HEADER_FORMAT, this.offset);
    }

    public String toHeaderValue() {
        if (this.offset == 0L && this.count == null) {
            return null;
        }
        return this.toString();
    }
}

