/*
 * Decompiled with CFR 0.152.
 */
package com.azure.data.tables.sas;

import java.util.Locale;

public final class TableSasPermission {
    private boolean readPermission;
    private boolean addPermission;
    private boolean updatePermission;
    private boolean deletePermission;

    public static TableSasPermission parse(String permString) {
        TableSasPermission permissions = new TableSasPermission();
        block6: for (int i = 0; i < permString.length(); ++i) {
            char c = permString.charAt(i);
            switch (c) {
                case 'r': {
                    permissions.readPermission = true;
                    continue block6;
                }
                case 'a': {
                    permissions.addPermission = true;
                    continue block6;
                }
                case 'u': {
                    permissions.updatePermission = true;
                    continue block6;
                }
                case 'd': {
                    permissions.deletePermission = true;
                    continue block6;
                }
                default: {
                    throw new IllegalArgumentException(String.format(Locale.ROOT, "%s could not be parsed from '%s' due to invalid value %s.", "Permissions", permString, Character.valueOf(c)));
                }
            }
        }
        return permissions;
    }

    public boolean hasReadPermission() {
        return this.readPermission;
    }

    public TableSasPermission setReadPermission(boolean hasReadPermission) {
        this.readPermission = hasReadPermission;
        return this;
    }

    public boolean hasAddPermission() {
        return this.addPermission;
    }

    public TableSasPermission setAddPermission(boolean hasAddPermission) {
        this.addPermission = hasAddPermission;
        return this;
    }

    public boolean hasUpdatePermission() {
        return this.updatePermission;
    }

    public TableSasPermission setUpdatePermission(boolean hasUpdatePermission) {
        this.updatePermission = hasUpdatePermission;
        return this;
    }

    public boolean hasDeletePermission() {
        return this.deletePermission;
    }

    public TableSasPermission setDeletePermission(boolean hasDeletePermission) {
        this.deletePermission = hasDeletePermission;
        return this;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        if (this.readPermission) {
            builder.append('r');
        }
        if (this.addPermission) {
            builder.append('a');
        }
        if (this.updatePermission) {
            builder.append('u');
        }
        if (this.deletePermission) {
            builder.append('d');
        }
        return builder.toString();
    }
}

