/*
 * Decompiled with CFR 0.152.
 */
package com.azure.data.tables.models;

import com.azure.core.util.CoreUtils;
import com.azure.xml.XmlReader;
import com.azure.xml.XmlSerializable;
import com.azure.xml.XmlToken;
import com.azure.xml.XmlWriter;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;

public final class TableServiceRetentionPolicy
implements XmlSerializable<TableServiceRetentionPolicy> {
    private boolean enabled;
    private Integer daysToRetain;

    public boolean isEnabled() {
        return this.enabled;
    }

    public TableServiceRetentionPolicy setEnabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public Integer getDaysToRetain() {
        return this.daysToRetain;
    }

    public TableServiceRetentionPolicy setDaysToRetain(Integer daysToRetain) {
        this.daysToRetain = daysToRetain;
        return this;
    }

    public XmlWriter toXml(XmlWriter xmlWriter) throws XMLStreamException {
        return this.toXml(xmlWriter, null);
    }

    public XmlWriter toXml(XmlWriter xmlWriter, String rootElementName) throws XMLStreamException {
        rootElementName = CoreUtils.isNullOrEmpty((CharSequence)rootElementName) ? "RetentionPolicy" : rootElementName;
        xmlWriter.writeStartElement(rootElementName);
        xmlWriter.writeBooleanElement("Enabled", this.enabled);
        xmlWriter.writeNumberElement("Days", (Number)this.daysToRetain);
        return xmlWriter.writeEndElement();
    }

    public static TableServiceRetentionPolicy fromXml(XmlReader xmlReader) throws XMLStreamException {
        return TableServiceRetentionPolicy.fromXml(xmlReader, null);
    }

    public static TableServiceRetentionPolicy fromXml(XmlReader xmlReader, String rootElementName) throws XMLStreamException {
        String finalRootElementName = CoreUtils.isNullOrEmpty((CharSequence)rootElementName) ? "RetentionPolicy" : rootElementName;
        return (TableServiceRetentionPolicy)xmlReader.readObject(finalRootElementName, reader -> {
            TableServiceRetentionPolicy deserializedTableServiceRetentionPolicy = new TableServiceRetentionPolicy();
            while (reader.nextElement() != XmlToken.END_ELEMENT) {
                QName elementName = reader.getElementName();
                if ("Enabled".equals(elementName.getLocalPart())) {
                    deserializedTableServiceRetentionPolicy.enabled = reader.getBooleanElement();
                    continue;
                }
                if ("Days".equals(elementName.getLocalPart())) {
                    deserializedTableServiceRetentionPolicy.daysToRetain = (Integer)reader.getNullableElement(Integer::parseInt);
                    continue;
                }
                reader.skipElement();
            }
            return deserializedTableServiceRetentionPolicy;
        });
    }
}

