// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.data.tables.implementation.models;

import com.azure.core.exception.HttpResponseException;
import com.azure.core.http.HttpResponse;

/**
 * Exception thrown for an invalid response with TableServiceJsonError information.
 */
public final class TableServiceJsonErrorException extends HttpResponseException {
    /**
     * Initializes a new instance of the TableServiceJsonErrorException class.
     * 
     * @param message the exception message or the response content if a message is not available.
     * @param response the HTTP response.
     */
    public TableServiceJsonErrorException(String message, HttpResponse response) {
        super(message, response);
    }

    /**
     * Initializes a new instance of the TableServiceJsonErrorException class.
     * 
     * @param message the exception message or the response content if a message is not available.
     * @param response the HTTP response.
     * @param value the deserialized response value.
     */
    public TableServiceJsonErrorException(String message, HttpResponse response, TableServiceJsonError value) {
        super(message, response, value);
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public TableServiceJsonError getValue() {
        return (TableServiceJsonError) super.getValue();
    }
}
