/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.jms;

import com.atomikos.datasource.RecoverableResource;
import com.atomikos.datasource.xa.DefaultXidFactory;
import com.atomikos.datasource.xa.XidFactory;
import com.atomikos.datasource.xa.jms.JmsTransactionalResource;
import com.atomikos.icatch.system.Configuration;
import com.atomikos.jms.AbstractConnectionFactoryBean;
import com.atomikos.jms.JtaQueueConnectionFactory;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import javax.jms.Connection;
import javax.jms.JMSException;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.XAQueueConnectionFactory;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public class QueueConnectionFactoryBean
extends AbstractConnectionFactoryBean
implements QueueConnectionFactory,
Externalizable {
    private transient JtaQueueConnectionFactory factory_ = null;
    private XAQueueConnectionFactory xaFactory_ = null;

    protected synchronized void checkSetup() throws JMSException {
        this.factory_ = JtaQueueConnectionFactory.getInstance(this.resourceName_);
        if (this.factory_ != null) {
            return;
        }
        DefaultXidFactory xidFactory = null;
        xidFactory = new DefaultXidFactory();
        if (this.xaFactory_ == null && this.xaFactoryJndiName_.equals("")) {
            throw new JMSException("QueueConnectionFactoryBean: XAQueueConnectionFactory not set?");
        }
        if (!this.xaFactoryJndiName_.equals("")) {
            try {
                InitialContext ctx = new InitialContext();
                Context env = (Context)ctx.lookup("java:comp/env");
                this.xaFactory_ = (XAQueueConnectionFactory)env.lookup(this.xaFactoryJndiName_);
            }
            catch (NamingException ne) {
                throw new JMSException("QueueConnectionFactoryBean: error retrieving factory: " + ne.getMessage());
            }
        }
        this.factory_ = JtaQueueConnectionFactory.getOrCreate(this.resourceName_, this.xaFactory_, (XidFactory)xidFactory);
        JmsTransactionalResource res = this.factory_.getTransactionalResource();
        if (Configuration.getResource((String)res.getName()) == null) {
            Configuration.addResource((RecoverableResource)res);
        }
        StringBuffer msg = new StringBuffer();
        msg.append("QueueConnectionFactoryBean configured with [");
        msg.append("resourceName=").append(this.resourceName_).append(", ");
        msg.append("xaFactoryJndiName=").append(this.xaFactoryJndiName_);
        msg.append("]");
        Configuration.logDebug((String)msg.toString());
        Configuration.logWarning((String)("WARNING: class " + this.getClass().getName() + " is deprecated!"));
    }

    public XAQueueConnectionFactory getXaQueueConnectionFactory() {
        return this.xaFactory_;
    }

    public void setXaQueueConnectionFactory(XAQueueConnectionFactory xaFactory) {
        this.xaFactory_ = xaFactory;
    }

    public QueueConnection createQueueConnection() throws JMSException {
        this.checkSetup();
        return this.factory_.createQueueConnection();
    }

    public QueueConnection createQueueConnection(String user, String pw) throws JMSException {
        this.checkSetup();
        return this.factory_.createQueueConnection(user, pw);
    }

    public Connection createConnection() throws JMSException {
        return this.createQueueConnection();
    }

    public Connection createConnection(String userName, String password) throws JMSException {
        return this.createQueueConnection(userName, password);
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeObject(this.resourceName_);
        objectOutput.writeObject(this.xaFactory_);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.resourceName_ = (String)objectInput.readObject();
        try {
            this.xaFactory_ = (XAQueueConnectionFactory)objectInput.readObject();
        }
        catch (Exception e) {
            System.err.println("Error reading XA Queue Bean");
            e.printStackTrace();
            throw new RuntimeException(e.getMessage());
        }
    }
}

