/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.jms;

import com.atomikos.datasource.TransactionalResource;
import com.atomikos.jms.DefaultJtaConnection;
import com.atomikos.jms.JtaQueueSession;
import javax.jms.ConnectionConsumer;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueSession;
import javax.jms.ServerSessionPool;
import javax.jms.Session;
import javax.jms.XAConnection;
import javax.jms.XAQueueConnection;
import javax.jms.XAQueueSession;

class JtaQueueConnection
extends DefaultJtaConnection
implements QueueConnection {
    JtaQueueConnection(XAQueueConnection c, TransactionalResource res) {
        super((XAConnection)c, res);
    }

    private XAQueueConnection getQueueConnection() {
        return (XAQueueConnection)this.getConnection();
    }

    public QueueSession createQueueSession(boolean transacted, int ackMode) throws JMSException {
        QueueSession ret = null;
        if (!transacted && !JtaQueueConnection.inJtaTransaction()) {
            ret = this.getQueueConnection().createQueueSession(false, ackMode);
        } else {
            JtaQueueConnection.forceConnectionIntoXaMode(this.getConnection());
            XAQueueSession xasession = this.getQueueConnection().createXAQueueSession();
            ret = new JtaQueueSession(xasession, this.getTransactionalResource(), xasession.getXAResource());
        }
        return ret;
    }

    public ConnectionConsumer createConnectionConsumer(Queue queue, String selector, ServerSessionPool pool, int max) throws JMSException {
        throw new JMSException("Not implemented");
    }

    public Session createSession(boolean transacted, int ackMode) throws JMSException {
        return this.createQueueSession(transacted, ackMode);
    }
}

