/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib.io;

import com.android.SdkConstants;
import com.android.annotations.NonNull;
import com.android.sdklib.io.IFileOp;
import com.google.common.io.Closer;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Properties;
import java.util.regex.Pattern;

public class FileOp
implements IFileOp {
    public static final File[] EMPTY_FILE_ARRAY = new File[0];
    private static Method sFileSetExecutable = null;
    private static final Object[] sFileSetExecutableParams = new Object[]{Boolean.TRUE, Boolean.FALSE};

    public static File append(@NonNull File base, String ... segments) {
        for (String segment : segments) {
            base = new File(base, segment);
        }
        return base;
    }

    public static File append(@NonNull String base, String ... segments) {
        return FileOp.append(new File(base), segments);
    }

    @Override
    public void deleteFileOrFolder(@NonNull File fileOrFolder) {
        if (fileOrFolder != null) {
            File[] files;
            if (this.isDirectory(fileOrFolder) && (files = fileOrFolder.listFiles()) != null) {
                for (File item : files) {
                    this.deleteFileOrFolder(item);
                }
            }
            if (!this.exists(fileOrFolder)) {
                return;
            }
            if (SdkConstants.CURRENT_PLATFORM == 2) {
                for (int i = 0; i < 5; ++i) {
                    if (fileOrFolder.delete()) {
                        return;
                    }
                    try {
                        Thread.sleep(100L);
                        continue;
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                fileOrFolder.deleteOnExit();
            } else if (!fileOrFolder.delete()) {
                fileOrFolder.deleteOnExit();
            }
        }
    }

    @Override
    public void setExecutablePermission(@NonNull File file) throws IOException {
        if (sFileSetExecutable != null) {
            try {
                sFileSetExecutable.invoke((Object)file, sFileSetExecutableParams);
                return;
            }
            catch (IllegalArgumentException e) {
            }
            catch (IllegalAccessException e) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
        }
        Runtime.getRuntime().exec(new String[]{"chmod", "+x", file.getAbsolutePath()});
    }

    @Override
    public void setReadOnly(@NonNull File file) {
        file.setReadOnly();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void copyFile(@NonNull File source, @NonNull File dest) throws IOException {
        byte[] buffer = new byte[8192];
        FileInputStream fis = null;
        FileOutputStream fos = null;
        try {
            int read;
            fis = new FileInputStream(source);
            fos = new FileOutputStream(dest);
            while ((read = fis.read(buffer)) != -1) {
                fos.write(buffer, 0, read);
            }
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {}
            }
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException e) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean isSameFile(@NonNull File file1, @NonNull File file2) throws IOException {
        if (file1.length() != file2.length()) {
            return false;
        }
        FileInputStream fis1 = null;
        FileInputStream fis2 = null;
        try {
            boolean bl;
            fis1 = new FileInputStream(file1);
            fis2 = new FileInputStream(file2);
            byte[] buffer1 = new byte[8192];
            byte[] buffer2 = new byte[8192];
            do {
                int n;
                int read1;
                if ((read1 = fis1.read(buffer1)) == -1) return true;
                int read2 = 0;
                while (read2 < read1 && (n = fis2.read(buffer2, read2, read1 - read2)) != -1) {
                }
                if (read2 == read1) continue;
                bl = false;
                return bl;
            } while (Arrays.equals(buffer1, buffer2));
            bl = false;
            return bl;
        }
        finally {
            if (fis2 != null) {
                try {
                    fis2.close();
                }
                catch (IOException e) {}
            }
            if (fis1 != null) {
                try {
                    fis1.close();
                }
                catch (IOException e) {}
            }
        }
    }

    @Override
    public boolean isFile(@NonNull File file) {
        return file.isFile();
    }

    @Override
    public boolean isDirectory(@NonNull File file) {
        return file.isDirectory();
    }

    @Override
    public boolean exists(@NonNull File file) {
        return file.exists();
    }

    @Override
    public long length(@NonNull File file) {
        return file.length();
    }

    @Override
    public boolean delete(@NonNull File file) {
        return file.delete();
    }

    @Override
    public boolean mkdirs(@NonNull File file) {
        return file.mkdirs();
    }

    @Override
    @NonNull
    public File[] listFiles(@NonNull File file) {
        File[] r = file.listFiles();
        if (r == null) {
            return EMPTY_FILE_ARRAY;
        }
        return r;
    }

    @Override
    public boolean renameTo(@NonNull File oldFile, @NonNull File newFile) {
        return oldFile.renameTo(newFile);
    }

    @Override
    @NonNull
    public OutputStream newFileOutputStream(@NonNull File file) throws FileNotFoundException {
        return new FileOutputStream(file);
    }

    @Override
    @NonNull
    public InputStream newFileInputStream(@NonNull File file) throws FileNotFoundException {
        return new FileInputStream(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NonNull
    public Properties loadProperties(@NonNull File file) {
        Properties props = new Properties();
        Closer closer = Closer.create();
        try {
            FileInputStream fis = (FileInputStream)closer.register((Closeable)new FileInputStream(file));
            props.load(fis);
        }
        catch (IOException ignore) {
        }
        finally {
            try {
                closer.close();
            }
            catch (IOException e) {}
        }
        return props;
    }

    @Override
    public void saveProperties(@NonNull File file, @NonNull Properties props, @NonNull String comments) throws IOException {
        Closer closer = Closer.create();
        try {
            OutputStream fos = (OutputStream)closer.register((Closeable)this.newFileOutputStream(file));
            props.store(fos, comments);
        }
        catch (Throwable e) {
            throw closer.rethrow(e);
        }
        finally {
            closer.close();
        }
    }

    @Override
    public long lastModified(@NonNull File file) {
        return file.lastModified();
    }

    @NonNull
    public static String makeRelative(@NonNull File baseDir, @NonNull File toBeRelative) throws IOException {
        return FileOp.makeRelativeImpl(baseDir.getCanonicalPath(), toBeRelative.getCanonicalPath(), SdkConstants.CURRENT_PLATFORM == 2, File.separator);
    }

    @NonNull
    static String makeRelativeImpl(@NonNull String path1, @NonNull String path2, boolean isWindows, @NonNull String dirSeparator) throws IOException {
        int start;
        if (isWindows) {
            char drive2;
            String p1 = path1;
            String p2 = path2;
            char drive1 = p1.length() >= 2 && p1.charAt(1) == ':' ? p1.charAt(0) : (char)'\u0000';
            char c = drive2 = p2.length() >= 2 && p2.charAt(1) == ':' ? p2.charAt(0) : (char)'\u0000';
            if (drive1 != drive2) {
                throw new IOException("makeRelative: incompatible drive letters");
            }
        }
        String[] segments1 = path1.split(Pattern.quote(dirSeparator));
        String[] segments2 = path2.split(Pattern.quote(dirSeparator));
        int len1 = segments1.length;
        int len2 = segments2.length;
        int len = Math.min(len1, len2);
        for (start = 0; start < len && (!isWindows || segments1[start].equalsIgnoreCase(segments2[start])) && (isWindows || segments1[start].equals(segments2[start])); ++start) {
        }
        StringBuilder result = new StringBuilder();
        for (int i = start; i < len1; ++i) {
            result.append("..").append(dirSeparator);
        }
        while (start < len2) {
            result.append(segments2[start]);
            if (++start >= len2) continue;
            result.append(dirSeparator);
        }
        return result.toString();
    }

    static {
        try {
            sFileSetExecutable = File.class.getMethod("setExecutable", Boolean.TYPE, Boolean.TYPE);
        }
        catch (SecurityException e) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
    }
}

