/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.png;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.builder.png.ByteUtils;
import com.android.builder.png.PngWriter;
import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.zip.CRC32;

class Chunk {
    @NonNull
    private final byte[] mType;
    @Nullable
    private final byte[] mData;
    private final long mCrc32;

    Chunk(@NonNull byte[] type, @Nullable byte[] data, long crc32) {
        Preconditions.checkNotNull((Object)type);
        Preconditions.checkArgument((type.length == 4 ? 1 : 0) != 0);
        this.mType = type;
        this.mData = data;
        this.mCrc32 = crc32;
    }

    Chunk(@NonNull byte[] type, @Nullable byte[] data) {
        this(type, data, Chunk.computeCrc32(type, data));
    }

    Chunk(@NonNull byte[] type) {
        this(type, null);
    }

    int getDataLength() {
        return this.mData != null ? this.mData.length : 0;
    }

    int size() {
        return 12 + this.getDataLength();
    }

    @NonNull
    byte[] getType() {
        return this.mType;
    }

    String getTypeAsString() {
        return new String(this.mType, Charsets.US_ASCII);
    }

    @Nullable
    byte[] getData() {
        return this.mData;
    }

    long getCrc32() {
        return this.mCrc32;
    }

    private static long computeCrc32(@NonNull byte[] type, @Nullable byte[] data) {
        CRC32 checksum = new CRC32();
        checksum.update(type);
        if (data != null) {
            checksum.update(data);
        }
        return checksum.getValue();
    }

    void write(@NonNull OutputStream outStream) throws IOException {
        ByteUtils utils = ByteUtils.Cache.get();
        outStream.write(utils.getIntAsArray(this.getDataLength()));
        outStream.write(this.mType);
        if (this.mData != null) {
            outStream.write(this.mData);
        }
        outStream.write(utils.getLongAsIntArray(this.mCrc32), 4, 4);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Chunk chunk = (Chunk)o;
        if (this.mCrc32 != chunk.mCrc32) {
            return false;
        }
        if (!Arrays.equals(this.mData, chunk.mData)) {
            return false;
        }
        return Arrays.equals(this.mType, chunk.mType);
    }

    public int hashCode() {
        int result = Arrays.hashCode(this.mType);
        result = 31 * result + (this.mData != null ? Arrays.hashCode(this.mData) : 0);
        result = 31 * result + (int)(this.mCrc32 ^ this.mCrc32 >>> 32);
        return result;
    }

    public String toString() {
        if (Arrays.equals(this.mType, PngWriter.IHDR)) {
            ByteBuffer buffer = ByteBuffer.wrap(this.mData);
            return "Chunk{mType=" + this.getTypeAsString() + ", mData=" + buffer.getInt() + "x" + buffer.getInt() + ":" + buffer.get() + "-" + buffer.get() + "-" + buffer.get() + "-" + buffer.get() + "-" + buffer.get() + '}';
        }
        return "Chunk{mType=" + this.getTypeAsString() + (this.getDataLength() <= 200 ? ", mData=" + this.getArray() : "") + ", mData-Length=" + this.getDataLength() + '}';
    }

    private String getArray() {
        int len = this.getDataLength();
        StringBuilder sb = new StringBuilder(len * 2);
        if (this.mData != null) {
            for (int i = 0; i < len; ++i) {
                sb.append(String.format("%02X", this.mData[i]));
            }
        }
        return sb.toString();
    }
}

