/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.route53recoveryreadiness.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.route53recoveryreadiness.model.Message;
import com.amazonaws.services.route53recoveryreadiness.model.Readiness;
import com.amazonaws.services.route53recoveryreadiness.model.ResourceResult;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class GetReadinessCheckStatusResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private List<Message> messages;
    private String nextToken;
    private String readiness;
    private List<ResourceResult> resources;

    public List<Message> getMessages() {
        return this.messages;
    }

    public void setMessages(Collection<Message> messages) {
        if (messages == null) {
            this.messages = null;
            return;
        }
        this.messages = new ArrayList<Message>(messages);
    }

    public GetReadinessCheckStatusResult withMessages(Message ... messages) {
        if (this.messages == null) {
            this.setMessages(new ArrayList<Message>(messages.length));
        }
        for (Message ele : messages) {
            this.messages.add(ele);
        }
        return this;
    }

    public GetReadinessCheckStatusResult withMessages(Collection<Message> messages) {
        this.setMessages(messages);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public GetReadinessCheckStatusResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public void setReadiness(String readiness) {
        this.readiness = readiness;
    }

    public String getReadiness() {
        return this.readiness;
    }

    public GetReadinessCheckStatusResult withReadiness(String readiness) {
        this.setReadiness(readiness);
        return this;
    }

    public GetReadinessCheckStatusResult withReadiness(Readiness readiness) {
        this.readiness = readiness.toString();
        return this;
    }

    public List<ResourceResult> getResources() {
        return this.resources;
    }

    public void setResources(Collection<ResourceResult> resources) {
        if (resources == null) {
            this.resources = null;
            return;
        }
        this.resources = new ArrayList<ResourceResult>(resources);
    }

    public GetReadinessCheckStatusResult withResources(ResourceResult ... resources) {
        if (this.resources == null) {
            this.setResources(new ArrayList<ResourceResult>(resources.length));
        }
        for (ResourceResult ele : resources) {
            this.resources.add(ele);
        }
        return this;
    }

    public GetReadinessCheckStatusResult withResources(Collection<ResourceResult> resources) {
        this.setResources(resources);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getMessages() != null) {
            sb.append("Messages: ").append(this.getMessages()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken()).append(",");
        }
        if (this.getReadiness() != null) {
            sb.append("Readiness: ").append(this.getReadiness()).append(",");
        }
        if (this.getResources() != null) {
            sb.append("Resources: ").append(this.getResources());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetReadinessCheckStatusResult)) {
            return false;
        }
        GetReadinessCheckStatusResult other = (GetReadinessCheckStatusResult)obj;
        if (other.getMessages() == null ^ this.getMessages() == null) {
            return false;
        }
        if (other.getMessages() != null && !other.getMessages().equals(this.getMessages())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        if (other.getNextToken() != null && !other.getNextToken().equals(this.getNextToken())) {
            return false;
        }
        if (other.getReadiness() == null ^ this.getReadiness() == null) {
            return false;
        }
        if (other.getReadiness() != null && !other.getReadiness().equals(this.getReadiness())) {
            return false;
        }
        if (other.getResources() == null ^ this.getResources() == null) {
            return false;
        }
        return other.getResources() == null || other.getResources().equals(this.getResources());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getMessages() == null ? 0 : this.getMessages().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        hashCode = 31 * hashCode + (this.getReadiness() == null ? 0 : this.getReadiness().hashCode());
        hashCode = 31 * hashCode + (this.getResources() == null ? 0 : this.getResources().hashCode());
        return hashCode;
    }

    public GetReadinessCheckStatusResult clone() {
        try {
            return (GetReadinessCheckStatusResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

