/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.quicksight.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.quicksight.model.Font;
import com.amazonaws.services.quicksight.model.transform.TypographyMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class Typography
implements Serializable,
Cloneable,
StructuredPojo {
    private List<Font> fontFamilies;

    public List<Font> getFontFamilies() {
        return this.fontFamilies;
    }

    public void setFontFamilies(Collection<Font> fontFamilies) {
        if (fontFamilies == null) {
            this.fontFamilies = null;
            return;
        }
        this.fontFamilies = new ArrayList<Font>(fontFamilies);
    }

    public Typography withFontFamilies(Font ... fontFamilies) {
        if (this.fontFamilies == null) {
            this.setFontFamilies(new ArrayList<Font>(fontFamilies.length));
        }
        for (Font ele : fontFamilies) {
            this.fontFamilies.add(ele);
        }
        return this;
    }

    public Typography withFontFamilies(Collection<Font> fontFamilies) {
        this.setFontFamilies(fontFamilies);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getFontFamilies() != null) {
            sb.append("FontFamilies: ").append(this.getFontFamilies());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Typography)) {
            return false;
        }
        Typography other = (Typography)obj;
        if (other.getFontFamilies() == null ^ this.getFontFamilies() == null) {
            return false;
        }
        return other.getFontFamilies() == null || other.getFontFamilies().equals(this.getFontFamilies());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getFontFamilies() == null ? 0 : this.getFontFamilies().hashCode());
        return hashCode;
    }

    public Typography clone() {
        try {
            return (Typography)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        TypographyMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

