/*
 * Copyright 2020-2025 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.pcaconnectorad;

import javax.annotation.Generated;

import com.amazonaws.services.pcaconnectorad.model.*;
import com.amazonaws.*;

/**
 * Abstract implementation of {@code AWSPcaConnectorAd}. Convenient method forms pass through to the corresponding
 * overload that takes a request object, which throws an {@code UnsupportedOperationException}.
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class AbstractAWSPcaConnectorAd implements AWSPcaConnectorAd {

    protected AbstractAWSPcaConnectorAd() {
    }

    @Override
    public CreateConnectorResult createConnector(CreateConnectorRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateDirectoryRegistrationResult createDirectoryRegistration(CreateDirectoryRegistrationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateServicePrincipalNameResult createServicePrincipalName(CreateServicePrincipalNameRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateTemplateResult createTemplate(CreateTemplateRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateTemplateGroupAccessControlEntryResult createTemplateGroupAccessControlEntry(CreateTemplateGroupAccessControlEntryRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteConnectorResult deleteConnector(DeleteConnectorRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteDirectoryRegistrationResult deleteDirectoryRegistration(DeleteDirectoryRegistrationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteServicePrincipalNameResult deleteServicePrincipalName(DeleteServicePrincipalNameRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteTemplateResult deleteTemplate(DeleteTemplateRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteTemplateGroupAccessControlEntryResult deleteTemplateGroupAccessControlEntry(DeleteTemplateGroupAccessControlEntryRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetConnectorResult getConnector(GetConnectorRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetDirectoryRegistrationResult getDirectoryRegistration(GetDirectoryRegistrationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetServicePrincipalNameResult getServicePrincipalName(GetServicePrincipalNameRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetTemplateResult getTemplate(GetTemplateRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetTemplateGroupAccessControlEntryResult getTemplateGroupAccessControlEntry(GetTemplateGroupAccessControlEntryRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListConnectorsResult listConnectors(ListConnectorsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListDirectoryRegistrationsResult listDirectoryRegistrations(ListDirectoryRegistrationsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListServicePrincipalNamesResult listServicePrincipalNames(ListServicePrincipalNamesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListTagsForResourceResult listTagsForResource(ListTagsForResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListTemplateGroupAccessControlEntriesResult listTemplateGroupAccessControlEntries(ListTemplateGroupAccessControlEntriesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListTemplatesResult listTemplates(ListTemplatesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public TagResourceResult tagResource(TagResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UntagResourceResult untagResource(UntagResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateTemplateResult updateTemplate(UpdateTemplateRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateTemplateGroupAccessControlEntryResult updateTemplateGroupAccessControlEntry(UpdateTemplateGroupAccessControlEntryRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public void shutdown() {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public com.amazonaws.ResponseMetadata getCachedResponseMetadata(com.amazonaws.AmazonWebServiceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

}
