/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.paymentcryptography.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.paymentcryptography.model.ImportKeyCryptogram;

@SdkInternalApi
public class ImportKeyCryptogramMarshaller {
    private static final MarshallingInfo<StructuredPojo> KEYATTRIBUTES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("KeyAttributes").build();
    private static final MarshallingInfo<Boolean> EXPORTABLE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Exportable").build();
    private static final MarshallingInfo<String> WRAPPEDKEYCRYPTOGRAM_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("WrappedKeyCryptogram").build();
    private static final MarshallingInfo<String> IMPORTTOKEN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ImportToken").build();
    private static final MarshallingInfo<String> WRAPPINGSPEC_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("WrappingSpec").build();
    private static final ImportKeyCryptogramMarshaller instance = new ImportKeyCryptogramMarshaller();

    public static ImportKeyCryptogramMarshaller getInstance() {
        return instance;
    }

    public void marshall(ImportKeyCryptogram importKeyCryptogram, ProtocolMarshaller protocolMarshaller) {
        if (importKeyCryptogram == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)importKeyCryptogram.getKeyAttributes(), KEYATTRIBUTES_BINDING);
            protocolMarshaller.marshall((Object)importKeyCryptogram.getExportable(), EXPORTABLE_BINDING);
            protocolMarshaller.marshall((Object)importKeyCryptogram.getWrappedKeyCryptogram(), WRAPPEDKEYCRYPTOGRAM_BINDING);
            protocolMarshaller.marshall((Object)importKeyCryptogram.getImportToken(), IMPORTTOKEN_BINDING);
            protocolMarshaller.marshall((Object)importKeyCryptogram.getWrappingSpec(), WRAPPINGSPEC_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

