/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.mediastoredata.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.mediastoredata.model.Item;
import java.util.Date;

@SdkInternalApi
public class ItemMarshaller {
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Name").build();
    private static final MarshallingInfo<String> TYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Type").build();
    private static final MarshallingInfo<String> ETAG_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ETag").build();
    private static final MarshallingInfo<Date> LASTMODIFIED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LastModified").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<String> CONTENTTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ContentType").build();
    private static final MarshallingInfo<Long> CONTENTLENGTH_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ContentLength").build();
    private static final ItemMarshaller instance = new ItemMarshaller();

    public static ItemMarshaller getInstance() {
        return instance;
    }

    public void marshall(Item item, ProtocolMarshaller protocolMarshaller) {
        if (item == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)item.getName(), NAME_BINDING);
            protocolMarshaller.marshall((Object)item.getType(), TYPE_BINDING);
            protocolMarshaller.marshall((Object)item.getETag(), ETAG_BINDING);
            protocolMarshaller.marshall((Object)item.getLastModified(), LASTMODIFIED_BINDING);
            protocolMarshaller.marshall((Object)item.getContentType(), CONTENTTYPE_BINDING);
            protocolMarshaller.marshall((Object)item.getContentLength(), CONTENTLENGTH_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

