/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.mediaconnect.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.mediaconnect.model.Encryption;
import com.amazonaws.services.mediaconnect.model.MediaStreamOutputConfiguration;
import com.amazonaws.services.mediaconnect.model.OutputStatus;
import com.amazonaws.services.mediaconnect.model.Transport;
import com.amazonaws.services.mediaconnect.model.VpcInterfaceAttachment;
import com.amazonaws.services.mediaconnect.model.transform.OutputMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class Output
implements Serializable,
Cloneable,
StructuredPojo {
    private Integer dataTransferSubscriberFeePercent;
    private String description;
    private String destination;
    private Encryption encryption;
    private String entitlementArn;
    private String listenerAddress;
    private String mediaLiveInputArn;
    private List<MediaStreamOutputConfiguration> mediaStreamOutputConfigurations;
    private String name;
    private String outputArn;
    private Integer port;
    private Transport transport;
    private VpcInterfaceAttachment vpcInterfaceAttachment;
    private String bridgeArn;
    private List<Integer> bridgePorts;
    private String outputStatus;

    public void setDataTransferSubscriberFeePercent(Integer dataTransferSubscriberFeePercent) {
        this.dataTransferSubscriberFeePercent = dataTransferSubscriberFeePercent;
    }

    public Integer getDataTransferSubscriberFeePercent() {
        return this.dataTransferSubscriberFeePercent;
    }

    public Output withDataTransferSubscriberFeePercent(Integer dataTransferSubscriberFeePercent) {
        this.setDataTransferSubscriberFeePercent(dataTransferSubscriberFeePercent);
        return this;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public Output withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public void setDestination(String destination) {
        this.destination = destination;
    }

    public String getDestination() {
        return this.destination;
    }

    public Output withDestination(String destination) {
        this.setDestination(destination);
        return this;
    }

    public void setEncryption(Encryption encryption) {
        this.encryption = encryption;
    }

    public Encryption getEncryption() {
        return this.encryption;
    }

    public Output withEncryption(Encryption encryption) {
        this.setEncryption(encryption);
        return this;
    }

    public void setEntitlementArn(String entitlementArn) {
        this.entitlementArn = entitlementArn;
    }

    public String getEntitlementArn() {
        return this.entitlementArn;
    }

    public Output withEntitlementArn(String entitlementArn) {
        this.setEntitlementArn(entitlementArn);
        return this;
    }

    public void setListenerAddress(String listenerAddress) {
        this.listenerAddress = listenerAddress;
    }

    public String getListenerAddress() {
        return this.listenerAddress;
    }

    public Output withListenerAddress(String listenerAddress) {
        this.setListenerAddress(listenerAddress);
        return this;
    }

    public void setMediaLiveInputArn(String mediaLiveInputArn) {
        this.mediaLiveInputArn = mediaLiveInputArn;
    }

    public String getMediaLiveInputArn() {
        return this.mediaLiveInputArn;
    }

    public Output withMediaLiveInputArn(String mediaLiveInputArn) {
        this.setMediaLiveInputArn(mediaLiveInputArn);
        return this;
    }

    public List<MediaStreamOutputConfiguration> getMediaStreamOutputConfigurations() {
        return this.mediaStreamOutputConfigurations;
    }

    public void setMediaStreamOutputConfigurations(Collection<MediaStreamOutputConfiguration> mediaStreamOutputConfigurations) {
        if (mediaStreamOutputConfigurations == null) {
            this.mediaStreamOutputConfigurations = null;
            return;
        }
        this.mediaStreamOutputConfigurations = new ArrayList<MediaStreamOutputConfiguration>(mediaStreamOutputConfigurations);
    }

    public Output withMediaStreamOutputConfigurations(MediaStreamOutputConfiguration ... mediaStreamOutputConfigurations) {
        if (this.mediaStreamOutputConfigurations == null) {
            this.setMediaStreamOutputConfigurations(new ArrayList<MediaStreamOutputConfiguration>(mediaStreamOutputConfigurations.length));
        }
        for (MediaStreamOutputConfiguration ele : mediaStreamOutputConfigurations) {
            this.mediaStreamOutputConfigurations.add(ele);
        }
        return this;
    }

    public Output withMediaStreamOutputConfigurations(Collection<MediaStreamOutputConfiguration> mediaStreamOutputConfigurations) {
        this.setMediaStreamOutputConfigurations(mediaStreamOutputConfigurations);
        return this;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public Output withName(String name) {
        this.setName(name);
        return this;
    }

    public void setOutputArn(String outputArn) {
        this.outputArn = outputArn;
    }

    public String getOutputArn() {
        return this.outputArn;
    }

    public Output withOutputArn(String outputArn) {
        this.setOutputArn(outputArn);
        return this;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public Integer getPort() {
        return this.port;
    }

    public Output withPort(Integer port) {
        this.setPort(port);
        return this;
    }

    public void setTransport(Transport transport) {
        this.transport = transport;
    }

    public Transport getTransport() {
        return this.transport;
    }

    public Output withTransport(Transport transport) {
        this.setTransport(transport);
        return this;
    }

    public void setVpcInterfaceAttachment(VpcInterfaceAttachment vpcInterfaceAttachment) {
        this.vpcInterfaceAttachment = vpcInterfaceAttachment;
    }

    public VpcInterfaceAttachment getVpcInterfaceAttachment() {
        return this.vpcInterfaceAttachment;
    }

    public Output withVpcInterfaceAttachment(VpcInterfaceAttachment vpcInterfaceAttachment) {
        this.setVpcInterfaceAttachment(vpcInterfaceAttachment);
        return this;
    }

    public void setBridgeArn(String bridgeArn) {
        this.bridgeArn = bridgeArn;
    }

    public String getBridgeArn() {
        return this.bridgeArn;
    }

    public Output withBridgeArn(String bridgeArn) {
        this.setBridgeArn(bridgeArn);
        return this;
    }

    public List<Integer> getBridgePorts() {
        return this.bridgePorts;
    }

    public void setBridgePorts(Collection<Integer> bridgePorts) {
        if (bridgePorts == null) {
            this.bridgePorts = null;
            return;
        }
        this.bridgePorts = new ArrayList<Integer>(bridgePorts);
    }

    public Output withBridgePorts(Integer ... bridgePorts) {
        if (this.bridgePorts == null) {
            this.setBridgePorts(new ArrayList<Integer>(bridgePorts.length));
        }
        for (Integer ele : bridgePorts) {
            this.bridgePorts.add(ele);
        }
        return this;
    }

    public Output withBridgePorts(Collection<Integer> bridgePorts) {
        this.setBridgePorts(bridgePorts);
        return this;
    }

    public void setOutputStatus(String outputStatus) {
        this.outputStatus = outputStatus;
    }

    public String getOutputStatus() {
        return this.outputStatus;
    }

    public Output withOutputStatus(String outputStatus) {
        this.setOutputStatus(outputStatus);
        return this;
    }

    public Output withOutputStatus(OutputStatus outputStatus) {
        this.outputStatus = outputStatus.toString();
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDataTransferSubscriberFeePercent() != null) {
            sb.append("DataTransferSubscriberFeePercent: ").append(this.getDataTransferSubscriberFeePercent()).append(",");
        }
        if (this.getDescription() != null) {
            sb.append("Description: ").append(this.getDescription()).append(",");
        }
        if (this.getDestination() != null) {
            sb.append("Destination: ").append(this.getDestination()).append(",");
        }
        if (this.getEncryption() != null) {
            sb.append("Encryption: ").append(this.getEncryption()).append(",");
        }
        if (this.getEntitlementArn() != null) {
            sb.append("EntitlementArn: ").append(this.getEntitlementArn()).append(",");
        }
        if (this.getListenerAddress() != null) {
            sb.append("ListenerAddress: ").append(this.getListenerAddress()).append(",");
        }
        if (this.getMediaLiveInputArn() != null) {
            sb.append("MediaLiveInputArn: ").append(this.getMediaLiveInputArn()).append(",");
        }
        if (this.getMediaStreamOutputConfigurations() != null) {
            sb.append("MediaStreamOutputConfigurations: ").append(this.getMediaStreamOutputConfigurations()).append(",");
        }
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getOutputArn() != null) {
            sb.append("OutputArn: ").append(this.getOutputArn()).append(",");
        }
        if (this.getPort() != null) {
            sb.append("Port: ").append(this.getPort()).append(",");
        }
        if (this.getTransport() != null) {
            sb.append("Transport: ").append(this.getTransport()).append(",");
        }
        if (this.getVpcInterfaceAttachment() != null) {
            sb.append("VpcInterfaceAttachment: ").append(this.getVpcInterfaceAttachment()).append(",");
        }
        if (this.getBridgeArn() != null) {
            sb.append("BridgeArn: ").append(this.getBridgeArn()).append(",");
        }
        if (this.getBridgePorts() != null) {
            sb.append("BridgePorts: ").append(this.getBridgePorts()).append(",");
        }
        if (this.getOutputStatus() != null) {
            sb.append("OutputStatus: ").append(this.getOutputStatus());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Output)) {
            return false;
        }
        Output other = (Output)obj;
        if (other.getDataTransferSubscriberFeePercent() == null ^ this.getDataTransferSubscriberFeePercent() == null) {
            return false;
        }
        if (other.getDataTransferSubscriberFeePercent() != null && !other.getDataTransferSubscriberFeePercent().equals(this.getDataTransferSubscriberFeePercent())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getDestination() == null ^ this.getDestination() == null) {
            return false;
        }
        if (other.getDestination() != null && !other.getDestination().equals(this.getDestination())) {
            return false;
        }
        if (other.getEncryption() == null ^ this.getEncryption() == null) {
            return false;
        }
        if (other.getEncryption() != null && !other.getEncryption().equals(this.getEncryption())) {
            return false;
        }
        if (other.getEntitlementArn() == null ^ this.getEntitlementArn() == null) {
            return false;
        }
        if (other.getEntitlementArn() != null && !other.getEntitlementArn().equals(this.getEntitlementArn())) {
            return false;
        }
        if (other.getListenerAddress() == null ^ this.getListenerAddress() == null) {
            return false;
        }
        if (other.getListenerAddress() != null && !other.getListenerAddress().equals(this.getListenerAddress())) {
            return false;
        }
        if (other.getMediaLiveInputArn() == null ^ this.getMediaLiveInputArn() == null) {
            return false;
        }
        if (other.getMediaLiveInputArn() != null && !other.getMediaLiveInputArn().equals(this.getMediaLiveInputArn())) {
            return false;
        }
        if (other.getMediaStreamOutputConfigurations() == null ^ this.getMediaStreamOutputConfigurations() == null) {
            return false;
        }
        if (other.getMediaStreamOutputConfigurations() != null && !other.getMediaStreamOutputConfigurations().equals(this.getMediaStreamOutputConfigurations())) {
            return false;
        }
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getOutputArn() == null ^ this.getOutputArn() == null) {
            return false;
        }
        if (other.getOutputArn() != null && !other.getOutputArn().equals(this.getOutputArn())) {
            return false;
        }
        if (other.getPort() == null ^ this.getPort() == null) {
            return false;
        }
        if (other.getPort() != null && !other.getPort().equals(this.getPort())) {
            return false;
        }
        if (other.getTransport() == null ^ this.getTransport() == null) {
            return false;
        }
        if (other.getTransport() != null && !other.getTransport().equals(this.getTransport())) {
            return false;
        }
        if (other.getVpcInterfaceAttachment() == null ^ this.getVpcInterfaceAttachment() == null) {
            return false;
        }
        if (other.getVpcInterfaceAttachment() != null && !other.getVpcInterfaceAttachment().equals(this.getVpcInterfaceAttachment())) {
            return false;
        }
        if (other.getBridgeArn() == null ^ this.getBridgeArn() == null) {
            return false;
        }
        if (other.getBridgeArn() != null && !other.getBridgeArn().equals(this.getBridgeArn())) {
            return false;
        }
        if (other.getBridgePorts() == null ^ this.getBridgePorts() == null) {
            return false;
        }
        if (other.getBridgePorts() != null && !other.getBridgePorts().equals(this.getBridgePorts())) {
            return false;
        }
        if (other.getOutputStatus() == null ^ this.getOutputStatus() == null) {
            return false;
        }
        return other.getOutputStatus() == null || other.getOutputStatus().equals(this.getOutputStatus());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDataTransferSubscriberFeePercent() == null ? 0 : this.getDataTransferSubscriberFeePercent().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getDestination() == null ? 0 : this.getDestination().hashCode());
        hashCode = 31 * hashCode + (this.getEncryption() == null ? 0 : this.getEncryption().hashCode());
        hashCode = 31 * hashCode + (this.getEntitlementArn() == null ? 0 : this.getEntitlementArn().hashCode());
        hashCode = 31 * hashCode + (this.getListenerAddress() == null ? 0 : this.getListenerAddress().hashCode());
        hashCode = 31 * hashCode + (this.getMediaLiveInputArn() == null ? 0 : this.getMediaLiveInputArn().hashCode());
        hashCode = 31 * hashCode + (this.getMediaStreamOutputConfigurations() == null ? 0 : this.getMediaStreamOutputConfigurations().hashCode());
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getOutputArn() == null ? 0 : this.getOutputArn().hashCode());
        hashCode = 31 * hashCode + (this.getPort() == null ? 0 : this.getPort().hashCode());
        hashCode = 31 * hashCode + (this.getTransport() == null ? 0 : this.getTransport().hashCode());
        hashCode = 31 * hashCode + (this.getVpcInterfaceAttachment() == null ? 0 : this.getVpcInterfaceAttachment().hashCode());
        hashCode = 31 * hashCode + (this.getBridgeArn() == null ? 0 : this.getBridgeArn().hashCode());
        hashCode = 31 * hashCode + (this.getBridgePorts() == null ? 0 : this.getBridgePorts().hashCode());
        hashCode = 31 * hashCode + (this.getOutputStatus() == null ? 0 : this.getOutputStatus().hashCode());
        return hashCode;
    }

    public Output clone() {
        try {
            return (Output)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        OutputMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

