/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.mailmanager.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.mailmanager.model.Row;
import java.util.Date;
import java.util.List;

@SdkInternalApi
public class RowMarshaller {
    private static final MarshallingInfo<String> ARCHIVEDMESSAGEID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ArchivedMessageId").build();
    private static final MarshallingInfo<String> CC_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Cc").build();
    private static final MarshallingInfo<String> DATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Date").build();
    private static final MarshallingInfo<String> FROM_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("From").build();
    private static final MarshallingInfo<Boolean> HASATTACHMENTS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("HasAttachments").build();
    private static final MarshallingInfo<String> INREPLYTO_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InReplyTo").build();
    private static final MarshallingInfo<String> MESSAGEID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MessageId").build();
    private static final MarshallingInfo<List> RECEIVEDHEADERS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ReceivedHeaders").build();
    private static final MarshallingInfo<Date> RECEIVEDTIMESTAMP_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ReceivedTimestamp").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<String> SUBJECT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Subject").build();
    private static final MarshallingInfo<String> TO_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("To").build();
    private static final MarshallingInfo<String> XMAILER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("XMailer").build();
    private static final MarshallingInfo<String> XORIGINALMAILER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("XOriginalMailer").build();
    private static final MarshallingInfo<String> XPRIORITY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("XPriority").build();
    private static final RowMarshaller instance = new RowMarshaller();

    public static RowMarshaller getInstance() {
        return instance;
    }

    public void marshall(Row row, ProtocolMarshaller protocolMarshaller) {
        if (row == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)row.getArchivedMessageId(), ARCHIVEDMESSAGEID_BINDING);
            protocolMarshaller.marshall((Object)row.getCc(), CC_BINDING);
            protocolMarshaller.marshall((Object)row.getDate(), DATE_BINDING);
            protocolMarshaller.marshall((Object)row.getFrom(), FROM_BINDING);
            protocolMarshaller.marshall((Object)row.getHasAttachments(), HASATTACHMENTS_BINDING);
            protocolMarshaller.marshall((Object)row.getInReplyTo(), INREPLYTO_BINDING);
            protocolMarshaller.marshall((Object)row.getMessageId(), MESSAGEID_BINDING);
            protocolMarshaller.marshall(row.getReceivedHeaders(), RECEIVEDHEADERS_BINDING);
            protocolMarshaller.marshall((Object)row.getReceivedTimestamp(), RECEIVEDTIMESTAMP_BINDING);
            protocolMarshaller.marshall((Object)row.getSubject(), SUBJECT_BINDING);
            protocolMarshaller.marshall((Object)row.getTo(), TO_BINDING);
            protocolMarshaller.marshall((Object)row.getXMailer(), XMAILER_BINDING);
            protocolMarshaller.marshall((Object)row.getXOriginalMailer(), XORIGINALMAILER_BINDING);
            protocolMarshaller.marshall((Object)row.getXPriority(), XPRIORITY_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

