/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesisvideo.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.kinesisvideo.model.MediaSourceConfig;

@SdkInternalApi
public class MediaSourceConfigMarshaller {
    private static final MarshallingInfo<String> MEDIAURISECRETARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MediaUriSecretArn").build();
    private static final MarshallingInfo<String> MEDIAURITYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MediaUriType").build();
    private static final MediaSourceConfigMarshaller instance = new MediaSourceConfigMarshaller();

    public static MediaSourceConfigMarshaller getInstance() {
        return instance;
    }

    public void marshall(MediaSourceConfig mediaSourceConfig, ProtocolMarshaller protocolMarshaller) {
        if (mediaSourceConfig == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)mediaSourceConfig.getMediaUriSecretArn(), MEDIAURISECRETARN_BINDING);
            protocolMarshaller.marshall((Object)mediaSourceConfig.getMediaUriType(), MEDIAURITYPE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

