/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesisanalyticsv2.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.kinesisanalyticsv2.model.ApplicationRestoreConfiguration;
import com.amazonaws.services.kinesisanalyticsv2.model.FlinkRunConfiguration;
import com.amazonaws.services.kinesisanalyticsv2.model.SqlRunConfiguration;
import com.amazonaws.services.kinesisanalyticsv2.model.transform.RunConfigurationMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class RunConfiguration
implements Serializable,
Cloneable,
StructuredPojo {
    private FlinkRunConfiguration flinkRunConfiguration;
    private List<SqlRunConfiguration> sqlRunConfigurations;
    private ApplicationRestoreConfiguration applicationRestoreConfiguration;

    public void setFlinkRunConfiguration(FlinkRunConfiguration flinkRunConfiguration) {
        this.flinkRunConfiguration = flinkRunConfiguration;
    }

    public FlinkRunConfiguration getFlinkRunConfiguration() {
        return this.flinkRunConfiguration;
    }

    public RunConfiguration withFlinkRunConfiguration(FlinkRunConfiguration flinkRunConfiguration) {
        this.setFlinkRunConfiguration(flinkRunConfiguration);
        return this;
    }

    public List<SqlRunConfiguration> getSqlRunConfigurations() {
        return this.sqlRunConfigurations;
    }

    public void setSqlRunConfigurations(Collection<SqlRunConfiguration> sqlRunConfigurations) {
        if (sqlRunConfigurations == null) {
            this.sqlRunConfigurations = null;
            return;
        }
        this.sqlRunConfigurations = new ArrayList<SqlRunConfiguration>(sqlRunConfigurations);
    }

    public RunConfiguration withSqlRunConfigurations(SqlRunConfiguration ... sqlRunConfigurations) {
        if (this.sqlRunConfigurations == null) {
            this.setSqlRunConfigurations(new ArrayList<SqlRunConfiguration>(sqlRunConfigurations.length));
        }
        for (SqlRunConfiguration ele : sqlRunConfigurations) {
            this.sqlRunConfigurations.add(ele);
        }
        return this;
    }

    public RunConfiguration withSqlRunConfigurations(Collection<SqlRunConfiguration> sqlRunConfigurations) {
        this.setSqlRunConfigurations(sqlRunConfigurations);
        return this;
    }

    public void setApplicationRestoreConfiguration(ApplicationRestoreConfiguration applicationRestoreConfiguration) {
        this.applicationRestoreConfiguration = applicationRestoreConfiguration;
    }

    public ApplicationRestoreConfiguration getApplicationRestoreConfiguration() {
        return this.applicationRestoreConfiguration;
    }

    public RunConfiguration withApplicationRestoreConfiguration(ApplicationRestoreConfiguration applicationRestoreConfiguration) {
        this.setApplicationRestoreConfiguration(applicationRestoreConfiguration);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getFlinkRunConfiguration() != null) {
            sb.append("FlinkRunConfiguration: ").append(this.getFlinkRunConfiguration()).append(",");
        }
        if (this.getSqlRunConfigurations() != null) {
            sb.append("SqlRunConfigurations: ").append(this.getSqlRunConfigurations()).append(",");
        }
        if (this.getApplicationRestoreConfiguration() != null) {
            sb.append("ApplicationRestoreConfiguration: ").append(this.getApplicationRestoreConfiguration());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RunConfiguration)) {
            return false;
        }
        RunConfiguration other = (RunConfiguration)obj;
        if (other.getFlinkRunConfiguration() == null ^ this.getFlinkRunConfiguration() == null) {
            return false;
        }
        if (other.getFlinkRunConfiguration() != null && !other.getFlinkRunConfiguration().equals(this.getFlinkRunConfiguration())) {
            return false;
        }
        if (other.getSqlRunConfigurations() == null ^ this.getSqlRunConfigurations() == null) {
            return false;
        }
        if (other.getSqlRunConfigurations() != null && !other.getSqlRunConfigurations().equals(this.getSqlRunConfigurations())) {
            return false;
        }
        if (other.getApplicationRestoreConfiguration() == null ^ this.getApplicationRestoreConfiguration() == null) {
            return false;
        }
        return other.getApplicationRestoreConfiguration() == null || other.getApplicationRestoreConfiguration().equals(this.getApplicationRestoreConfiguration());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getFlinkRunConfiguration() == null ? 0 : this.getFlinkRunConfiguration().hashCode());
        hashCode = 31 * hashCode + (this.getSqlRunConfigurations() == null ? 0 : this.getSqlRunConfigurations().hashCode());
        hashCode = 31 * hashCode + (this.getApplicationRestoreConfiguration() == null ? 0 : this.getApplicationRestoreConfiguration().hashCode());
        return hashCode;
    }

    public RunConfiguration clone() {
        try {
            return (RunConfiguration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        RunConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

