/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iottwinmaker.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.iottwinmaker.model.ComponentPropertyGroupRequest;
import com.amazonaws.services.iottwinmaker.model.ComponentUpdateType;
import com.amazonaws.services.iottwinmaker.model.PropertyRequest;
import com.amazonaws.services.iottwinmaker.model.transform.CompositeComponentUpdateRequestMarshaller;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class CompositeComponentUpdateRequest
implements Serializable,
Cloneable,
StructuredPojo {
    private String updateType;
    private String description;
    private Map<String, PropertyRequest> propertyUpdates;
    private Map<String, ComponentPropertyGroupRequest> propertyGroupUpdates;

    public void setUpdateType(String updateType) {
        this.updateType = updateType;
    }

    public String getUpdateType() {
        return this.updateType;
    }

    public CompositeComponentUpdateRequest withUpdateType(String updateType) {
        this.setUpdateType(updateType);
        return this;
    }

    public CompositeComponentUpdateRequest withUpdateType(ComponentUpdateType updateType) {
        this.updateType = updateType.toString();
        return this;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public CompositeComponentUpdateRequest withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public Map<String, PropertyRequest> getPropertyUpdates() {
        return this.propertyUpdates;
    }

    public void setPropertyUpdates(Map<String, PropertyRequest> propertyUpdates) {
        this.propertyUpdates = propertyUpdates;
    }

    public CompositeComponentUpdateRequest withPropertyUpdates(Map<String, PropertyRequest> propertyUpdates) {
        this.setPropertyUpdates(propertyUpdates);
        return this;
    }

    public CompositeComponentUpdateRequest addPropertyUpdatesEntry(String key, PropertyRequest value) {
        if (null == this.propertyUpdates) {
            this.propertyUpdates = new HashMap<String, PropertyRequest>();
        }
        if (this.propertyUpdates.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.propertyUpdates.put(key, value);
        return this;
    }

    public CompositeComponentUpdateRequest clearPropertyUpdatesEntries() {
        this.propertyUpdates = null;
        return this;
    }

    public Map<String, ComponentPropertyGroupRequest> getPropertyGroupUpdates() {
        return this.propertyGroupUpdates;
    }

    public void setPropertyGroupUpdates(Map<String, ComponentPropertyGroupRequest> propertyGroupUpdates) {
        this.propertyGroupUpdates = propertyGroupUpdates;
    }

    public CompositeComponentUpdateRequest withPropertyGroupUpdates(Map<String, ComponentPropertyGroupRequest> propertyGroupUpdates) {
        this.setPropertyGroupUpdates(propertyGroupUpdates);
        return this;
    }

    public CompositeComponentUpdateRequest addPropertyGroupUpdatesEntry(String key, ComponentPropertyGroupRequest value) {
        if (null == this.propertyGroupUpdates) {
            this.propertyGroupUpdates = new HashMap<String, ComponentPropertyGroupRequest>();
        }
        if (this.propertyGroupUpdates.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.propertyGroupUpdates.put(key, value);
        return this;
    }

    public CompositeComponentUpdateRequest clearPropertyGroupUpdatesEntries() {
        this.propertyGroupUpdates = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getUpdateType() != null) {
            sb.append("UpdateType: ").append(this.getUpdateType()).append(",");
        }
        if (this.getDescription() != null) {
            sb.append("Description: ").append(this.getDescription()).append(",");
        }
        if (this.getPropertyUpdates() != null) {
            sb.append("PropertyUpdates: ").append(this.getPropertyUpdates()).append(",");
        }
        if (this.getPropertyGroupUpdates() != null) {
            sb.append("PropertyGroupUpdates: ").append(this.getPropertyGroupUpdates());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CompositeComponentUpdateRequest)) {
            return false;
        }
        CompositeComponentUpdateRequest other = (CompositeComponentUpdateRequest)obj;
        if (other.getUpdateType() == null ^ this.getUpdateType() == null) {
            return false;
        }
        if (other.getUpdateType() != null && !other.getUpdateType().equals(this.getUpdateType())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getPropertyUpdates() == null ^ this.getPropertyUpdates() == null) {
            return false;
        }
        if (other.getPropertyUpdates() != null && !other.getPropertyUpdates().equals(this.getPropertyUpdates())) {
            return false;
        }
        if (other.getPropertyGroupUpdates() == null ^ this.getPropertyGroupUpdates() == null) {
            return false;
        }
        return other.getPropertyGroupUpdates() == null || other.getPropertyGroupUpdates().equals(this.getPropertyGroupUpdates());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getUpdateType() == null ? 0 : this.getUpdateType().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getPropertyUpdates() == null ? 0 : this.getPropertyUpdates().hashCode());
        hashCode = 31 * hashCode + (this.getPropertyGroupUpdates() == null ? 0 : this.getPropertyGroupUpdates().hashCode());
        return hashCode;
    }

    public CompositeComponentUpdateRequest clone() {
        try {
            return (CompositeComponentUpdateRequest)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        CompositeComponentUpdateRequestMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

