/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.globalaccelerator.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.globalaccelerator.model.PortRange;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CreateCustomRoutingListenerRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String acceleratorArn;
    private List<PortRange> portRanges;
    private String idempotencyToken;

    public void setAcceleratorArn(String acceleratorArn) {
        this.acceleratorArn = acceleratorArn;
    }

    public String getAcceleratorArn() {
        return this.acceleratorArn;
    }

    public CreateCustomRoutingListenerRequest withAcceleratorArn(String acceleratorArn) {
        this.setAcceleratorArn(acceleratorArn);
        return this;
    }

    public List<PortRange> getPortRanges() {
        return this.portRanges;
    }

    public void setPortRanges(Collection<PortRange> portRanges) {
        if (portRanges == null) {
            this.portRanges = null;
            return;
        }
        this.portRanges = new ArrayList<PortRange>(portRanges);
    }

    public CreateCustomRoutingListenerRequest withPortRanges(PortRange ... portRanges) {
        if (this.portRanges == null) {
            this.setPortRanges(new ArrayList<PortRange>(portRanges.length));
        }
        for (PortRange ele : portRanges) {
            this.portRanges.add(ele);
        }
        return this;
    }

    public CreateCustomRoutingListenerRequest withPortRanges(Collection<PortRange> portRanges) {
        this.setPortRanges(portRanges);
        return this;
    }

    public void setIdempotencyToken(String idempotencyToken) {
        this.idempotencyToken = idempotencyToken;
    }

    public String getIdempotencyToken() {
        return this.idempotencyToken;
    }

    public CreateCustomRoutingListenerRequest withIdempotencyToken(String idempotencyToken) {
        this.setIdempotencyToken(idempotencyToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAcceleratorArn() != null) {
            sb.append("AcceleratorArn: ").append(this.getAcceleratorArn()).append(",");
        }
        if (this.getPortRanges() != null) {
            sb.append("PortRanges: ").append(this.getPortRanges()).append(",");
        }
        if (this.getIdempotencyToken() != null) {
            sb.append("IdempotencyToken: ").append(this.getIdempotencyToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateCustomRoutingListenerRequest)) {
            return false;
        }
        CreateCustomRoutingListenerRequest other = (CreateCustomRoutingListenerRequest)obj;
        if (other.getAcceleratorArn() == null ^ this.getAcceleratorArn() == null) {
            return false;
        }
        if (other.getAcceleratorArn() != null && !other.getAcceleratorArn().equals(this.getAcceleratorArn())) {
            return false;
        }
        if (other.getPortRanges() == null ^ this.getPortRanges() == null) {
            return false;
        }
        if (other.getPortRanges() != null && !other.getPortRanges().equals(this.getPortRanges())) {
            return false;
        }
        if (other.getIdempotencyToken() == null ^ this.getIdempotencyToken() == null) {
            return false;
        }
        return other.getIdempotencyToken() == null || other.getIdempotencyToken().equals(this.getIdempotencyToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAcceleratorArn() == null ? 0 : this.getAcceleratorArn().hashCode());
        hashCode = 31 * hashCode + (this.getPortRanges() == null ? 0 : this.getPortRanges().hashCode());
        hashCode = 31 * hashCode + (this.getIdempotencyToken() == null ? 0 : this.getIdempotencyToken().hashCode());
        return hashCode;
    }

    public CreateCustomRoutingListenerRequest clone() {
        return (CreateCustomRoutingListenerRequest)super.clone();
    }
}

