/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticloadbalancingv2.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.elasticloadbalancingv2.model.DescribeSSLPoliciesRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.List;

public class DescribeSSLPoliciesRequestMarshaller
implements Marshaller<Request<DescribeSSLPoliciesRequest>, DescribeSSLPoliciesRequest> {
    public Request<DescribeSSLPoliciesRequest> marshall(DescribeSSLPoliciesRequest describeSSLPoliciesRequest) {
        if (describeSSLPoliciesRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeSSLPoliciesRequest, "AmazonElasticLoadBalancing");
        request.addParameter("Action", "DescribeSSLPolicies");
        request.addParameter("Version", "2015-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        List<String> namesList = describeSSLPoliciesRequest.getNames();
        if (namesList != null) {
            if (namesList.isEmpty()) {
                request.addParameter("Names", "");
            } else {
                int namesListIndex = 1;
                for (String namesListValue : namesList) {
                    if (namesListValue != null) {
                        request.addParameter("Names.member." + namesListIndex, StringUtils.fromString((String)namesListValue));
                    }
                    ++namesListIndex;
                }
            }
        }
        if (describeSSLPoliciesRequest.getMarker() != null) {
            request.addParameter("Marker", StringUtils.fromString((String)describeSSLPoliciesRequest.getMarker()));
        }
        if (describeSSLPoliciesRequest.getPageSize() != null) {
            request.addParameter("PageSize", StringUtils.fromInteger((Integer)describeSSLPoliciesRequest.getPageSize()));
        }
        return request;
    }
}

