/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticache.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.elasticache.model.CreateServerlessCacheSnapshotRequest;
import com.amazonaws.services.elasticache.model.Tag;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class CreateServerlessCacheSnapshotRequestMarshaller
implements Marshaller<Request<CreateServerlessCacheSnapshotRequest>, CreateServerlessCacheSnapshotRequest> {
    public Request<CreateServerlessCacheSnapshotRequest> marshall(CreateServerlessCacheSnapshotRequest createServerlessCacheSnapshotRequest) {
        if (createServerlessCacheSnapshotRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createServerlessCacheSnapshotRequest, "AmazonElastiCache");
        request.addParameter("Action", "CreateServerlessCacheSnapshot");
        request.addParameter("Version", "2015-02-02");
        request.setHttpMethod(HttpMethodName.POST);
        if (createServerlessCacheSnapshotRequest.getServerlessCacheSnapshotName() != null) {
            request.addParameter("ServerlessCacheSnapshotName", StringUtils.fromString((String)createServerlessCacheSnapshotRequest.getServerlessCacheSnapshotName()));
        }
        if (createServerlessCacheSnapshotRequest.getServerlessCacheName() != null) {
            request.addParameter("ServerlessCacheName", StringUtils.fromString((String)createServerlessCacheSnapshotRequest.getServerlessCacheName()));
        }
        if (createServerlessCacheSnapshotRequest.getKmsKeyId() != null) {
            request.addParameter("KmsKeyId", StringUtils.fromString((String)createServerlessCacheSnapshotRequest.getKmsKeyId()));
        }
        if (!createServerlessCacheSnapshotRequest.getTags().isEmpty() || !((SdkInternalList)createServerlessCacheSnapshotRequest.getTags()).isAutoConstruct()) {
            SdkInternalList tagsList = (SdkInternalList)createServerlessCacheSnapshotRequest.getTags();
            int tagsListIndex = 1;
            for (Tag tagsListValue : tagsList) {
                if (tagsListValue != null) {
                    if (tagsListValue.getKey() != null) {
                        request.addParameter("Tags.Tag." + tagsListIndex + ".Key", StringUtils.fromString((String)tagsListValue.getKey()));
                    }
                    if (tagsListValue.getValue() != null) {
                        request.addParameter("Tags.Tag." + tagsListIndex + ".Value", StringUtils.fromString((String)tagsListValue.getValue()));
                    }
                }
                ++tagsListIndex;
            }
        }
        return request;
    }
}

