/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.ec2.model.CreateVpnConnectionRequest;
import com.amazonaws.services.ec2.model.VpnConnectionOptionsSpecification;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class CreateVpnConnectionRequestMarshaller
implements Marshaller<Request<CreateVpnConnectionRequest>, CreateVpnConnectionRequest> {
    public Request<CreateVpnConnectionRequest> marshall(CreateVpnConnectionRequest createVpnConnectionRequest) {
        VpnConnectionOptionsSpecification vpnConnectionOptionsSpecificationOptions;
        if (createVpnConnectionRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createVpnConnectionRequest, "AmazonEC2");
        request.addParameter("Action", "CreateVpnConnection");
        request.addParameter("Version", "2014-10-01");
        if (createVpnConnectionRequest.getType() != null) {
            request.addParameter("Type", StringUtils.fromString((String)createVpnConnectionRequest.getType()));
        }
        if (createVpnConnectionRequest.getCustomerGatewayId() != null) {
            request.addParameter("CustomerGatewayId", StringUtils.fromString((String)createVpnConnectionRequest.getCustomerGatewayId()));
        }
        if (createVpnConnectionRequest.getVpnGatewayId() != null) {
            request.addParameter("VpnGatewayId", StringUtils.fromString((String)createVpnConnectionRequest.getVpnGatewayId()));
        }
        if ((vpnConnectionOptionsSpecificationOptions = createVpnConnectionRequest.getOptions()) != null && vpnConnectionOptionsSpecificationOptions.isStaticRoutesOnly() != null) {
            request.addParameter("Options.StaticRoutesOnly", StringUtils.fromBoolean((Boolean)vpnConnectionOptionsSpecificationOptions.isStaticRoutesOnly()));
        }
        return request;
    }
}

