/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.BlockDeviceMapping;
import com.amazonaws.services.ec2.model.EbsBlockDevice;
import com.amazonaws.services.ec2.model.IamInstanceProfileSpecification;
import com.amazonaws.services.ec2.model.InstanceIpv6Address;
import com.amazonaws.services.ec2.model.InstanceNetworkInterfaceSpecification;
import com.amazonaws.services.ec2.model.Placement;
import com.amazonaws.services.ec2.model.PrivateIpAddressSpecification;
import com.amazonaws.services.ec2.model.RunInstancesRequest;
import com.amazonaws.services.ec2.model.Tag;
import com.amazonaws.services.ec2.model.TagSpecification;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class RunInstancesRequestMarshaller
implements Marshaller<Request<RunInstancesRequest>, RunInstancesRequest> {
    public Request<RunInstancesRequest> marshall(RunInstancesRequest runInstancesRequest) {
        SdkInternalList runInstancesRequestTagSpecificationsList;
        SdkInternalList runInstancesRequestNetworkInterfacesList;
        IamInstanceProfileSpecification iamInstanceProfile;
        SdkInternalList runInstancesRequestSecurityGroupsList;
        SdkInternalList runInstancesRequestSecurityGroupIdsList;
        Placement placement;
        SdkInternalList runInstancesRequestIpv6AddressesList;
        if (runInstancesRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)runInstancesRequest, "AmazonEC2");
        request.addParameter("Action", "RunInstances");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        SdkInternalList runInstancesRequestBlockDeviceMappingsList = (SdkInternalList)runInstancesRequest.getBlockDeviceMappings();
        if (!runInstancesRequestBlockDeviceMappingsList.isEmpty() || !runInstancesRequestBlockDeviceMappingsList.isAutoConstruct()) {
            int blockDeviceMappingsListIndex = 1;
            for (Object runInstancesRequestBlockDeviceMappingsListValue : runInstancesRequestBlockDeviceMappingsList) {
                EbsBlockDevice ebs;
                if (((BlockDeviceMapping)runInstancesRequestBlockDeviceMappingsListValue).getDeviceName() != null) {
                    request.addParameter("BlockDeviceMapping." + blockDeviceMappingsListIndex + ".DeviceName", StringUtils.fromString((String)((BlockDeviceMapping)runInstancesRequestBlockDeviceMappingsListValue).getDeviceName()));
                }
                if (((BlockDeviceMapping)runInstancesRequestBlockDeviceMappingsListValue).getVirtualName() != null) {
                    request.addParameter("BlockDeviceMapping." + blockDeviceMappingsListIndex + ".VirtualName", StringUtils.fromString((String)((BlockDeviceMapping)runInstancesRequestBlockDeviceMappingsListValue).getVirtualName()));
                }
                if ((ebs = ((BlockDeviceMapping)runInstancesRequestBlockDeviceMappingsListValue).getEbs()) != null) {
                    if (ebs.getEncrypted() != null) {
                        request.addParameter("BlockDeviceMapping." + blockDeviceMappingsListIndex + ".Ebs.Encrypted", StringUtils.fromBoolean((Boolean)ebs.getEncrypted()));
                    }
                    if (ebs.getDeleteOnTermination() != null) {
                        request.addParameter("BlockDeviceMapping." + blockDeviceMappingsListIndex + ".Ebs.DeleteOnTermination", StringUtils.fromBoolean((Boolean)ebs.getDeleteOnTermination()));
                    }
                    if (ebs.getIops() != null) {
                        request.addParameter("BlockDeviceMapping." + blockDeviceMappingsListIndex + ".Ebs.Iops", StringUtils.fromInteger((Integer)ebs.getIops()));
                    }
                    if (ebs.getSnapshotId() != null) {
                        request.addParameter("BlockDeviceMapping." + blockDeviceMappingsListIndex + ".Ebs.SnapshotId", StringUtils.fromString((String)ebs.getSnapshotId()));
                    }
                    if (ebs.getVolumeSize() != null) {
                        request.addParameter("BlockDeviceMapping." + blockDeviceMappingsListIndex + ".Ebs.VolumeSize", StringUtils.fromInteger((Integer)ebs.getVolumeSize()));
                    }
                    if (ebs.getVolumeType() != null) {
                        request.addParameter("BlockDeviceMapping." + blockDeviceMappingsListIndex + ".Ebs.VolumeType", StringUtils.fromString((String)ebs.getVolumeType()));
                    }
                }
                if (((BlockDeviceMapping)runInstancesRequestBlockDeviceMappingsListValue).getNoDevice() != null) {
                    request.addParameter("BlockDeviceMapping." + blockDeviceMappingsListIndex + ".NoDevice", StringUtils.fromString((String)((BlockDeviceMapping)runInstancesRequestBlockDeviceMappingsListValue).getNoDevice()));
                }
                ++blockDeviceMappingsListIndex;
            }
        }
        if (runInstancesRequest.getImageId() != null) {
            request.addParameter("ImageId", StringUtils.fromString((String)runInstancesRequest.getImageId()));
        }
        if (runInstancesRequest.getInstanceType() != null) {
            request.addParameter("InstanceType", StringUtils.fromString((String)runInstancesRequest.getInstanceType()));
        }
        if (runInstancesRequest.getIpv6AddressCount() != null) {
            request.addParameter("Ipv6AddressCount", StringUtils.fromInteger((Integer)runInstancesRequest.getIpv6AddressCount()));
        }
        if (!(runInstancesRequestIpv6AddressesList = (SdkInternalList)runInstancesRequest.getIpv6Addresses()).isEmpty() || !runInstancesRequestIpv6AddressesList.isAutoConstruct()) {
            int ipv6AddressesListIndex = 1;
            for (InstanceIpv6Address runInstancesRequestIpv6AddressesListValue : runInstancesRequestIpv6AddressesList) {
                if (runInstancesRequestIpv6AddressesListValue.getIpv6Address() != null) {
                    request.addParameter("Ipv6Address." + ipv6AddressesListIndex + ".Ipv6Address", StringUtils.fromString((String)runInstancesRequestIpv6AddressesListValue.getIpv6Address()));
                }
                ++ipv6AddressesListIndex;
            }
        }
        if (runInstancesRequest.getKernelId() != null) {
            request.addParameter("KernelId", StringUtils.fromString((String)runInstancesRequest.getKernelId()));
        }
        if (runInstancesRequest.getKeyName() != null) {
            request.addParameter("KeyName", StringUtils.fromString((String)runInstancesRequest.getKeyName()));
        }
        if (runInstancesRequest.getMaxCount() != null) {
            request.addParameter("MaxCount", StringUtils.fromInteger((Integer)runInstancesRequest.getMaxCount()));
        }
        if (runInstancesRequest.getMinCount() != null) {
            request.addParameter("MinCount", StringUtils.fromInteger((Integer)runInstancesRequest.getMinCount()));
        }
        if (runInstancesRequest.getMonitoring() != null) {
            request.addParameter("Monitoring.Enabled", StringUtils.fromBoolean((Boolean)runInstancesRequest.getMonitoring()));
        }
        if ((placement = runInstancesRequest.getPlacement()) != null) {
            if (placement.getAvailabilityZone() != null) {
                request.addParameter("Placement.AvailabilityZone", StringUtils.fromString((String)placement.getAvailabilityZone()));
            }
            if (placement.getAffinity() != null) {
                request.addParameter("Placement.Affinity", StringUtils.fromString((String)placement.getAffinity()));
            }
            if (placement.getGroupName() != null) {
                request.addParameter("Placement.GroupName", StringUtils.fromString((String)placement.getGroupName()));
            }
            if (placement.getHostId() != null) {
                request.addParameter("Placement.HostId", StringUtils.fromString((String)placement.getHostId()));
            }
            if (placement.getTenancy() != null) {
                request.addParameter("Placement.Tenancy", StringUtils.fromString((String)placement.getTenancy()));
            }
            if (placement.getSpreadDomain() != null) {
                request.addParameter("Placement.SpreadDomain", StringUtils.fromString((String)placement.getSpreadDomain()));
            }
        }
        if (runInstancesRequest.getRamdiskId() != null) {
            request.addParameter("RamdiskId", StringUtils.fromString((String)runInstancesRequest.getRamdiskId()));
        }
        if (!(runInstancesRequestSecurityGroupIdsList = (SdkInternalList)runInstancesRequest.getSecurityGroupIds()).isEmpty() || !runInstancesRequestSecurityGroupIdsList.isAutoConstruct()) {
            int securityGroupIdsListIndex = 1;
            for (Object runInstancesRequestSecurityGroupIdsListValue : runInstancesRequestSecurityGroupIdsList) {
                if (runInstancesRequestSecurityGroupIdsListValue != null) {
                    request.addParameter("SecurityGroupId." + securityGroupIdsListIndex, StringUtils.fromString((String)runInstancesRequestSecurityGroupIdsListValue));
                }
                ++securityGroupIdsListIndex;
            }
        }
        if (!(runInstancesRequestSecurityGroupsList = (SdkInternalList)runInstancesRequest.getSecurityGroups()).isEmpty() || !runInstancesRequestSecurityGroupsList.isAutoConstruct()) {
            int securityGroupsListIndex = 1;
            for (String runInstancesRequestSecurityGroupsListValue : runInstancesRequestSecurityGroupsList) {
                if (runInstancesRequestSecurityGroupsListValue != null) {
                    request.addParameter("SecurityGroup." + securityGroupsListIndex, StringUtils.fromString((String)runInstancesRequestSecurityGroupsListValue));
                }
                ++securityGroupsListIndex;
            }
        }
        if (runInstancesRequest.getSubnetId() != null) {
            request.addParameter("SubnetId", StringUtils.fromString((String)runInstancesRequest.getSubnetId()));
        }
        if (runInstancesRequest.getUserData() != null) {
            request.addParameter("UserData", StringUtils.fromString((String)runInstancesRequest.getUserData()));
        }
        if (runInstancesRequest.getAdditionalInfo() != null) {
            request.addParameter("AdditionalInfo", StringUtils.fromString((String)runInstancesRequest.getAdditionalInfo()));
        }
        if (runInstancesRequest.getClientToken() != null) {
            request.addParameter("ClientToken", StringUtils.fromString((String)runInstancesRequest.getClientToken()));
        }
        if (runInstancesRequest.getDisableApiTermination() != null) {
            request.addParameter("DisableApiTermination", StringUtils.fromBoolean((Boolean)runInstancesRequest.getDisableApiTermination()));
        }
        if (runInstancesRequest.getEbsOptimized() != null) {
            request.addParameter("EbsOptimized", StringUtils.fromBoolean((Boolean)runInstancesRequest.getEbsOptimized()));
        }
        if ((iamInstanceProfile = runInstancesRequest.getIamInstanceProfile()) != null) {
            if (iamInstanceProfile.getArn() != null) {
                request.addParameter("IamInstanceProfile.Arn", StringUtils.fromString((String)iamInstanceProfile.getArn()));
            }
            if (iamInstanceProfile.getName() != null) {
                request.addParameter("IamInstanceProfile.Name", StringUtils.fromString((String)iamInstanceProfile.getName()));
            }
        }
        if (runInstancesRequest.getInstanceInitiatedShutdownBehavior() != null) {
            request.addParameter("InstanceInitiatedShutdownBehavior", StringUtils.fromString((String)runInstancesRequest.getInstanceInitiatedShutdownBehavior()));
        }
        if (!(runInstancesRequestNetworkInterfacesList = (SdkInternalList)runInstancesRequest.getNetworkInterfaces()).isEmpty() || !runInstancesRequestNetworkInterfacesList.isAutoConstruct()) {
            int networkInterfacesListIndex = 1;
            for (InstanceNetworkInterfaceSpecification runInstancesRequestNetworkInterfacesListValue : runInstancesRequestNetworkInterfacesList) {
                SdkInternalList instanceNetworkInterfaceSpecificationPrivateIpAddressesList;
                SdkInternalList instanceNetworkInterfaceSpecificationIpv6AddressesList;
                SdkInternalList instanceNetworkInterfaceSpecificationGroupsList;
                if (runInstancesRequestNetworkInterfacesListValue.getAssociatePublicIpAddress() != null) {
                    request.addParameter("NetworkInterface." + networkInterfacesListIndex + ".AssociatePublicIpAddress", StringUtils.fromBoolean((Boolean)runInstancesRequestNetworkInterfacesListValue.getAssociatePublicIpAddress()));
                }
                if (runInstancesRequestNetworkInterfacesListValue.getDeleteOnTermination() != null) {
                    request.addParameter("NetworkInterface." + networkInterfacesListIndex + ".DeleteOnTermination", StringUtils.fromBoolean((Boolean)runInstancesRequestNetworkInterfacesListValue.getDeleteOnTermination()));
                }
                if (runInstancesRequestNetworkInterfacesListValue.getDescription() != null) {
                    request.addParameter("NetworkInterface." + networkInterfacesListIndex + ".Description", StringUtils.fromString((String)runInstancesRequestNetworkInterfacesListValue.getDescription()));
                }
                if (runInstancesRequestNetworkInterfacesListValue.getDeviceIndex() != null) {
                    request.addParameter("NetworkInterface." + networkInterfacesListIndex + ".DeviceIndex", StringUtils.fromInteger((Integer)runInstancesRequestNetworkInterfacesListValue.getDeviceIndex()));
                }
                if (!(instanceNetworkInterfaceSpecificationGroupsList = (SdkInternalList)runInstancesRequestNetworkInterfacesListValue.getGroups()).isEmpty() || !instanceNetworkInterfaceSpecificationGroupsList.isAutoConstruct()) {
                    int groupsListIndex = 1;
                    for (Object instanceNetworkInterfaceSpecificationGroupsListValue : instanceNetworkInterfaceSpecificationGroupsList) {
                        if (instanceNetworkInterfaceSpecificationGroupsListValue != null) {
                            request.addParameter("NetworkInterface." + networkInterfacesListIndex + ".SecurityGroupId." + groupsListIndex, StringUtils.fromString((String)instanceNetworkInterfaceSpecificationGroupsListValue));
                        }
                        ++groupsListIndex;
                    }
                }
                if (runInstancesRequestNetworkInterfacesListValue.getIpv6AddressCount() != null) {
                    request.addParameter("NetworkInterface." + networkInterfacesListIndex + ".Ipv6AddressCount", StringUtils.fromInteger((Integer)runInstancesRequestNetworkInterfacesListValue.getIpv6AddressCount()));
                }
                if (!(instanceNetworkInterfaceSpecificationIpv6AddressesList = (SdkInternalList)runInstancesRequestNetworkInterfacesListValue.getIpv6Addresses()).isEmpty() || !instanceNetworkInterfaceSpecificationIpv6AddressesList.isAutoConstruct()) {
                    Object instanceNetworkInterfaceSpecificationGroupsListValue;
                    int ipv6AddressesListIndex = 1;
                    instanceNetworkInterfaceSpecificationGroupsListValue = instanceNetworkInterfaceSpecificationIpv6AddressesList.iterator();
                    while (instanceNetworkInterfaceSpecificationGroupsListValue.hasNext()) {
                        InstanceIpv6Address instanceNetworkInterfaceSpecificationIpv6AddressesListValue = (InstanceIpv6Address)instanceNetworkInterfaceSpecificationGroupsListValue.next();
                        if (instanceNetworkInterfaceSpecificationIpv6AddressesListValue.getIpv6Address() != null) {
                            request.addParameter("NetworkInterface." + networkInterfacesListIndex + ".Ipv6Addresses." + ipv6AddressesListIndex + ".Ipv6Address", StringUtils.fromString((String)instanceNetworkInterfaceSpecificationIpv6AddressesListValue.getIpv6Address()));
                        }
                        ++ipv6AddressesListIndex;
                    }
                }
                if (runInstancesRequestNetworkInterfacesListValue.getNetworkInterfaceId() != null) {
                    request.addParameter("NetworkInterface." + networkInterfacesListIndex + ".NetworkInterfaceId", StringUtils.fromString((String)runInstancesRequestNetworkInterfacesListValue.getNetworkInterfaceId()));
                }
                if (runInstancesRequestNetworkInterfacesListValue.getPrivateIpAddress() != null) {
                    request.addParameter("NetworkInterface." + networkInterfacesListIndex + ".PrivateIpAddress", StringUtils.fromString((String)runInstancesRequestNetworkInterfacesListValue.getPrivateIpAddress()));
                }
                if (!(instanceNetworkInterfaceSpecificationPrivateIpAddressesList = (SdkInternalList)runInstancesRequestNetworkInterfacesListValue.getPrivateIpAddresses()).isEmpty() || !instanceNetworkInterfaceSpecificationPrivateIpAddressesList.isAutoConstruct()) {
                    int privateIpAddressesListIndex = 1;
                    for (PrivateIpAddressSpecification instanceNetworkInterfaceSpecificationPrivateIpAddressesListValue : instanceNetworkInterfaceSpecificationPrivateIpAddressesList) {
                        if (instanceNetworkInterfaceSpecificationPrivateIpAddressesListValue.getPrimary() != null) {
                            request.addParameter("NetworkInterface." + networkInterfacesListIndex + ".PrivateIpAddresses." + privateIpAddressesListIndex + ".Primary", StringUtils.fromBoolean((Boolean)instanceNetworkInterfaceSpecificationPrivateIpAddressesListValue.getPrimary()));
                        }
                        if (instanceNetworkInterfaceSpecificationPrivateIpAddressesListValue.getPrivateIpAddress() != null) {
                            request.addParameter("NetworkInterface." + networkInterfacesListIndex + ".PrivateIpAddresses." + privateIpAddressesListIndex + ".PrivateIpAddress", StringUtils.fromString((String)instanceNetworkInterfaceSpecificationPrivateIpAddressesListValue.getPrivateIpAddress()));
                        }
                        ++privateIpAddressesListIndex;
                    }
                }
                if (runInstancesRequestNetworkInterfacesListValue.getSecondaryPrivateIpAddressCount() != null) {
                    request.addParameter("NetworkInterface." + networkInterfacesListIndex + ".SecondaryPrivateIpAddressCount", StringUtils.fromInteger((Integer)runInstancesRequestNetworkInterfacesListValue.getSecondaryPrivateIpAddressCount()));
                }
                if (runInstancesRequestNetworkInterfacesListValue.getSubnetId() != null) {
                    request.addParameter("NetworkInterface." + networkInterfacesListIndex + ".SubnetId", StringUtils.fromString((String)runInstancesRequestNetworkInterfacesListValue.getSubnetId()));
                }
                ++networkInterfacesListIndex;
            }
        }
        if (runInstancesRequest.getPrivateIpAddress() != null) {
            request.addParameter("PrivateIpAddress", StringUtils.fromString((String)runInstancesRequest.getPrivateIpAddress()));
        }
        if (!(runInstancesRequestTagSpecificationsList = (SdkInternalList)runInstancesRequest.getTagSpecifications()).isEmpty() || !runInstancesRequestTagSpecificationsList.isAutoConstruct()) {
            int tagSpecificationsListIndex = 1;
            for (TagSpecification runInstancesRequestTagSpecificationsListValue : runInstancesRequestTagSpecificationsList) {
                SdkInternalList tagSpecificationTagsList;
                if (runInstancesRequestTagSpecificationsListValue.getResourceType() != null) {
                    request.addParameter("TagSpecification." + tagSpecificationsListIndex + ".ResourceType", StringUtils.fromString((String)runInstancesRequestTagSpecificationsListValue.getResourceType()));
                }
                if (!(tagSpecificationTagsList = (SdkInternalList)runInstancesRequestTagSpecificationsListValue.getTags()).isEmpty() || !tagSpecificationTagsList.isAutoConstruct()) {
                    int tagsListIndex = 1;
                    for (Tag tagSpecificationTagsListValue : tagSpecificationTagsList) {
                        if (tagSpecificationTagsListValue.getKey() != null) {
                            request.addParameter("TagSpecification." + tagSpecificationsListIndex + ".Tag." + tagsListIndex + ".Key", StringUtils.fromString((String)tagSpecificationTagsListValue.getKey()));
                        }
                        if (tagSpecificationTagsListValue.getValue() != null) {
                            request.addParameter("TagSpecification." + tagSpecificationsListIndex + ".Tag." + tagsListIndex + ".Value", StringUtils.fromString((String)tagSpecificationTagsListValue.getValue()));
                        }
                        ++tagsListIndex;
                    }
                }
                ++tagSpecificationsListIndex;
            }
        }
        return request;
    }
}

