/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.deadline.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.deadline.model.WorkerAmountCapability;
import com.amazonaws.services.deadline.model.WorkerAttributeCapability;
import com.amazonaws.services.deadline.model.transform.WorkerCapabilitiesMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class WorkerCapabilities
implements Serializable,
Cloneable,
StructuredPojo {
    private List<WorkerAmountCapability> amounts;
    private List<WorkerAttributeCapability> attributes;

    public List<WorkerAmountCapability> getAmounts() {
        return this.amounts;
    }

    public void setAmounts(Collection<WorkerAmountCapability> amounts) {
        if (amounts == null) {
            this.amounts = null;
            return;
        }
        this.amounts = new ArrayList<WorkerAmountCapability>(amounts);
    }

    public WorkerCapabilities withAmounts(WorkerAmountCapability ... amounts) {
        if (this.amounts == null) {
            this.setAmounts(new ArrayList<WorkerAmountCapability>(amounts.length));
        }
        for (WorkerAmountCapability ele : amounts) {
            this.amounts.add(ele);
        }
        return this;
    }

    public WorkerCapabilities withAmounts(Collection<WorkerAmountCapability> amounts) {
        this.setAmounts(amounts);
        return this;
    }

    public List<WorkerAttributeCapability> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Collection<WorkerAttributeCapability> attributes) {
        if (attributes == null) {
            this.attributes = null;
            return;
        }
        this.attributes = new ArrayList<WorkerAttributeCapability>(attributes);
    }

    public WorkerCapabilities withAttributes(WorkerAttributeCapability ... attributes) {
        if (this.attributes == null) {
            this.setAttributes(new ArrayList<WorkerAttributeCapability>(attributes.length));
        }
        for (WorkerAttributeCapability ele : attributes) {
            this.attributes.add(ele);
        }
        return this;
    }

    public WorkerCapabilities withAttributes(Collection<WorkerAttributeCapability> attributes) {
        this.setAttributes(attributes);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAmounts() != null) {
            sb.append("Amounts: ").append(this.getAmounts()).append(",");
        }
        if (this.getAttributes() != null) {
            sb.append("Attributes: ").append(this.getAttributes());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WorkerCapabilities)) {
            return false;
        }
        WorkerCapabilities other = (WorkerCapabilities)obj;
        if (other.getAmounts() == null ^ this.getAmounts() == null) {
            return false;
        }
        if (other.getAmounts() != null && !other.getAmounts().equals(this.getAmounts())) {
            return false;
        }
        if (other.getAttributes() == null ^ this.getAttributes() == null) {
            return false;
        }
        return other.getAttributes() == null || other.getAttributes().equals(this.getAttributes());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAmounts() == null ? 0 : this.getAmounts().hashCode());
        hashCode = 31 * hashCode + (this.getAttributes() == null ? 0 : this.getAttributes().hashCode());
        return hashCode;
    }

    public WorkerCapabilities clone() {
        try {
            return (WorkerCapabilities)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        WorkerCapabilitiesMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

