/*
 * Copyright 2020-2025 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.computeoptimizer.model;

import java.io.Serializable;
import javax.annotation.Generated;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.protocol.ProtocolMarshaller;

/**
 * <p>
 * Describes a projected utilization metric of a recommendation option, such as an Amazon EC2 instance. This represents
 * the projected utilization of a recommendation option had you used that resource during the analyzed period.
 * </p>
 * <p>
 * Compare the utilization metric data of your resource against its projected utilization metric data to determine the
 * performance difference between your current resource and the recommended option.
 * </p>
 * <note>
 * <p>
 * The <code>Cpu</code>, <code>Memory</code>, <code>GPU</code>, and <code>GPU_MEMORY</code> metrics are the only
 * projected utilization metrics returned when you run the <a>GetEC2RecommendationProjectedMetrics</a> action.
 * Additionally, these metrics are only returned for resources with the unified CloudWatch agent installed on them. For
 * more information, see <a
 * href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/metrics.html#cw-agent">Enabling Memory Utilization with
 * the CloudWatch Agent</a> and <a
 * href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/metrics.html#nvidia-cw-agent">Enabling NVIDIA GPU
 * utilization with the CloudWatch Agent</a>.
 * </p>
 * </note>
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/compute-optimizer-2019-11-01/ProjectedMetric" target="_top">AWS
 *      API Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class ProjectedMetric implements Serializable, Cloneable, StructuredPojo {

    /**
     * <p>
     * The name of the projected utilization metric.
     * </p>
     * <p>
     * The following projected utilization metrics are returned:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Cpu</code> - The projected percentage of allocated EC2 compute units that would be in use on the
     * recommendation option had you used that resource during the analyzed period. This metric identifies the
     * processing power required to run an application on the recommendation option.
     * </p>
     * <p>
     * Depending on the instance type, tools in your operating system can show a lower percentage than CloudWatch when
     * the instance is not allocated a full processor core.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Memory</code> - The percentage of memory that would be in use on the recommendation option had you used
     * that resource during the analyzed period. This metric identifies the amount of memory required to run an
     * application on the recommendation option.
     * </p>
     * <p>
     * Units: Percent
     * </p>
     * <note>
     * <p>
     * The <code>Memory</code> metric is only returned for resources with the unified CloudWatch agent installed on
     * them. For more information, see <a
     * href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/metrics.html#cw-agent">Enabling Memory Utilization
     * with the CloudWatch Agent</a>.
     * </p>
     * </note></li>
     * <li>
     * <p>
     * <code>GPU</code> - The projected percentage of allocated GPUs if you adjust your configurations to Compute
     * Optimizer's recommendation option.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>GPU_MEMORY</code> - The projected percentage of total GPU memory if you adjust your configurations to
     * Compute Optimizer's recommendation option.
     * </p>
     * <note>
     * <p>
     * The <code>GPU</code> and <code>GPU_MEMORY</code> metrics are only returned for resources with the unified
     * CloudWatch Agent installed on them. For more information, see <a
     * href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/metrics.html#nvidia-cw-agent">Enabling NVIDIA GPU
     * utilization with the CloudWatch Agent</a>.
     * </p>
     * </note></li>
     * </ul>
     */
    private String name;
    /**
     * <p>
     * The timestamps of the projected utilization metric.
     * </p>
     */
    private java.util.List<java.util.Date> timestamps;
    /**
     * <p>
     * The values of the projected utilization metrics.
     * </p>
     */
    private java.util.List<Double> values;

    /**
     * <p>
     * The name of the projected utilization metric.
     * </p>
     * <p>
     * The following projected utilization metrics are returned:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Cpu</code> - The projected percentage of allocated EC2 compute units that would be in use on the
     * recommendation option had you used that resource during the analyzed period. This metric identifies the
     * processing power required to run an application on the recommendation option.
     * </p>
     * <p>
     * Depending on the instance type, tools in your operating system can show a lower percentage than CloudWatch when
     * the instance is not allocated a full processor core.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Memory</code> - The percentage of memory that would be in use on the recommendation option had you used
     * that resource during the analyzed period. This metric identifies the amount of memory required to run an
     * application on the recommendation option.
     * </p>
     * <p>
     * Units: Percent
     * </p>
     * <note>
     * <p>
     * The <code>Memory</code> metric is only returned for resources with the unified CloudWatch agent installed on
     * them. For more information, see <a
     * href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/metrics.html#cw-agent">Enabling Memory Utilization
     * with the CloudWatch Agent</a>.
     * </p>
     * </note></li>
     * <li>
     * <p>
     * <code>GPU</code> - The projected percentage of allocated GPUs if you adjust your configurations to Compute
     * Optimizer's recommendation option.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>GPU_MEMORY</code> - The projected percentage of total GPU memory if you adjust your configurations to
     * Compute Optimizer's recommendation option.
     * </p>
     * <note>
     * <p>
     * The <code>GPU</code> and <code>GPU_MEMORY</code> metrics are only returned for resources with the unified
     * CloudWatch Agent installed on them. For more information, see <a
     * href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/metrics.html#nvidia-cw-agent">Enabling NVIDIA GPU
     * utilization with the CloudWatch Agent</a>.
     * </p>
     * </note></li>
     * </ul>
     * 
     * @param name
     *        The name of the projected utilization metric.</p>
     *        <p>
     *        The following projected utilization metrics are returned:
     *        </p>
     *        <ul>
     *        <li>
     *        <p>
     *        <code>Cpu</code> - The projected percentage of allocated EC2 compute units that would be in use on the
     *        recommendation option had you used that resource during the analyzed period. This metric identifies the
     *        processing power required to run an application on the recommendation option.
     *        </p>
     *        <p>
     *        Depending on the instance type, tools in your operating system can show a lower percentage than CloudWatch
     *        when the instance is not allocated a full processor core.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>Memory</code> - The percentage of memory that would be in use on the recommendation option had you
     *        used that resource during the analyzed period. This metric identifies the amount of memory required to run
     *        an application on the recommendation option.
     *        </p>
     *        <p>
     *        Units: Percent
     *        </p>
     *        <note>
     *        <p>
     *        The <code>Memory</code> metric is only returned for resources with the unified CloudWatch agent installed
     *        on them. For more information, see <a
     *        href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/metrics.html#cw-agent">Enabling Memory
     *        Utilization with the CloudWatch Agent</a>.
     *        </p>
     *        </note></li>
     *        <li>
     *        <p>
     *        <code>GPU</code> - The projected percentage of allocated GPUs if you adjust your configurations to Compute
     *        Optimizer's recommendation option.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>GPU_MEMORY</code> - The projected percentage of total GPU memory if you adjust your configurations
     *        to Compute Optimizer's recommendation option.
     *        </p>
     *        <note>
     *        <p>
     *        The <code>GPU</code> and <code>GPU_MEMORY</code> metrics are only returned for resources with the unified
     *        CloudWatch Agent installed on them. For more information, see <a
     *        href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/metrics.html#nvidia-cw-agent">Enabling
     *        NVIDIA GPU utilization with the CloudWatch Agent</a>.
     *        </p>
     *        </note></li>
     * @see MetricName
     */

    public void setName(String name) {
        this.name = name;
    }

    /**
     * <p>
     * The name of the projected utilization metric.
     * </p>
     * <p>
     * The following projected utilization metrics are returned:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Cpu</code> - The projected percentage of allocated EC2 compute units that would be in use on the
     * recommendation option had you used that resource during the analyzed period. This metric identifies the
     * processing power required to run an application on the recommendation option.
     * </p>
     * <p>
     * Depending on the instance type, tools in your operating system can show a lower percentage than CloudWatch when
     * the instance is not allocated a full processor core.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Memory</code> - The percentage of memory that would be in use on the recommendation option had you used
     * that resource during the analyzed period. This metric identifies the amount of memory required to run an
     * application on the recommendation option.
     * </p>
     * <p>
     * Units: Percent
     * </p>
     * <note>
     * <p>
     * The <code>Memory</code> metric is only returned for resources with the unified CloudWatch agent installed on
     * them. For more information, see <a
     * href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/metrics.html#cw-agent">Enabling Memory Utilization
     * with the CloudWatch Agent</a>.
     * </p>
     * </note></li>
     * <li>
     * <p>
     * <code>GPU</code> - The projected percentage of allocated GPUs if you adjust your configurations to Compute
     * Optimizer's recommendation option.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>GPU_MEMORY</code> - The projected percentage of total GPU memory if you adjust your configurations to
     * Compute Optimizer's recommendation option.
     * </p>
     * <note>
     * <p>
     * The <code>GPU</code> and <code>GPU_MEMORY</code> metrics are only returned for resources with the unified
     * CloudWatch Agent installed on them. For more information, see <a
     * href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/metrics.html#nvidia-cw-agent">Enabling NVIDIA GPU
     * utilization with the CloudWatch Agent</a>.
     * </p>
     * </note></li>
     * </ul>
     * 
     * @return The name of the projected utilization metric.</p>
     *         <p>
     *         The following projected utilization metrics are returned:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>Cpu</code> - The projected percentage of allocated EC2 compute units that would be in use on the
     *         recommendation option had you used that resource during the analyzed period. This metric identifies the
     *         processing power required to run an application on the recommendation option.
     *         </p>
     *         <p>
     *         Depending on the instance type, tools in your operating system can show a lower percentage than
     *         CloudWatch when the instance is not allocated a full processor core.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Memory</code> - The percentage of memory that would be in use on the recommendation option had you
     *         used that resource during the analyzed period. This metric identifies the amount of memory required to
     *         run an application on the recommendation option.
     *         </p>
     *         <p>
     *         Units: Percent
     *         </p>
     *         <note>
     *         <p>
     *         The <code>Memory</code> metric is only returned for resources with the unified CloudWatch agent installed
     *         on them. For more information, see <a
     *         href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/metrics.html#cw-agent">Enabling Memory
     *         Utilization with the CloudWatch Agent</a>.
     *         </p>
     *         </note></li>
     *         <li>
     *         <p>
     *         <code>GPU</code> - The projected percentage of allocated GPUs if you adjust your configurations to
     *         Compute Optimizer's recommendation option.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>GPU_MEMORY</code> - The projected percentage of total GPU memory if you adjust your configurations
     *         to Compute Optimizer's recommendation option.
     *         </p>
     *         <note>
     *         <p>
     *         The <code>GPU</code> and <code>GPU_MEMORY</code> metrics are only returned for resources with the unified
     *         CloudWatch Agent installed on them. For more information, see <a
     *         href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/metrics.html#nvidia-cw-agent">Enabling
     *         NVIDIA GPU utilization with the CloudWatch Agent</a>.
     *         </p>
     *         </note></li>
     * @see MetricName
     */

    public String getName() {
        return this.name;
    }

    /**
     * <p>
     * The name of the projected utilization metric.
     * </p>
     * <p>
     * The following projected utilization metrics are returned:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Cpu</code> - The projected percentage of allocated EC2 compute units that would be in use on the
     * recommendation option had you used that resource during the analyzed period. This metric identifies the
     * processing power required to run an application on the recommendation option.
     * </p>
     * <p>
     * Depending on the instance type, tools in your operating system can show a lower percentage than CloudWatch when
     * the instance is not allocated a full processor core.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Memory</code> - The percentage of memory that would be in use on the recommendation option had you used
     * that resource during the analyzed period. This metric identifies the amount of memory required to run an
     * application on the recommendation option.
     * </p>
     * <p>
     * Units: Percent
     * </p>
     * <note>
     * <p>
     * The <code>Memory</code> metric is only returned for resources with the unified CloudWatch agent installed on
     * them. For more information, see <a
     * href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/metrics.html#cw-agent">Enabling Memory Utilization
     * with the CloudWatch Agent</a>.
     * </p>
     * </note></li>
     * <li>
     * <p>
     * <code>GPU</code> - The projected percentage of allocated GPUs if you adjust your configurations to Compute
     * Optimizer's recommendation option.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>GPU_MEMORY</code> - The projected percentage of total GPU memory if you adjust your configurations to
     * Compute Optimizer's recommendation option.
     * </p>
     * <note>
     * <p>
     * The <code>GPU</code> and <code>GPU_MEMORY</code> metrics are only returned for resources with the unified
     * CloudWatch Agent installed on them. For more information, see <a
     * href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/metrics.html#nvidia-cw-agent">Enabling NVIDIA GPU
     * utilization with the CloudWatch Agent</a>.
     * </p>
     * </note></li>
     * </ul>
     * 
     * @param name
     *        The name of the projected utilization metric.</p>
     *        <p>
     *        The following projected utilization metrics are returned:
     *        </p>
     *        <ul>
     *        <li>
     *        <p>
     *        <code>Cpu</code> - The projected percentage of allocated EC2 compute units that would be in use on the
     *        recommendation option had you used that resource during the analyzed period. This metric identifies the
     *        processing power required to run an application on the recommendation option.
     *        </p>
     *        <p>
     *        Depending on the instance type, tools in your operating system can show a lower percentage than CloudWatch
     *        when the instance is not allocated a full processor core.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>Memory</code> - The percentage of memory that would be in use on the recommendation option had you
     *        used that resource during the analyzed period. This metric identifies the amount of memory required to run
     *        an application on the recommendation option.
     *        </p>
     *        <p>
     *        Units: Percent
     *        </p>
     *        <note>
     *        <p>
     *        The <code>Memory</code> metric is only returned for resources with the unified CloudWatch agent installed
     *        on them. For more information, see <a
     *        href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/metrics.html#cw-agent">Enabling Memory
     *        Utilization with the CloudWatch Agent</a>.
     *        </p>
     *        </note></li>
     *        <li>
     *        <p>
     *        <code>GPU</code> - The projected percentage of allocated GPUs if you adjust your configurations to Compute
     *        Optimizer's recommendation option.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>GPU_MEMORY</code> - The projected percentage of total GPU memory if you adjust your configurations
     *        to Compute Optimizer's recommendation option.
     *        </p>
     *        <note>
     *        <p>
     *        The <code>GPU</code> and <code>GPU_MEMORY</code> metrics are only returned for resources with the unified
     *        CloudWatch Agent installed on them. For more information, see <a
     *        href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/metrics.html#nvidia-cw-agent">Enabling
     *        NVIDIA GPU utilization with the CloudWatch Agent</a>.
     *        </p>
     *        </note></li>
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see MetricName
     */

    public ProjectedMetric withName(String name) {
        setName(name);
        return this;
    }

    /**
     * <p>
     * The name of the projected utilization metric.
     * </p>
     * <p>
     * The following projected utilization metrics are returned:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Cpu</code> - The projected percentage of allocated EC2 compute units that would be in use on the
     * recommendation option had you used that resource during the analyzed period. This metric identifies the
     * processing power required to run an application on the recommendation option.
     * </p>
     * <p>
     * Depending on the instance type, tools in your operating system can show a lower percentage than CloudWatch when
     * the instance is not allocated a full processor core.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Memory</code> - The percentage of memory that would be in use on the recommendation option had you used
     * that resource during the analyzed period. This metric identifies the amount of memory required to run an
     * application on the recommendation option.
     * </p>
     * <p>
     * Units: Percent
     * </p>
     * <note>
     * <p>
     * The <code>Memory</code> metric is only returned for resources with the unified CloudWatch agent installed on
     * them. For more information, see <a
     * href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/metrics.html#cw-agent">Enabling Memory Utilization
     * with the CloudWatch Agent</a>.
     * </p>
     * </note></li>
     * <li>
     * <p>
     * <code>GPU</code> - The projected percentage of allocated GPUs if you adjust your configurations to Compute
     * Optimizer's recommendation option.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>GPU_MEMORY</code> - The projected percentage of total GPU memory if you adjust your configurations to
     * Compute Optimizer's recommendation option.
     * </p>
     * <note>
     * <p>
     * The <code>GPU</code> and <code>GPU_MEMORY</code> metrics are only returned for resources with the unified
     * CloudWatch Agent installed on them. For more information, see <a
     * href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/metrics.html#nvidia-cw-agent">Enabling NVIDIA GPU
     * utilization with the CloudWatch Agent</a>.
     * </p>
     * </note></li>
     * </ul>
     * 
     * @param name
     *        The name of the projected utilization metric.</p>
     *        <p>
     *        The following projected utilization metrics are returned:
     *        </p>
     *        <ul>
     *        <li>
     *        <p>
     *        <code>Cpu</code> - The projected percentage of allocated EC2 compute units that would be in use on the
     *        recommendation option had you used that resource during the analyzed period. This metric identifies the
     *        processing power required to run an application on the recommendation option.
     *        </p>
     *        <p>
     *        Depending on the instance type, tools in your operating system can show a lower percentage than CloudWatch
     *        when the instance is not allocated a full processor core.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>Memory</code> - The percentage of memory that would be in use on the recommendation option had you
     *        used that resource during the analyzed period. This metric identifies the amount of memory required to run
     *        an application on the recommendation option.
     *        </p>
     *        <p>
     *        Units: Percent
     *        </p>
     *        <note>
     *        <p>
     *        The <code>Memory</code> metric is only returned for resources with the unified CloudWatch agent installed
     *        on them. For more information, see <a
     *        href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/metrics.html#cw-agent">Enabling Memory
     *        Utilization with the CloudWatch Agent</a>.
     *        </p>
     *        </note></li>
     *        <li>
     *        <p>
     *        <code>GPU</code> - The projected percentage of allocated GPUs if you adjust your configurations to Compute
     *        Optimizer's recommendation option.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>GPU_MEMORY</code> - The projected percentage of total GPU memory if you adjust your configurations
     *        to Compute Optimizer's recommendation option.
     *        </p>
     *        <note>
     *        <p>
     *        The <code>GPU</code> and <code>GPU_MEMORY</code> metrics are only returned for resources with the unified
     *        CloudWatch Agent installed on them. For more information, see <a
     *        href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/metrics.html#nvidia-cw-agent">Enabling
     *        NVIDIA GPU utilization with the CloudWatch Agent</a>.
     *        </p>
     *        </note></li>
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see MetricName
     */

    public ProjectedMetric withName(MetricName name) {
        this.name = name.toString();
        return this;
    }

    /**
     * <p>
     * The timestamps of the projected utilization metric.
     * </p>
     * 
     * @return The timestamps of the projected utilization metric.
     */

    public java.util.List<java.util.Date> getTimestamps() {
        return timestamps;
    }

    /**
     * <p>
     * The timestamps of the projected utilization metric.
     * </p>
     * 
     * @param timestamps
     *        The timestamps of the projected utilization metric.
     */

    public void setTimestamps(java.util.Collection<java.util.Date> timestamps) {
        if (timestamps == null) {
            this.timestamps = null;
            return;
        }

        this.timestamps = new java.util.ArrayList<java.util.Date>(timestamps);
    }

    /**
     * <p>
     * The timestamps of the projected utilization metric.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setTimestamps(java.util.Collection)} or {@link #withTimestamps(java.util.Collection)} if you want to
     * override the existing values.
     * </p>
     * 
     * @param timestamps
     *        The timestamps of the projected utilization metric.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ProjectedMetric withTimestamps(java.util.Date... timestamps) {
        if (this.timestamps == null) {
            setTimestamps(new java.util.ArrayList<java.util.Date>(timestamps.length));
        }
        for (java.util.Date ele : timestamps) {
            this.timestamps.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * The timestamps of the projected utilization metric.
     * </p>
     * 
     * @param timestamps
     *        The timestamps of the projected utilization metric.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ProjectedMetric withTimestamps(java.util.Collection<java.util.Date> timestamps) {
        setTimestamps(timestamps);
        return this;
    }

    /**
     * <p>
     * The values of the projected utilization metrics.
     * </p>
     * 
     * @return The values of the projected utilization metrics.
     */

    public java.util.List<Double> getValues() {
        return values;
    }

    /**
     * <p>
     * The values of the projected utilization metrics.
     * </p>
     * 
     * @param values
     *        The values of the projected utilization metrics.
     */

    public void setValues(java.util.Collection<Double> values) {
        if (values == null) {
            this.values = null;
            return;
        }

        this.values = new java.util.ArrayList<Double>(values);
    }

    /**
     * <p>
     * The values of the projected utilization metrics.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setValues(java.util.Collection)} or {@link #withValues(java.util.Collection)} if you want to override the
     * existing values.
     * </p>
     * 
     * @param values
     *        The values of the projected utilization metrics.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ProjectedMetric withValues(Double... values) {
        if (this.values == null) {
            setValues(new java.util.ArrayList<Double>(values.length));
        }
        for (Double ele : values) {
            this.values.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * The values of the projected utilization metrics.
     * </p>
     * 
     * @param values
     *        The values of the projected utilization metrics.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ProjectedMetric withValues(java.util.Collection<Double> values) {
        setValues(values);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getName() != null)
            sb.append("Name: ").append(getName()).append(",");
        if (getTimestamps() != null)
            sb.append("Timestamps: ").append(getTimestamps()).append(",");
        if (getValues() != null)
            sb.append("Values: ").append(getValues());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof ProjectedMetric == false)
            return false;
        ProjectedMetric other = (ProjectedMetric) obj;
        if (other.getName() == null ^ this.getName() == null)
            return false;
        if (other.getName() != null && other.getName().equals(this.getName()) == false)
            return false;
        if (other.getTimestamps() == null ^ this.getTimestamps() == null)
            return false;
        if (other.getTimestamps() != null && other.getTimestamps().equals(this.getTimestamps()) == false)
            return false;
        if (other.getValues() == null ^ this.getValues() == null)
            return false;
        if (other.getValues() != null && other.getValues().equals(this.getValues()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getName() == null) ? 0 : getName().hashCode());
        hashCode = prime * hashCode + ((getTimestamps() == null) ? 0 : getTimestamps().hashCode());
        hashCode = prime * hashCode + ((getValues() == null) ? 0 : getValues().hashCode());
        return hashCode;
    }

    @Override
    public ProjectedMetric clone() {
        try {
            return (ProjectedMetric) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

    @com.amazonaws.annotation.SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        com.amazonaws.services.computeoptimizer.model.transform.ProjectedMetricMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}
