/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codestarconnections.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.codestarconnections.model.ProviderType;
import com.amazonaws.services.codestarconnections.model.Tag;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CreateConnectionRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String providerType;
    private String connectionName;
    private List<Tag> tags;
    private String hostArn;

    public void setProviderType(String providerType) {
        this.providerType = providerType;
    }

    public String getProviderType() {
        return this.providerType;
    }

    public CreateConnectionRequest withProviderType(String providerType) {
        this.setProviderType(providerType);
        return this;
    }

    public CreateConnectionRequest withProviderType(ProviderType providerType) {
        this.providerType = providerType.toString();
        return this;
    }

    public void setConnectionName(String connectionName) {
        this.connectionName = connectionName;
    }

    public String getConnectionName() {
        return this.connectionName;
    }

    public CreateConnectionRequest withConnectionName(String connectionName) {
        this.setConnectionName(connectionName);
        return this;
    }

    public List<Tag> getTags() {
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        this.tags = new ArrayList<Tag>(tags);
    }

    public CreateConnectionRequest withTags(Tag ... tags) {
        if (this.tags == null) {
            this.setTags(new ArrayList<Tag>(tags.length));
        }
        for (Tag ele : tags) {
            this.tags.add(ele);
        }
        return this;
    }

    public CreateConnectionRequest withTags(Collection<Tag> tags) {
        this.setTags(tags);
        return this;
    }

    public void setHostArn(String hostArn) {
        this.hostArn = hostArn;
    }

    public String getHostArn() {
        return this.hostArn;
    }

    public CreateConnectionRequest withHostArn(String hostArn) {
        this.setHostArn(hostArn);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getProviderType() != null) {
            sb.append("ProviderType: ").append(this.getProviderType()).append(",");
        }
        if (this.getConnectionName() != null) {
            sb.append("ConnectionName: ").append(this.getConnectionName()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags()).append(",");
        }
        if (this.getHostArn() != null) {
            sb.append("HostArn: ").append(this.getHostArn());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateConnectionRequest)) {
            return false;
        }
        CreateConnectionRequest other = (CreateConnectionRequest)obj;
        if (other.getProviderType() == null ^ this.getProviderType() == null) {
            return false;
        }
        if (other.getProviderType() != null && !other.getProviderType().equals(this.getProviderType())) {
            return false;
        }
        if (other.getConnectionName() == null ^ this.getConnectionName() == null) {
            return false;
        }
        if (other.getConnectionName() != null && !other.getConnectionName().equals(this.getConnectionName())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        if (other.getTags() != null && !other.getTags().equals(this.getTags())) {
            return false;
        }
        if (other.getHostArn() == null ^ this.getHostArn() == null) {
            return false;
        }
        return other.getHostArn() == null || other.getHostArn().equals(this.getHostArn());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getProviderType() == null ? 0 : this.getProviderType().hashCode());
        hashCode = 31 * hashCode + (this.getConnectionName() == null ? 0 : this.getConnectionName().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        hashCode = 31 * hashCode + (this.getHostArn() == null ? 0 : this.getHostArn().hashCode());
        return hashCode;
    }

    public CreateConnectionRequest clone() {
        return (CreateConnectionRequest)super.clone();
    }
}

