/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.budgets.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.budgets.model.DeleteNotificationRequest;
import com.amazonaws.services.budgets.model.transform.NotificationJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class DeleteNotificationRequestMarshaller
implements Marshaller<Request<DeleteNotificationRequest>, DeleteNotificationRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public DeleteNotificationRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<DeleteNotificationRequest> marshall(DeleteNotificationRequest deleteNotificationRequest) {
        if (deleteNotificationRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)deleteNotificationRequest, "AWSBudgets");
        request.addHeader("X-Amz-Target", "AWSBudgetServiceGateway.DeleteNotification");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (deleteNotificationRequest.getAccountId() != null) {
                jsonGenerator.writeFieldName("AccountId").writeValue(deleteNotificationRequest.getAccountId());
            }
            if (deleteNotificationRequest.getBudgetName() != null) {
                jsonGenerator.writeFieldName("BudgetName").writeValue(deleteNotificationRequest.getBudgetName());
            }
            if (deleteNotificationRequest.getNotification() != null) {
                jsonGenerator.writeFieldName("Notification");
                NotificationJsonMarshaller.getInstance().marshall(deleteNotificationRequest.getNotification(), jsonGenerator);
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

