/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.bedrockagentruntime;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.bedrockagentruntime.AWSBedrockAgentRuntimeAsync;
import com.amazonaws.services.bedrockagentruntime.AWSBedrockAgentRuntimeAsyncClientBuilder;
import com.amazonaws.services.bedrockagentruntime.AWSBedrockAgentRuntimeClient;
import com.amazonaws.services.bedrockagentruntime.model.DeleteAgentMemoryRequest;
import com.amazonaws.services.bedrockagentruntime.model.DeleteAgentMemoryResult;
import com.amazonaws.services.bedrockagentruntime.model.GetAgentMemoryRequest;
import com.amazonaws.services.bedrockagentruntime.model.GetAgentMemoryResult;
import com.amazonaws.services.bedrockagentruntime.model.RetrieveAndGenerateRequest;
import com.amazonaws.services.bedrockagentruntime.model.RetrieveAndGenerateResult;
import com.amazonaws.services.bedrockagentruntime.model.RetrieveRequest;
import com.amazonaws.services.bedrockagentruntime.model.RetrieveResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

@ThreadSafe
public class AWSBedrockAgentRuntimeAsyncClient
extends AWSBedrockAgentRuntimeClient
implements AWSBedrockAgentRuntimeAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public static AWSBedrockAgentRuntimeAsyncClientBuilder asyncBuilder() {
        return AWSBedrockAgentRuntimeAsyncClientBuilder.standard();
    }

    AWSBedrockAgentRuntimeAsyncClient(AwsAsyncClientParams asyncClientParams) {
        this(asyncClientParams, false);
    }

    AWSBedrockAgentRuntimeAsyncClient(AwsAsyncClientParams asyncClientParams, boolean endpointDiscoveryEnabled) {
        super((AwsSyncClientParams)asyncClientParams, endpointDiscoveryEnabled);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<DeleteAgentMemoryResult> deleteAgentMemoryAsync(DeleteAgentMemoryRequest request) {
        return this.deleteAgentMemoryAsync(request, null);
    }

    @Override
    public Future<DeleteAgentMemoryResult> deleteAgentMemoryAsync(DeleteAgentMemoryRequest request, final AsyncHandler<DeleteAgentMemoryRequest, DeleteAgentMemoryResult> asyncHandler) {
        final DeleteAgentMemoryRequest finalRequest = (DeleteAgentMemoryRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteAgentMemoryResult>(){

            @Override
            public DeleteAgentMemoryResult call() throws Exception {
                DeleteAgentMemoryResult result = null;
                try {
                    result = AWSBedrockAgentRuntimeAsyncClient.this.executeDeleteAgentMemory(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetAgentMemoryResult> getAgentMemoryAsync(GetAgentMemoryRequest request) {
        return this.getAgentMemoryAsync(request, null);
    }

    @Override
    public Future<GetAgentMemoryResult> getAgentMemoryAsync(GetAgentMemoryRequest request, final AsyncHandler<GetAgentMemoryRequest, GetAgentMemoryResult> asyncHandler) {
        final GetAgentMemoryRequest finalRequest = (GetAgentMemoryRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetAgentMemoryResult>(){

            @Override
            public GetAgentMemoryResult call() throws Exception {
                GetAgentMemoryResult result = null;
                try {
                    result = AWSBedrockAgentRuntimeAsyncClient.this.executeGetAgentMemory(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<RetrieveResult> retrieveAsync(RetrieveRequest request) {
        return this.retrieveAsync(request, null);
    }

    @Override
    public Future<RetrieveResult> retrieveAsync(RetrieveRequest request, final AsyncHandler<RetrieveRequest, RetrieveResult> asyncHandler) {
        final RetrieveRequest finalRequest = (RetrieveRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<RetrieveResult>(){

            @Override
            public RetrieveResult call() throws Exception {
                RetrieveResult result = null;
                try {
                    result = AWSBedrockAgentRuntimeAsyncClient.this.executeRetrieve(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<RetrieveAndGenerateResult> retrieveAndGenerateAsync(RetrieveAndGenerateRequest request) {
        return this.retrieveAndGenerateAsync(request, null);
    }

    @Override
    public Future<RetrieveAndGenerateResult> retrieveAndGenerateAsync(RetrieveAndGenerateRequest request, final AsyncHandler<RetrieveAndGenerateRequest, RetrieveAndGenerateResult> asyncHandler) {
        final RetrieveAndGenerateRequest finalRequest = (RetrieveAndGenerateRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<RetrieveAndGenerateResult>(){

            @Override
            public RetrieveAndGenerateResult call() throws Exception {
                RetrieveAndGenerateResult result = null;
                try {
                    result = AWSBedrockAgentRuntimeAsyncClient.this.executeRetrieveAndGenerate(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

