/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.scheduler.registry.etcd.configuration;

import cn.ponfee.scheduler.core.base.Supervisor;
import cn.ponfee.scheduler.core.base.Worker;
import cn.ponfee.scheduler.registry.SupervisorRegistry;
import cn.ponfee.scheduler.registry.WorkerRegistry;
import cn.ponfee.scheduler.registry.etcd.EtcdServerRegistry;
import cn.ponfee.scheduler.registry.etcd.EtcdSupervisorRegistry;
import cn.ponfee.scheduler.registry.etcd.EtcdWorkerRegistry;
import cn.ponfee.scheduler.registry.etcd.configuration.EtcdProperties;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.AutoConfigureOrder;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;

@Configuration(proxyBeanMethods=false)
@ConditionalOnClass(value={EtcdServerRegistry.class})
public class EtcdServerRegistryConfigure {

    @Configuration(proxyBeanMethods=false)
    @AutoConfigureOrder(value=0x7FFFFFFF)
    @DependsOn(value={"currentSupervisor"})
    @ConditionalOnBean(value={Worker.class})
    public static class EtcdWorkerRegistryConfiguration {
        @Bean
        @ConditionalOnMissingBean
        public WorkerRegistry workerRegistry(@Value(value="${distributed.scheduler.namespace:}") String namespace, EtcdProperties properties) {
            return new EtcdWorkerRegistry(namespace, properties);
        }
    }

    @Configuration(proxyBeanMethods=false)
    @AutoConfigureOrder(value=0x7FFFFFFF)
    @DependsOn(value={"currentWorker"})
    @ConditionalOnBean(value={Supervisor.class})
    public static class EtcdSupervisorRegistryConfiguration {
        @Bean
        @ConditionalOnMissingBean
        public SupervisorRegistry supervisorRegistry(@Value(value="${distributed.scheduler.namespace:}") String namespace, EtcdProperties properties) {
            return new EtcdSupervisorRegistry(namespace, properties);
        }
    }
}

