/*
 * Decompiled with CFR 0.152.
 */
package umontreal.ssj.latnetbuilder.weights;

import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import umontreal.ssj.latnetbuilder.weights.OrderDependentWeights;
import umontreal.ssj.latnetbuilder.weights.SingletonWeight;
import umontreal.ssj.latnetbuilder.weights.SingletonWeightComparable;
import umontreal.ssj.latnetbuilder.weights.Weights;
import umontreal.ssj.mcqmctools.anova.CoordinateSet;

public class ProjectionDependentWeights
extends Weights<CoordinateSet> {
    public OrderDependentWeights orderDependentWeights;
    protected String fileDir = "";
    protected String fileName = "";

    public void setFileDir(String dir) {
        this.fileDir = dir;
    }

    public String getFileDir() {
        return this.fileDir;
    }

    public void setFileName(String name) {
        this.fileName = name;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void addOrderDependentWeight() {
        this.orderDependentWeights = new OrderDependentWeights();
    }

    public void addOrderDependentWeight(SingletonWeightComparable<Integer> weight) {
        this.orderDependentWeights.add(weight);
    }

    public void addOrderDependentWeight(int order, double weight) {
        this.orderDependentWeights.add(order, weight);
    }

    public void setOrderDependentWeights(ArrayList<SingletonWeightComparable<Integer>> ordWeights) {
        this.orderDependentWeights = new OrderDependentWeights(ordWeights);
    }

    public void write() throws IOException {
        FileWriter file = new FileWriter(this.fileDir + this.fileName);
        StringBuffer sb = new StringBuffer("");
        for (SingletonWeight singletonWeight : this.weights) {
            sb.append(((CoordinateSet)singletonWeight.getIndex()).toStringNoBraces() + ":\t" + singletonWeight.getWeight() + "\n");
        }
        for (SingletonWeightComparable singletonWeightComparable : this.orderDependentWeights.getComparableWeights()) {
            sb.append("order " + singletonWeightComparable.getIndex() + ":\t" + singletonWeightComparable.getWeight() + "\n");
        }
        sb.append("default:\t" + this.defaultWeight);
        file.write(sb.toString());
        file.close();
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer("");
        sb.append("Order dependent weights [default = " + this.getDefaultWeight() + "]\n");
        for (SingletonWeight singletonWeight : this.weights) {
            sb.append(String.format("%20s: %1.8g%n", ((CoordinateSet)singletonWeight.getIndex()).toString(), singletonWeight.getWeight()));
        }
        for (SingletonWeightComparable singletonWeightComparable : this.orderDependentWeights.getComparableWeights()) {
            sb.append(String.format("%20s: %1.8g%n", "order " + singletonWeightComparable.getIndex(), singletonWeightComparable.getWeight()));
        }
        return sb.toString();
    }

    @Override
    public String toLatNetBuilder() {
        String str = "file:" + this.fileDir + this.fileName;
        return str;
    }
}

