/*
 * Decompiled with CFR 0.152.
 */
package umontreal.ssj.randvar;

import umontreal.ssj.probdist.ChiSquareNoncentralDist;
import umontreal.ssj.randvar.RandomVariateGen;
import umontreal.ssj.rng.RandomStream;

public class ChiSquareNoncentralGen
extends RandomVariateGen {
    protected double nu = -1.0;
    protected double lambda = -1.0;

    public ChiSquareNoncentralGen(RandomStream s, double nu, double lambda) {
        super(s, new ChiSquareNoncentralDist(nu, lambda));
        this.setParams(nu, lambda);
    }

    public ChiSquareNoncentralGen(RandomStream s, ChiSquareNoncentralDist dist) {
        super(s, dist);
        if (dist != null) {
            this.setParams(dist.getNu(), dist.getLambda());
        }
    }

    public static double nextDouble(RandomStream s, double nu, double lambda) {
        return ChiSquareNoncentralDist.inverseF(nu, lambda, s.nextDouble());
    }

    public double getNu() {
        return this.nu;
    }

    public double getLambda() {
        return this.lambda;
    }

    protected void setParams(double nu, double lambda) {
        if (nu <= 0.0) {
            throw new IllegalArgumentException("nu <= 0");
        }
        if (lambda < 0.0) {
            throw new IllegalArgumentException("lambda < 0");
        }
        this.nu = nu;
        this.lambda = lambda;
    }
}

