/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.validation.app;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.app.Application;
import ca.uhn.hl7v2.app.DefaultApplication;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.model.Segment;
import ca.uhn.hl7v2.parser.PipeParser;
import ca.uhn.hl7v2.util.Terser;
import java.io.IOException;
import org.apache.commons.logging.LogFactory;
import org.apache.log4j.NDC;

public abstract class TestApplication
implements Application {
    private PipeParser parser = new PipeParser();

    public abstract boolean canProcess(Message var1);

    public Message processMessage(Message in) throws HL7Exception {
        String context = null;
        try {
            context = this.parser.encode(in);
        }
        catch (HL7Exception e) {
            context = "message not encodable";
        }
        NDC.push((String)context);
        LogFactory.getLog((String)"ca.uhn.hl7v2.validation.error").info((Object)"Testing message");
        HL7Exception[] problems = this.test(in);
        this.sendNotifications(problems);
        NDC.pop();
        Message ack = null;
        try {
            ack = DefaultApplication.makeACK((Segment)in.get("MSH"));
            this.addProblemsToACK(ack, problems);
        }
        catch (IOException e) {
            throw new HL7Exception(e);
        }
        return ack;
    }

    private void sendNotifications(HL7Exception[] problems) {
        for (int i = 0; i < problems.length; ++i) {
            String exName = problems[i].getClass().getName();
            String logName = "ca.uhn.hl7v2.validation.error" + exName.substring(exName.lastIndexOf(46));
            LogFactory.getLog((String)logName).error((Object)"message validation failure", (Throwable)problems[i]);
        }
    }

    private void addProblemsToACK(Message ack, HL7Exception[] problems) throws HL7Exception {
        Terser t = new Terser(ack);
        if (problems.length > 0) {
            t.set("MSA-1", "AE");
            t.set("MSA-3", "Errors were encountered while testing the message");
        }
        Segment err = (Segment)ack.get("ERR");
        for (int i = 0; i < problems.length; ++i) {
        }
    }

    public abstract HL7Exception[] test(Message var1) throws HL7Exception;
}

