/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.app;

import ca.uhn.hl7v2.app.Connection;
import ca.uhn.hl7v2.app.HL7Service;
import ca.uhn.hl7v2.llp.LowerLayerProtocol;
import ca.uhn.hl7v2.parser.Parser;
import ca.uhn.hl7v2.parser.PipeParser;
import ca.uhn.log.HapiLog;
import ca.uhn.log.HapiLogFactory;
import java.io.File;
import java.io.InterruptedIOException;
import java.net.ServerSocket;
import java.net.Socket;

public class SimpleServer
extends HL7Service {
    public static final int SO_TIMEOUT = 3000;
    private static final HapiLog log = HapiLogFactory.getHapiLog(SimpleServer.class);
    private int port;

    public SimpleServer(int port, LowerLayerProtocol llp, Parser parser) {
        super(parser, llp);
        this.port = port;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            ServerSocket ss = new ServerSocket(this.port);
            ss.setSoTimeout(3000);
            log.info("SimpleServer running on port " + ss.getLocalPort());
            while (this.keepRunning()) {
                try {
                    Socket newSocket = ss.accept();
                    log.info("Accepted connection from " + newSocket.getInetAddress().getHostAddress());
                    Connection conn = new Connection(this.parser, this.llp, newSocket);
                    this.newConnection(conn);
                }
                catch (InterruptedIOException ie) {
                }
                catch (Exception e) {
                    log.error("Error while accepting connections: ", e);
                }
            }
            ss.close();
        }
        catch (Exception e) {
            log.error(e);
        }
        finally {
            this.stop();
        }
    }

    public static void main(String[] args) {
        if (args.length < 1 || args.length > 2) {
            System.out.println("Usage: ca.uhn.hl7v2.app.SimpleServer port_num [application_spec_file_name]");
            System.exit(1);
        }
        int port = 0;
        try {
            port = Integer.parseInt(args[0]);
        }
        catch (NumberFormatException e) {
            System.err.println("The given port (" + args[0] + ") is not an integer.");
            System.exit(1);
        }
        File appFile = null;
        if (args.length == 2) {
            appFile = new File(args[1]);
        }
        try {
            SimpleServer server = new SimpleServer(port, LowerLayerProtocol.makeLLP(), new PipeParser());
            if (appFile != null) {
                server.loadApplicationsFromFile(appFile);
            }
            server.start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

