/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.app;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.app.Application;
import ca.uhn.hl7v2.app.ApplicationExceptionHandler;
import ca.uhn.hl7v2.app.DefaultApplication;
import ca.uhn.hl7v2.llp.HL7Reader;
import ca.uhn.hl7v2.llp.HL7Writer;
import ca.uhn.hl7v2.llp.LLPException;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.model.Segment;
import ca.uhn.hl7v2.parser.Parser;
import ca.uhn.hl7v2.parser.PipeParser;
import ca.uhn.hl7v2.util.Home;
import ca.uhn.hl7v2.util.MessageIDGenerator;
import ca.uhn.hl7v2.util.Terser;
import ca.uhn.log.HapiLog;
import ca.uhn.log.HapiLogFactory;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class Responder {
    private static final HapiLog log = HapiLogFactory.getHapiLog(Responder.class);
    private Parser parser;
    private ArrayList apps;
    private HL7Reader in;
    private HL7Writer out;
    private BufferedWriter checkWriter = null;

    public Responder(Parser parser) throws LLPException {
        String checkParse = System.getProperty("ca.uhn.hl7v2.app.checkparse");
        if (checkParse != null && checkParse.equals("true")) {
            this.init(parser, true);
        } else {
            this.init(parser, false);
        }
    }

    public Responder(Parser parser, boolean checkParse) {
        this.init(parser, checkParse);
    }

    private void init(Parser parser, boolean checkParse) {
        this.parser = parser;
        this.apps = new ArrayList(10);
        try {
            if (checkParse) {
                this.checkWriter = new BufferedWriter(new FileWriter(Home.getHomeDirectory().getAbsolutePath() + "/parse_check.txt", true));
            }
        }
        catch (IOException e) {
            log.error("Unable to open file to write parse check results.  Parse integrity checks will not proceed", e);
        }
    }

    protected String processMessage(String incomingMessageString) throws HL7Exception {
        HapiLog rawOutbound = HapiLogFactory.getHapiLog("ca.uhn.hl7v2.raw.outbound");
        HapiLog rawInbound = HapiLogFactory.getHapiLog("ca.uhn.hl7v2.raw.inbound");
        log.info("Responder got message: " + incomingMessageString);
        rawInbound.info(incomingMessageString);
        Message incomingMessageObject = null;
        String outgoingMessageString = null;
        try {
            incomingMessageObject = this.parser.parse(incomingMessageString);
        }
        catch (HL7Exception e) {
            outgoingMessageString = Responder.logAndMakeErrorMessage(e, this.parser.getCriticalResponseData(incomingMessageString), this.parser, this.parser.getEncoding(incomingMessageString));
            for (Object app : this.apps) {
                if (!(app instanceof ApplicationExceptionHandler)) continue;
                ApplicationExceptionHandler aeh = (ApplicationExceptionHandler)app;
                outgoingMessageString = aeh.processException(incomingMessageString, outgoingMessageString, e);
            }
        }
        if (outgoingMessageString == null) {
            try {
                try {
                    if (this.checkWriter != null) {
                        this.checkParse(incomingMessageString, incomingMessageObject, this.parser);
                    }
                }
                catch (IOException e) {
                    log.error("Unable to write parse check results to file", e);
                }
                Application app = this.findApplication(incomingMessageObject);
                Message response = app.processMessage(incomingMessageObject);
                outgoingMessageString = this.parser.encode(response, this.parser.getEncoding(incomingMessageString));
            }
            catch (Exception e) {
                outgoingMessageString = Responder.logAndMakeErrorMessage(e, (Segment)incomingMessageObject.get("MSH"), this.parser, this.parser.getEncoding(incomingMessageString));
            }
        }
        log.info("Responder sending message: " + outgoingMessageString);
        rawOutbound.info(outgoingMessageString);
        return outgoingMessageString;
    }

    private Application findApplication(Message message) {
        int c = 0;
        Application app = null;
        while (app == null && c < this.apps.size()) {
            Application a;
            if (!(a = (Application)this.apps.get(c++)).canProcess(message)) continue;
            app = a;
        }
        if (app == null) {
            app = new DefaultApplication();
        }
        return app;
    }

    private void checkParse(String originalMessageText, Message parsedMessage, Parser parser) throws HL7Exception, IOException {
        log.info("ca.uhn.hl7v2.app.Responder is checking parse integrity (turn this off if you are not testing)");
        String newMessageText = parser.encode(parsedMessage);
        this.checkWriter.write("******************* Comparing Messages ****************\r\n");
        this.checkWriter.write("Original:           " + originalMessageText + "\r\n");
        this.checkWriter.write("Parsed and Encoded: " + newMessageText + "\r\n");
        if (!originalMessageText.equals(newMessageText)) {
            StringTokenizer tok = new StringTokenizer(originalMessageText, "\r");
            ArrayList<String> one = new ArrayList<String>();
            while (tok.hasMoreTokens()) {
                String seg = tok.nextToken();
                if (seg.length() <= 4) continue;
                one.add(seg);
            }
            tok = new StringTokenizer(newMessageText, "\r");
            ArrayList<String> two = new ArrayList<String>();
            while (tok.hasMoreTokens()) {
                String seg = tok.nextToken();
                if (seg.length() <= 4) continue;
                two.add(Responder.stripExtraDelimiters(seg, seg.charAt(3)));
            }
            if (one.size() != two.size()) {
                this.checkWriter.write("Warning: inbound and parsed messages have different numbers of segments: \r\n");
                this.checkWriter.write("Original: " + originalMessageText + "\r\n");
                this.checkWriter.write("Parsed:   " + newMessageText + "\r\n");
            } else {
                for (int i = 0; i < one.size(); ++i) {
                    String newSeg;
                    String origSeg = (String)one.get(i);
                    if (origSeg.equals(newSeg = (String)two.get(i))) continue;
                    this.checkWriter.write("Warning: inbound and parsed message segment differs: \r\n");
                    this.checkWriter.write("Original: " + origSeg + "\r\n");
                    this.checkWriter.write("Parsed: " + newSeg + "\r\n");
                }
            }
        } else {
            this.checkWriter.write("No differences found\r\n");
        }
        this.checkWriter.write("********************  End Comparison  ******************\r\n");
        this.checkWriter.flush();
    }

    private static String stripExtraDelimiters(String in, char delim) {
        char[] chars = in.toCharArray();
        int c = chars.length - 1;
        boolean found = false;
        while (c >= 0 && !found) {
            if (chars[c--] == delim) continue;
            found = true;
        }
        String ret = "";
        if (found) {
            ret = String.valueOf(chars, 0, c + 2);
        }
        return ret;
    }

    public static String logAndMakeErrorMessage(Exception e, Segment inHeader, Parser p, String encoding) throws HL7Exception {
        log.error("Attempting to send error message to remote system.", e);
        String errorMessage = null;
        try {
            Message out = DefaultApplication.makeACK(inHeader);
            Terser t = new Terser(out);
            try {
                t.set("/MSH-10", MessageIDGenerator.getInstance().getNewID());
            }
            catch (IOException ioe) {
                throw new HL7Exception("Problem creating error message ID: " + ioe.getMessage());
            }
            t.set("/MSA-1", "AE");
            t.set("/MSA-2", Terser.get(inHeader, 10, 0, 1, 1));
            String excepMessage = e.getMessage();
            if (excepMessage != null) {
                t.set("/MSA-3", excepMessage.substring(0, Math.min(80, excepMessage.length())));
            }
            if (e.getClass().equals(HL7Exception.class)) {
                Segment err = (Segment)out.get("ERR");
            } else {
                t.set("/ERR-1-4-1", "207");
                t.set("/ERR-1-4-2", "Application Internal Error");
                t.set("/ERR-1-4-3", "HL70357");
            }
            errorMessage = encoding != null ? p.encode(out, encoding) : p.encode(out);
        }
        catch (IOException ioe) {
            throw new HL7Exception("IOException creating error response message: " + ioe.getMessage(), 207);
        }
        return errorMessage;
    }

    public void registerApplication(Application a) {
        this.apps.add(a);
    }

    public static void main(String[] args) {
        if (args.length != 1) {
            System.err.println("Usage: DefaultApplication message_file");
            System.exit(1);
        }
        try {
            File messageFile = new File(args[0]);
            BufferedReader in = new BufferedReader(new FileReader(messageFile));
            int fileLength = (int)messageFile.length();
            char[] cbuf = new char[fileLength];
            ((Reader)in).read(cbuf, 0, fileLength);
            String messageString = new String(cbuf);
            PipeParser parser = new PipeParser();
            Message inMessage = null;
            try {
                inMessage = ((Parser)parser).parse(messageString);
            }
            catch (HL7Exception e) {
                e.printStackTrace();
            }
            PipedInputStream initInbound = new PipedInputStream();
            PipedOutputStream initOutbound = new PipedOutputStream();
            PipedInputStream respInbound = new PipedInputStream(initOutbound);
            PipedOutputStream respOutbound = new PipedOutputStream(initInbound);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

