/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.redis.cluster;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.lambdaworks.redis.ClientOptions;
import com.lambdaworks.redis.RedisChannelWriter;
import com.lambdaworks.redis.RedisException;
import com.lambdaworks.redis.protocol.CommandHandler;
import com.lambdaworks.redis.protocol.ConnectionWatchdog;
import com.lambdaworks.redis.protocol.RedisCommand;
import com.lambdaworks.redis.resource.ClientResources;
import io.netty.channel.ChannelHandler;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Queue;
import java.util.Set;

@ChannelHandler.Sharable
class ClusterNodeCommandHandler<K, V>
extends CommandHandler<K, V> {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(ClusterNodeCommandHandler.class);
    private static final Set<CommandHandler.LifecycleState> CHANNEL_OPEN_STATES = ImmutableSet.of((Object)((Object)CommandHandler.LifecycleState.ACTIVATING), (Object)((Object)CommandHandler.LifecycleState.ACTIVE), (Object)((Object)CommandHandler.LifecycleState.CONNECTED));
    private final RedisChannelWriter<K, V> clusterChannelWriter;

    public ClusterNodeCommandHandler(ClientOptions clientOptions, ClientResources clientResources, Queue<RedisCommand<K, V, ?>> queue, RedisChannelWriter<K, V> clusterChannelWriter) {
        super(clientOptions, clientResources, queue);
        this.clusterChannelWriter = clusterChannelWriter;
    }

    public void prepareClose() {
        ConnectionWatchdog connectionWatchdog;
        if (this.channel != null && (connectionWatchdog = (ConnectionWatchdog)this.channel.pipeline().get(ConnectionWatchdog.class)) != null) {
            connectionWatchdog.setReconnectSuspended(true);
        }
    }

    @Override
    public void close() {
        logger.debug("{} close()", (Object)this.logPrefix());
        if (this.clusterChannelWriter != null) {
            Collection<RedisCommand<K, V, ?>> commands;
            if (this.isAutoReconnect() && !CHANNEL_OPEN_STATES.contains((Object)this.getState())) {
                commands = this.shiftCommands(this.queue);
                this.retriggerCommands(commands);
            }
            commands = this.shiftCommands(this.commandBuffer);
            this.retriggerCommands(commands);
        }
        super.close();
    }

    protected void retriggerCommands(Collection<RedisCommand<K, V, ?>> commands) {
        for (RedisCommand<K, V, ?> queuedCommand : commands) {
            if (queuedCommand == null || queuedCommand.isCancelled()) continue;
            try {
                this.clusterChannelWriter.write(queuedCommand);
            }
            catch (RedisException e) {
                queuedCommand.setException(e);
                queuedCommand.complete();
            }
        }
    }

    private Collection<RedisCommand<K, V, ?>> shiftCommands(Collection<RedisCommand<K, V, ?>> source) {
        try {
            this.writeLock.lock();
            try {
                ArrayList arrayList = Lists.newArrayList(source);
                source.clear();
                return arrayList;
            }
            catch (Throwable throwable) {
                source.clear();
                throw throwable;
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public boolean isAutoReconnect() {
        return this.clientOptions.isAutoReconnect();
    }
}

