/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.wikitty.generator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.nuiton.eugene.java.ObjectModelTransformerToJava;
import org.nuiton.eugene.models.object.ObjectModelAttribute;
import org.nuiton.eugene.models.object.ObjectModelClass;
import org.nuiton.eugene.models.object.ObjectModelClassifier;
import org.nuiton.eugene.models.object.ObjectModelElement;
import org.nuiton.eugene.models.object.ObjectModelModifier;
import org.nuiton.eugene.models.object.ObjectModelOperation;
import org.nuiton.wikitty.generator.WikittyTagValue;
import org.nuiton.wikitty.generator.WikittyTransformerUtil;

public class WikittyHelperGenerator
extends ObjectModelTransformerToJava
implements WikittyTagValue {
    protected static final String META_EXTENSION_SEPARATOR = ":";

    public void transformFromClass(ObjectModelClass clazz) {
        if (WikittyTransformerUtil.isBusinessEntity(clazz) || WikittyTransformerUtil.isMetaExtension(clazz)) {
            ObjectModelClass helper = this.createClass(WikittyTransformerUtil.businessEntityToHelperName(clazz), clazz.getPackageName());
            this.addImport((ObjectModelClassifier)helper, "org.nuiton.wikitty.entities.BusinessEntity");
            this.addImport((ObjectModelClassifier)helper, "org.nuiton.wikitty.entities.BusinessEntityImpl");
            this.addImport((ObjectModelClassifier)helper, "org.nuiton.wikitty.entities.Wikitty");
            this.addImport((ObjectModelClassifier)helper, "org.nuiton.wikitty.entities.WikittyExtension");
            this.addImport((ObjectModelClassifier)helper, "org.nuiton.wikitty.WikittyUtil");
            this.addImport((ObjectModelClassifier)helper, "org.nuiton.wikitty.entities.WikittyUser");
            this.addImport((ObjectModelClassifier)helper, "org.nuiton.wikitty.entities.WikittyUserAbstract");
            this.addImport((ObjectModelClassifier)helper, "org.nuiton.wikitty.entities.WikittyUserImpl");
            this.addImport((ObjectModelClassifier)helper, "org.nuiton.wikitty.entities.WikittyTreeNode");
            this.addImport((ObjectModelClassifier)helper, "org.nuiton.wikitty.entities.WikittyTreeNodeAbstract");
            this.addImport((ObjectModelClassifier)helper, "org.nuiton.wikitty.entities.WikittyTreeNodeImpl");
            this.addImport((ObjectModelClassifier)helper, List.class);
            this.addImport((ObjectModelClassifier)helper, ArrayList.class);
            this.addImport((ObjectModelClassifier)helper, Collection.class);
            this.addImport((ObjectModelClassifier)helper, Collections.class);
            this.addImport((ObjectModelClassifier)helper, Set.class);
            this.addImport((ObjectModelClassifier)helper, Date.class);
            this.addImport((ObjectModelClassifier)helper, LinkedHashSet.class);
            ObjectModelOperation constructor = this.addConstructor(helper, ObjectModelModifier.PRIVATE);
            this.setDocumentation((ObjectModelElement)constructor, "utility class all provided methods are accessible the static way");
            this.setOperationBody(constructor, "// empty\n");
            if (WikittyTransformerUtil.isBusinessEntity(clazz)) {
                this.createOperationsForBusinessEntity(clazz, helper);
            }
            if (WikittyTransformerUtil.isMetaExtension(clazz)) {
                this.createOperationForMetaExtension(clazz, helper);
            }
        }
    }

    protected void createOperationsForBusinessEntity(ObjectModelClass entity, ObjectModelClass helper) {
        String extensionVariableName = WikittyTransformerUtil.classToExtensionVariableName(entity, true);
        for (ObjectModelAttribute attribute : entity.getAttributes()) {
            if (!attribute.isNavigable()) continue;
            String fieldVariableName = WikittyTransformerUtil.attributeToFielVariableName(attribute, true);
            String attributeType = WikittyTransformerUtil.generateResultType(attribute, false);
            String attributeObjectType = WikittyTransformerUtil.generateResultObjectType(attribute, false);
            String attributeName = attribute.getName();
            if (attribute.hasTagValue("alternativeName")) {
                attributeName = attribute.getTagValue("alternativeName");
            }
            if (WikittyTransformerUtil.isAttributeCollection(attribute)) {
                String attributeTypeCollectionStrict = WikittyTransformerUtil.generateResultType(attribute, true);
                String attributeTypeCollectionGeneric = "Collection<" + attributeType + ">";
                String attributeTypeVarargs = attributeType + "...";
                String attributeObjectTypeCollectionStrict = WikittyTransformerUtil.generateResultObjectType(attribute, true);
                String attributeObjectTypeCollectionGeneric = "Collection<" + attributeObjectType + ">";
                String attributeObjectTypeVarargs = attributeObjectType + "...";
                String getFieldMethodName = WikittyTransformerUtil.generateGetFieldAsCall(attribute);
                String attributeNameCapitalized = StringUtils.capitalize((String)attributeName);
                String getterName = "get" + attributeNameCapitalized;
                ObjectModelOperation getter = this.addOperation((ObjectModelClassifier)helper, getterName, attributeTypeCollectionStrict, new ObjectModelModifier[]{ObjectModelModifier.STATIC});
                this.addParameter(getter, "Wikitty", "wikitty");
                String getterBody = "\n        " + attributeTypeCollectionStrict + " result = wikitty." + getFieldMethodName + "(" + extensionVariableName + ", " + fieldVariableName + ", " + attributeType + ".class);\n" + "        return result;\n" + "";
                this.setOperationBody(getter, getterBody);
                String setterName = "set" + attributeNameCapitalized;
                ObjectModelOperation setter = this.addOperation((ObjectModelClassifier)helper, setterName, "void", new ObjectModelModifier[]{ObjectModelModifier.STATIC});
                this.addParameter(setter, "org.nuiton.wikitty.entities.Wikitty", "wikitty");
                this.addParameter(setter, attributeTypeCollectionStrict, attributeName);
                String setterBody = "\n        wikitty.setField(" + extensionVariableName + ", " + fieldVariableName + ", " + attributeName + ");\n" + "";
                this.setOperationBody(setter, setterBody);
                String addAllName = "addAll" + attributeNameCapitalized;
                ObjectModelOperation addAll = this.addOperation((ObjectModelClassifier)helper, addAllName, "void", new ObjectModelModifier[]{ObjectModelModifier.STATIC});
                this.addParameter(addAll, "org.nuiton.wikitty.entities.Wikitty", "wikitty");
                this.addParameter(addAll, attributeTypeCollectionGeneric, attributeName);
                String addAllBody = "\n        if(" + attributeName + " != null){\n" + "            for (" + attributeType + " v:" + attributeName + "){\n" + "                add" + attributeNameCapitalized + "(wikitty, v);\n" + "            }\n" + "        }\n" + "";
                this.setOperationBody(addAll, addAllBody);
                String addName = "add" + attributeNameCapitalized;
                ObjectModelOperation adder = this.addOperation((ObjectModelClassifier)helper, addName, "void", new ObjectModelModifier[]{ObjectModelModifier.STATIC});
                this.addParameter(adder, "Wikitty", "wikitty");
                this.addParameter(adder, attributeTypeVarargs, "element");
                String adderBody = "\n        for (" + attributeType + " v : element) {\n" + "            wikitty.addToField(" + extensionVariableName + ", " + fieldVariableName + ", v);\n" + "        }\n" + "";
                this.setOperationBody(adder, adderBody);
                String removeName = "remove" + StringUtils.capitalize((String)attributeName);
                ObjectModelOperation remover = this.addOperation((ObjectModelClassifier)helper, removeName, "void", new ObjectModelModifier[]{ObjectModelModifier.STATIC});
                this.addParameter(remover, "Wikitty", "wikitty");
                this.addParameter(remover, attributeTypeVarargs, "element");
                String removerBody = "\n        for (" + attributeType + " v : element) {\n" + "            wikitty.removeFromField(" + extensionVariableName + ", " + fieldVariableName + ", v);\n" + "        }\n" + "";
                this.setOperationBody(remover, removerBody);
                String clearName = "clear" + StringUtils.capitalize((String)attributeName);
                ObjectModelOperation clear = this.addOperation((ObjectModelClassifier)helper, clearName, "void", new ObjectModelModifier[]{ObjectModelModifier.STATIC});
                this.addParameter(clear, "Wikitty", "wikitty");
                String clearBody = "\n        wikitty.clearField(" + extensionVariableName + ", " + fieldVariableName + ");\n" + "";
                this.setOperationBody(clear, clearBody);
                if (attributeObjectType == null) continue;
                String collectionType = WikittyTransformerUtil.getCollectionTypeName(attribute);
                String getterObjectName = "get" + attributeNameCapitalized;
                ObjectModelOperation getterObject = this.addOperation((ObjectModelClassifier)helper, getterObjectName, attributeObjectTypeCollectionStrict, new ObjectModelModifier[]{ObjectModelModifier.STATIC});
                this.addParameter(getterObject, "Wikitty", "wikitty");
                this.addParameter(getterObject, "boolean", "exceptionIfNotLoaded");
                String getterObjectBody = "\n        " + attributeObjectTypeCollectionStrict + " result = WikittyUtil.newInstance(" + attributeObjectType + ".class, wikitty.getFieldAsWikitty" + collectionType + "(" + extensionVariableName + ", " + fieldVariableName + ", exceptionIfNotLoaded));\n" + "        return result;\n" + "";
                this.setOperationBody(getterObject, getterObjectBody);
                String setterObjectName = "set" + attributeNameCapitalized + "Entity";
                ObjectModelOperation setterObject = this.addOperation((ObjectModelClassifier)helper, setterObjectName, "void", new ObjectModelModifier[]{ObjectModelModifier.STATIC});
                this.addParameter(setterObject, "org.nuiton.wikitty.entities.Wikitty", "wikitty");
                this.addParameter(setterObject, attributeObjectTypeCollectionGeneric, attributeName);
                String setterObjectBody = "\n        wikitty.setField(" + extensionVariableName + ", " + fieldVariableName + ", " + attributeName + ");\n" + "";
                this.setOperationBody(setterObject, setterObjectBody);
                String addAllObjectName = "addAll" + attributeNameCapitalized + "Entity";
                ObjectModelOperation addAllObject = this.addOperation((ObjectModelClassifier)helper, addAllObjectName, "void", new ObjectModelModifier[]{ObjectModelModifier.STATIC});
                this.addParameter(addAllObject, "org.nuiton.wikitty.entities.Wikitty", "wikitty");
                this.addParameter(addAllObject, attributeObjectTypeCollectionGeneric, attributeName);
                String addAllObjectBody = "\n        if(" + attributeName + " != null){\n" + "            for (" + attributeObjectType + " v:" + attributeName + "){\n" + "                add" + attributeNameCapitalized + "(wikitty, v);\n" + "            }\n" + "        }\n" + "";
                this.setOperationBody(addAllObject, addAllObjectBody);
                String addNameObject = "add" + attributeNameCapitalized;
                ObjectModelOperation adderObject = this.addOperation((ObjectModelClassifier)helper, addNameObject, "void", new ObjectModelModifier[]{ObjectModelModifier.STATIC});
                this.addParameter(adderObject, "Wikitty", "wikitty");
                this.addParameter(adderObject, attributeObjectTypeVarargs, "element");
                String adderObjectBody = "\n        for (" + attributeObjectType + " v : element) {\n" + "            wikitty.addToField(" + extensionVariableName + ", " + fieldVariableName + ", v);\n" + "        }\n" + "";
                this.setOperationBody(adderObject, adderObjectBody);
                String removeNameObject = "remove" + StringUtils.capitalize((String)attributeName);
                ObjectModelOperation removerObject = this.addOperation((ObjectModelClassifier)helper, removeNameObject, "void", new ObjectModelModifier[]{ObjectModelModifier.STATIC});
                this.addParameter(removerObject, "Wikitty", "wikitty");
                this.addParameter(removerObject, attributeObjectTypeVarargs, "element");
                String removerObjectBody = "\n        for (" + attributeObjectType + " v : element) {\n" + "            wikitty.removeFromField(" + extensionVariableName + ", " + fieldVariableName + ", v);\n" + "        }\n" + "";
                this.setOperationBody(removerObject, removerObjectBody);
                continue;
            }
            String getFieldMethodName = WikittyTransformerUtil.generateGetFieldAsCall(attribute);
            String getterName = "get" + StringUtils.capitalize((String)attributeName);
            ObjectModelOperation getter = this.addOperation((ObjectModelClassifier)helper, getterName, attributeType, new ObjectModelModifier[]{ObjectModelModifier.STATIC});
            this.addParameter(getter, "Wikitty", "wikitty");
            this.setOperationBody(getter, "\n        " + attributeType + " value = wikitty." + getFieldMethodName + "(" + extensionVariableName + ", " + fieldVariableName + ");\n" + "        return value;\n" + "");
            String setterName = "set" + StringUtils.capitalize((String)attributeName);
            ObjectModelOperation setter = this.addOperation((ObjectModelClassifier)helper, setterName, attributeType, new ObjectModelModifier[]{ObjectModelModifier.STATIC});
            this.addParameter(setter, "Wikitty", "wikitty");
            this.addParameter(setter, attributeType, attributeName);
            this.setOperationBody(setter, "\n        " + attributeType + " oldValue = " + getter.getName() + "(wikitty);\n" + "        wikitty.setField(" + extensionVariableName + ", " + fieldVariableName + ", " + attributeName + ");\n" + "        return oldValue;\n" + "");
            if (attributeObjectType == null) continue;
            String getterObjectName = "get" + StringUtils.capitalize((String)attributeName);
            ObjectModelOperation getterObject = this.addOperation((ObjectModelClassifier)helper, getterObjectName, attributeObjectType, new ObjectModelModifier[]{ObjectModelModifier.STATIC});
            this.addParameter(getterObject, "Wikitty", "wikitty");
            this.addParameter(getterObject, "boolean", "exceptionIfNotLoaded");
            this.setOperationBody(getterObject, "\n        " + attributeObjectType + " value = WikittyUtil.newInstance(" + attributeObjectType + ".class, wikitty.getFieldAsWikitty(" + extensionVariableName + ", " + fieldVariableName + ", exceptionIfNotLoaded));\n" + "        return value;\n" + "");
            String setterObjectName = "set" + StringUtils.capitalize((String)attributeName);
            ObjectModelOperation setterObject = this.addOperation((ObjectModelClassifier)helper, setterObjectName, attributeObjectType, new ObjectModelModifier[]{ObjectModelModifier.STATIC});
            this.addParameter(setterObject, "Wikitty", "wikitty");
            this.addParameter(setterObject, attributeObjectType, attributeName);
            this.setOperationBody(setterObject, "\n        " + attributeObjectType + " oldValue = " + getter.getName() + "(wikitty, false);\n" + "        wikitty.setField(" + extensionVariableName + ", " + fieldVariableName + ", " + attributeName + ");\n" + "        return oldValue;\n" + "");
        }
        ObjectModelOperation equals = this.addOperation((ObjectModelClassifier)helper, "equals", "boolean", new ObjectModelModifier[]{ObjectModelModifier.STATIC});
        this.addParameter(equals, "org.nuiton.wikitty.entities.Wikitty", "w1");
        this.addParameter(equals, "org.nuiton.wikitty.entities.Wikitty", "w2");
        String equalsBody = "\n    boolean result = true;\n";
        for (ObjectModelAttribute attribute : entity.getAttributes()) {
            if (!attribute.isNavigable()) continue;
            String fieldVariableName = WikittyTransformerUtil.attributeToFielVariableName(attribute, true);
            equalsBody = equalsBody + "\n        if (result) {\n            Object f1 = w1.getFieldAsObject(" + extensionVariableName + ", " + fieldVariableName + ");\n" + "            Object f2 = w2.getFieldAsObject(" + extensionVariableName + ", " + fieldVariableName + ");\n" + "            result = f1 == f2 || (f1 != null && f1.equals(f2));\n" + "        };\n" + "";
        }
        equalsBody = equalsBody + "\n    return result;\n";
        this.setOperationBody(equals, equalsBody);
        ObjectModelOperation isExtension = this.addOperation((ObjectModelClassifier)helper, "isExtension", "boolean", new ObjectModelModifier[]{ObjectModelModifier.STATIC});
        this.addParameter(isExtension, "org.nuiton.wikitty.entities.Wikitty", "wikitty");
        this.addAnnotation((ObjectModelClassifier)helper, (ObjectModelElement)isExtension, "Deprecated");
        this.setDocumentation((ObjectModelElement)isExtension, "@deprecated renamed to keep consistency, use hasExtension instead");
        this.setOperationBody(isExtension, "\n        return hasExtension(wikitty);\n");
        ObjectModelOperation hasExtension = this.addOperation((ObjectModelClassifier)helper, "hasExtension", "boolean", new ObjectModelModifier[]{ObjectModelModifier.STATIC});
        this.addParameter(hasExtension, "org.nuiton.wikitty.entities.Wikitty", "wikitty");
        this.setDocumentation((ObjectModelElement)hasExtension, "check if wikitty has current extension");
        this.setOperationBody(hasExtension, "\n        return wikitty.hasExtension(" + extensionVariableName + ");\n" + "");
        ObjectModelOperation addExtension = this.addOperation((ObjectModelClassifier)helper, "addExtension", "void", new ObjectModelModifier[]{ObjectModelModifier.STATIC});
        this.addParameter(addExtension, "org.nuiton.wikitty.entities.Wikitty", "wikitty");
        this.setDocumentation((ObjectModelElement)addExtension, "ajout les extensions static de cette classe au wikitty en argument");
        String contractName = WikittyTransformerUtil.businessEntityToAbstractName(entity);
        this.setOperationBody(addExtension, "\n        for (WikittyExtension ext : " + contractName + ".extensions) {\n" + "            wikitty.addExtension(ext);\n" + "        }\n" + "");
        ObjectModelOperation toString = this.addOperation((ObjectModelClassifier)helper, "toString", "String", new ObjectModelModifier[]{ObjectModelModifier.STATIC});
        this.addParameter(toString, "org.nuiton.wikitty.entities.Wikitty", "wikitty");
        this.setDocumentation((ObjectModelElement)toString, "Return toString representation. Use tagValue 'toString' format, if exist, else standard toString is call");
        this.setOperationBody(toString, "\n\n        return wikitty.toString(" + extensionVariableName + ");\n" + "");
    }

    protected void createOperationForMetaExtension(ObjectModelClass metaExtension, ObjectModelClass helper) {
        String abstractName = WikittyTransformerUtil.businessEntityToAbstractName(metaExtension);
        String contractName = WikittyTransformerUtil.businessEntityToContractName(metaExtension);
        String extensionVariableName = WikittyTransformerUtil.classToExtensionVariableName(metaExtension, true);
        ObjectModelOperation addMetaExtension = this.addOperation((ObjectModelClassifier)helper, "addMetaExtension", "void", new ObjectModelModifier[]{ObjectModelModifier.STATIC});
        this.addParameter(addMetaExtension, "org.nuiton.wikitty.entities.WikittyExtension", "extension");
        this.addParameter(addMetaExtension, "org.nuiton.wikitty.entities.Wikitty", "wikitty");
        this.setDocumentation((ObjectModelElement)addMetaExtension, String.format("add %s meta-extension on given extension to the given wikitty", metaExtension.getName()));
        this.setOperationBody(addMetaExtension, "\n        wikitty.addMetaExtension(" + abstractName + ".extension" + contractName + ", extension);\n" + "");
        ObjectModelOperation hasMetaExtension = this.addOperation((ObjectModelClassifier)helper, "hasMetaExtension", "boolean", new ObjectModelModifier[]{ObjectModelModifier.STATIC});
        this.addParameter(hasMetaExtension, "org.nuiton.wikitty.entities.WikittyExtension", "extension");
        this.addParameter(hasMetaExtension, "org.nuiton.wikitty.entities.Wikitty", "wikitty");
        this.setDocumentation((ObjectModelElement)hasMetaExtension, String.format("true if given wikitty has %s meta-extension on given extension", metaExtension.getName()));
        this.setOperationBody(hasMetaExtension, "\n        return wikitty.hasMetaExtension(" + extensionVariableName + ", extension.getName());\n" + "");
        ObjectModelOperation getMetaFieldNameFromExtension = this.addOperation((ObjectModelClassifier)helper, "getMetaFieldName", "String", new ObjectModelModifier[]{ObjectModelModifier.STATIC});
        this.addParameter(getMetaFieldNameFromExtension, "org.nuiton.wikitty.entities.WikittyExtension", "extension");
        this.addParameter(getMetaFieldNameFromExtension, "String", "fieldName");
        this.setDocumentation((ObjectModelElement)getMetaFieldNameFromExtension, String.format("for extension 'Ext' and field 'f', return 'Ext:%s.f'", metaExtension.getName()));
        this.setOperationBody(getMetaFieldNameFromExtension, "\n        String metaFieldName = getMetaFieldName(extension.getName(), fieldName); \n        return metaFieldName;\n");
        ObjectModelOperation getMetaFieldNameFromExtensionName = this.addOperation((ObjectModelClassifier)helper, "getMetaFieldName", "String", new ObjectModelModifier[]{ObjectModelModifier.STATIC});
        this.addParameter(getMetaFieldNameFromExtensionName, "String", "extensionName");
        this.addParameter(getMetaFieldNameFromExtensionName, "String", "fieldName");
        this.setDocumentation((ObjectModelElement)getMetaFieldNameFromExtensionName, String.format("for extension 'Ext' and field 'f', return 'Ext:%s.f'", metaExtension.getName()));
        this.setOperationBody(getMetaFieldNameFromExtensionName, "\n        String metaFieldName = WikittyUtil.getMetaFieldName(\"" + metaExtension.getName() + "\", extensionName, fieldName);\n" + "        return metaFieldName;\n" + "");
        for (ObjectModelAttribute attribute : metaExtension.getAttributes()) {
            if (!attribute.isNavigable()) continue;
            String fieldVariableName = WikittyTransformerUtil.attributeToFielVariableName(attribute, true);
            String attributeType = WikittyTransformerUtil.generateResultType(attribute, false);
            String attributeObjectType = WikittyTransformerUtil.generateResultObjectType(attribute, false);
            String attributeName = attribute.getName();
            if (attribute.hasTagValue("alternativeName")) {
                attributeName = attribute.getTagValue("alternativeName");
            }
            if (WikittyTransformerUtil.isAttributeCollection(attribute)) {
                String attributeTypeCollectionStrict = WikittyTransformerUtil.generateResultType(attribute, true);
                String attributeTypeCollectionGeneric = "Collection<" + attributeType + ">";
                String attributeTypeVarargs = attributeType + "...";
                String attributeObjectTypeCollectionStrict = WikittyTransformerUtil.generateResultObjectType(attribute, true);
                String attributeObjectTypeCollectionGeneric = "Collection<" + attributeObjectType + ">";
                String attributeObjectTypeVarargs = attributeObjectType + "...";
                String getFieldMethodName = WikittyTransformerUtil.generateGetFieldAsCall(attribute);
                String capitalizedAttributeName = StringUtils.capitalize((String)attributeName);
                String getterName = "get" + capitalizedAttributeName;
                ObjectModelOperation getter = this.addOperation((ObjectModelClassifier)helper, getterName, attributeTypeCollectionStrict, new ObjectModelModifier[]{ObjectModelModifier.STATIC});
                this.addParameter(getter, "String", "extensionName");
                this.addParameter(getter, "org.nuiton.wikitty.entities.Wikitty", "wikitty");
                String getterBody = "\n        String fieldName = getMetaFieldName(extensionName, \"" + attributeName + "\");\n" + "        " + attributeTypeCollectionStrict + " result = (" + attributeTypeCollectionStrict + ") wikitty.getFqField(fieldName);\n" + "        return result;\n" + "";
                this.setOperationBody(getter, getterBody);
                String setterName = "set" + capitalizedAttributeName;
                ObjectModelOperation setter = this.addOperation((ObjectModelClassifier)helper, setterName, "void", new ObjectModelModifier[]{ObjectModelModifier.STATIC});
                this.addParameter(setter, "String", "extensionName");
                this.addParameter(setter, "org.nuiton.wikitty.entities.Wikitty", "wikitty");
                this.addParameter(setter, attributeTypeCollectionStrict, attributeName);
                String setterBody = "\n        clear" + capitalizedAttributeName + "(extensionName, wikitty);\n" + "        addAll" + capitalizedAttributeName + "(extensionName, wikitty, " + attributeName + ");\n" + "";
                this.setOperationBody(setter, setterBody);
                String addAllName = "addAll" + capitalizedAttributeName;
                ObjectModelOperation addAll = this.addOperation((ObjectModelClassifier)helper, addAllName, "void", new ObjectModelModifier[]{ObjectModelModifier.STATIC});
                this.addParameter(addAll, "String", "extensionName");
                this.addParameter(addAll, "org.nuiton.wikitty.entities.Wikitty", "wikitty");
                this.addParameter(addAll, attributeTypeCollectionGeneric, attributeName);
                String addAllBody = "\n        if(" + attributeName + " != null){\n" + "            for (" + attributeType + " id:" + attributeName + "){\n" + "                add" + capitalizedAttributeName + "(extensionName, wikitty, id);\n" + "            }\n" + "        }\n" + "";
                this.setOperationBody(addAll, addAllBody);
                String addName = "add" + capitalizedAttributeName;
                ObjectModelOperation adder = this.addOperation((ObjectModelClassifier)helper, addName, "void", new ObjectModelModifier[]{ObjectModelModifier.STATIC});
                this.addParameter(adder, "String", "extensionName");
                this.addParameter(adder, "org.nuiton.wikitty.entities.Wikitty", "wikitty");
                this.addParameter(adder, attributeTypeVarargs, "element");
                String adderBody = "\n        for (" + attributeType + " v : element) {\n" + "            String fieldName = getMetaFieldName(extensionName, \"" + attributeName + "\");\n" + "            wikitty.addToField(fieldName, v);\n" + "        }\n" + "";
                this.setOperationBody(adder, adderBody);
                String removeName = "remove" + capitalizedAttributeName;
                ObjectModelOperation remover = this.addOperation((ObjectModelClassifier)helper, removeName, "void", new ObjectModelModifier[]{ObjectModelModifier.STATIC});
                this.addParameter(remover, "String", "extensionName");
                this.addParameter(remover, "org.nuiton.wikitty.entities.Wikitty", "wikitty");
                this.addParameter(remover, attributeTypeVarargs, "element");
                String removerBody = "\n        for (" + attributeType + " v : element) {\n" + "            String fieldName = getMetaFieldName(extensionName, \"" + attributeName + "\");\n" + "            wikitty.removeFromField(fieldName, v);\n" + "        }\n" + "";
                this.setOperationBody(remover, removerBody);
                String clearName = "clear" + capitalizedAttributeName;
                ObjectModelOperation clear = this.addOperation((ObjectModelClassifier)helper, clearName, "void", new ObjectModelModifier[]{ObjectModelModifier.STATIC});
                this.addParameter(clear, "String", "extensionName");
                this.addParameter(clear, "org.nuiton.wikitty.entities.Wikitty", "wikitty");
                String clearBody = "\n        String fieldName = getMetaFieldName(extensionName, \"" + attributeName + "\");\n" + "        wikitty.clearField(fieldName);\n" + "";
                this.setOperationBody(clear, clearBody);
                if (attributeObjectType == null) continue;
                String collectionType = WikittyTransformerUtil.getCollectionTypeName(attribute);
                String getterNameObject = "get" + capitalizedAttributeName;
                ObjectModelOperation getterObject = this.addOperation((ObjectModelClassifier)helper, getterNameObject, attributeObjectTypeCollectionStrict, new ObjectModelModifier[]{ObjectModelModifier.STATIC});
                this.addParameter(getterObject, "String", "extensionName");
                this.addParameter(getterObject, "org.nuiton.wikitty.entities.Wikitty", "wikitty");
                this.addParameter(getterObject, "boolean", "exceptionIfNotLoaded");
                String getterObjectBody = "\n        String fqfieldName = getMetaFieldName(extensionName, \"" + attributeName + "\");\n" + "        String extName = WikittyExtension.extractExtensionName(fqfieldName);\n" + "        String fieldName = WikittyExtension.extractFieldName(fqfieldName);\n" + "        " + attributeObjectTypeCollectionStrict + " result = WikittyUtil.newInstance(" + attributeObjectType + ".class, wikitty.getFieldAsWikitty" + collectionType + "(extName, fieldName, exceptionIfNotLoaded));\n" + "        return result;\n" + "";
                this.setOperationBody(getterObject, getterObjectBody);
                String setterNameObject = "set" + capitalizedAttributeName + "Entity";
                ObjectModelOperation setterObject = this.addOperation((ObjectModelClassifier)helper, setterNameObject, "void", new ObjectModelModifier[]{ObjectModelModifier.STATIC});
                this.addParameter(setterObject, "String", "extensionName");
                this.addParameter(setterObject, "org.nuiton.wikitty.entities.Wikitty", "wikitty");
                this.addParameter(setterObject, attributeObjectTypeCollectionGeneric, attributeName);
                String setterObjectBody = "\n        clear" + capitalizedAttributeName + "(extensionName, wikitty);\n" + "        addAll" + capitalizedAttributeName + "Entity(extensionName, wikitty, " + attributeName + ");\n" + "";
                this.setOperationBody(setterObject, setterObjectBody);
                String addAllNameObject = "addAll" + capitalizedAttributeName + "Entity";
                ObjectModelOperation addAllObject = this.addOperation((ObjectModelClassifier)helper, addAllNameObject, "void", new ObjectModelModifier[]{ObjectModelModifier.STATIC});
                this.addParameter(addAllObject, "String", "extensionName");
                this.addParameter(addAllObject, "org.nuiton.wikitty.entities.Wikitty", "wikitty");
                this.addParameter(addAllObject, attributeObjectTypeCollectionGeneric, attributeName);
                String addAllObjectBody = "\n        if(" + attributeName + " != null){\n" + "            for (" + attributeObjectType + " e:" + attributeName + "){\n" + "                add" + capitalizedAttributeName + "(extensionName, wikitty, e);\n" + "            }\n" + "        }\n" + "";
                this.setOperationBody(addAllObject, addAllObjectBody);
                String addNameObject = "add" + capitalizedAttributeName;
                ObjectModelOperation adderObject = this.addOperation((ObjectModelClassifier)helper, addNameObject, "void", new ObjectModelModifier[]{ObjectModelModifier.STATIC});
                this.addParameter(adderObject, "String", "extensionName");
                this.addParameter(adderObject, "org.nuiton.wikitty.entities.Wikitty", "wikitty");
                this.addParameter(adderObject, attributeObjectTypeVarargs, "element");
                String adderObjectBody = "\n        for (" + attributeObjectType + " v : element) {\n" + "            String fieldName = getMetaFieldName(extensionName, \"" + attributeName + "\");\n" + "            wikitty.addToField(fieldName, v);\n" + "        }\n" + "";
                this.setOperationBody(adderObject, adderObjectBody);
                String removeNameObject = "remove" + capitalizedAttributeName;
                ObjectModelOperation removerObject = this.addOperation((ObjectModelClassifier)helper, removeNameObject, "void", new ObjectModelModifier[]{ObjectModelModifier.STATIC});
                this.addParameter(removerObject, "String", "extensionName");
                this.addParameter(removerObject, "org.nuiton.wikitty.entities.Wikitty", "wikitty");
                this.addParameter(removerObject, attributeObjectTypeVarargs, "element");
                String removerObjectBody = "\n        for (" + attributeObjectType + " v : element) {\n" + "            String fieldName = getMetaFieldName(extensionName, \"" + attributeName + "\");\n" + "            wikitty.removeFromField(fieldName, v);\n" + "        }\n" + "";
                this.setOperationBody(removerObject, removerObjectBody);
                continue;
            }
            String getFieldMethodName = WikittyTransformerUtil.generateGetFieldAsCall(attribute);
            String getterName = "get" + StringUtils.capitalize((String)attributeName);
            ObjectModelOperation getter = this.addOperation((ObjectModelClassifier)helper, getterName, attributeType, new ObjectModelModifier[]{ObjectModelModifier.STATIC});
            this.addParameter(getter, "String", "extensionName");
            this.addParameter(getter, "org.nuiton.wikitty.entities.Wikitty", "wikitty");
            this.setOperationBody(getter, "\n        String fieldName = getMetaFieldName(extensionName, \"" + attributeName + "\");\n" + "        " + attributeType + " value = (" + attributeType + ") wikitty.getFqField(fieldName);        \n" + "        return value;\n" + "");
            String setterName = "set" + StringUtils.capitalize((String)attributeName);
            ObjectModelOperation setter = this.addOperation((ObjectModelClassifier)helper, setterName, attributeType, new ObjectModelModifier[]{ObjectModelModifier.STATIC});
            this.addParameter(setter, "String", "extensionName");
            this.addParameter(setter, "org.nuiton.wikitty.entities.Wikitty", "wikitty");
            this.addParameter(setter, attributeType, attributeName);
            this.setOperationBody(setter, "\n        " + attributeType + " oldValue = " + getter.getName() + "(extensionName, wikitty);\n" + "        String fieldName = getMetaFieldName(extensionName, \"" + attributeName + "\");\n" + "        wikitty.setFqField(fieldName, " + attributeName + ");\n" + "        return oldValue;\n" + "");
            if (attributeObjectType == null) continue;
            String getterNameObject = "get" + StringUtils.capitalize((String)attributeName);
            ObjectModelOperation getterObject = this.addOperation((ObjectModelClassifier)helper, getterNameObject, attributeObjectType, new ObjectModelModifier[]{ObjectModelModifier.STATIC});
            this.addParameter(getterObject, "String", "extensionName");
            this.addParameter(getterObject, "org.nuiton.wikitty.entities.Wikitty", "wikitty");
            this.addParameter(getterObject, "boolean", "exceptionIfNotLoaded");
            this.setOperationBody(getterObject, "\n        String fqfieldName = getMetaFieldName(extensionName, \"" + attributeName + "\");\n" + "        String extName = WikittyExtension.extractExtensionName(fqfieldName);\n" + "        String fieldName = WikittyExtension.extractFieldName(fqfieldName);\n" + "        " + attributeObjectType + " value = WikittyUtil.newInstance(" + attributeObjectType + ".class, wikitty.getFieldAsWikitty(extName, fieldName, exceptionIfNotLoaded));\n" + "        return value;\n" + "");
            String setterNameObject = "set" + StringUtils.capitalize((String)attributeName);
            ObjectModelOperation setterObject = this.addOperation((ObjectModelClassifier)helper, setterNameObject, attributeObjectType, new ObjectModelModifier[]{ObjectModelModifier.STATIC});
            this.addParameter(setterObject, "String", "extensionName");
            this.addParameter(setterObject, "org.nuiton.wikitty.entities.Wikitty", "wikitty");
            this.addParameter(setterObject, attributeObjectType, attributeName);
            this.setOperationBody(setterObject, "\n        " + attributeObjectType + " oldValue = " + getterObject.getName() + "(extensionName, wikitty, false);\n" + "        String fieldName = getMetaFieldName(extensionName, \"" + attributeName + "\");\n" + "        wikitty.setFqField(fieldName, " + attributeName + ");\n" + "        return oldValue;\n" + "");
        }
    }
}

