/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.wikitty.services;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.Assert;
import org.junit.Test;
import org.nuiton.config.ApplicationConfig;
import org.nuiton.wikitty.WikittyConfig;
import org.nuiton.wikitty.WikittyConfigOption;
import org.nuiton.wikitty.WikittyService;
import org.nuiton.wikitty.WikittyServiceFactory;
import org.nuiton.wikitty.services.WikittyServiceAuthentication;
import org.nuiton.wikitty.services.WikittyServiceAuthorisation;
import org.nuiton.wikitty.services.WikittyServiceCached;
import org.nuiton.wikitty.services.WikittyServiceInMemory;
import org.nuiton.wikitty.services.WikittyServiceNotifier;
import org.nuiton.wikitty.services.WikittyServiceStorage;
import org.nuiton.wikitty.storage.WikittyExtensionStorageInMemory;
import org.nuiton.wikitty.storage.WikittySearchEngineInMemory;
import org.nuiton.wikitty.storage.WikittyStorageInMemory;

public class WikittyServiceHelperTest {
    private static Log log = LogFactory.getLog(WikittyServiceHelperTest.class);

    @Test
    public void testBuild() throws Exception {
        ApplicationConfig config = WikittyConfig.getConfig();
        config.setOption(WikittyConfigOption.WIKITTY_WIKITTYSERVICE_COMPONENTS.getKey(), WikittyServiceInMemory.class.getName() + "," + WikittyServiceNotifier.class.getName() + "," + WikittyServiceCached.class.getName());
        WikittyService ws = WikittyServiceFactory.buildWikittyService((ApplicationConfig)config);
        Assert.assertEquals(WikittyServiceCached.class, ws.getClass());
        ws = ((WikittyServiceCached)ws).getDelegate();
        Assert.assertEquals(WikittyServiceNotifier.class, ws.getClass());
        ws = ((WikittyServiceNotifier)ws).getDelegate();
        Assert.assertEquals(WikittyServiceInMemory.class, ws.getClass());
    }

    @Test
    public void testSampleConfig() throws Exception {
        ApplicationConfig config = WikittyConfig.getConfig((String)"wikitty-config-sample-inmemory.properties");
        config.setOption(WikittyConfigOption.WIKITTY_WIKITTYSERVICESTORAGE_COMPONENTS.getKey(), WikittyStorageInMemory.class.getName() + "," + WikittyExtensionStorageInMemory.class.getName() + "," + WikittySearchEngineInMemory.class.getName());
        WikittyService ws = WikittyServiceFactory.buildWikittyService((ApplicationConfig)config);
        Assert.assertEquals(WikittyServiceAuthorisation.class, ws.getClass());
        ws = ((WikittyServiceAuthorisation)ws).getDelegate();
        Assert.assertEquals(WikittyServiceAuthentication.class, ws.getClass());
        ws = ((WikittyServiceAuthentication)ws).getDelegate();
        Assert.assertEquals(WikittyServiceCached.class, ws.getClass());
        ws = ((WikittyServiceCached)ws).getDelegate();
        Assert.assertEquals(WikittyServiceNotifier.class, ws.getClass());
        ws = ((WikittyServiceNotifier)ws).getDelegate();
        Assert.assertEquals(WikittyServiceStorage.class, ws.getClass());
    }
}

