/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.wikitty.addons.importexport;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.junit.Assert;
import org.junit.Test;
import org.nuiton.util.StringUtil;
import org.nuiton.wikitty.addons.importexport.ImportExportCSV;

public class ImportExportCSVTest {
    @Test
    public void testQueryPattern() {
        ImportExportCSV task = new ImportExportCSV();
        Pattern pattern = task.queryPattern;
        Matcher m = pattern.matcher("rtet");
        Assert.assertFalse((boolean)m.find());
        m = pattern.matcher("Client=4e2e4a93-c412-46b8-beb9-e76e0f16740d");
        Assert.assertFalse((boolean)m.find());
        m = pattern.matcher("Client=4e2e4a93-c412-46b8-beb9-e76e0f16740d");
        Assert.assertFalse((boolean)m.find());
        m = pattern.matcher("Client.name=toto");
        Assert.assertTrue((boolean)m.find());
        Assert.assertEquals((Object)"Client.name", (Object)m.group(1));
        Assert.assertEquals((Object)"Client", (Object)m.group(2));
        Assert.assertEquals((Object)"name", (Object)m.group(3));
        Assert.assertEquals((Object)"toto", (Object)m.group(4));
        m = pattern.matcher("Client.name=toto");
        Assert.assertTrue((boolean)m.find());
        Assert.assertEquals((Object)"toto", (Object)m.group(6));
        m = pattern.matcher("Client.name=\"toto\"");
        Assert.assertTrue((boolean)m.find());
        Assert.assertEquals((Object)"toto", (Object)m.group(5));
        m = pattern.matcher("Client.name=\"toto");
        Assert.assertFalse((boolean)m.find());
        m = pattern.matcher("Client.name=\"to\"to\"");
        Assert.assertTrue((boolean)m.find());
        Assert.assertEquals((Object)"to\"to", (Object)m.group(5));
        m = pattern.matcher("Client.name=toto\"");
        Assert.assertFalse((boolean)m.find());
    }

    @Test
    public void testMultipleFieldsParsing() {
        String test = "(sdfsdf),(dfsdf),(fdsfsdfg),(sdfsdfqs)";
        String[] result = StringUtil.split((String)test);
        Assert.assertEquals((long)4L, (long)result.length);
        Assert.assertEquals((Object)"(sdfsdf)", (Object)result[0]);
        Assert.assertEquals((Object)"sdfsdf", (Object)result[0].substring(1, result[0].length() - 1));
        Assert.assertEquals((Object)"(dfsdf)", (Object)result[1]);
        Assert.assertEquals((Object)"(fdsfsdfg)", (Object)result[2]);
        Assert.assertEquals((Object)"(sdfsdfqs)", (Object)result[3]);
        test = "(sdf\",\"sdf),(df()sdf),(fds\"(),()\"fsdfg),(sdfsdfqs)";
        result = StringUtil.split((String)test);
        Assert.assertEquals((long)4L, (long)result.length);
        Assert.assertEquals((Object)"(sdf\",\"sdf)", (Object)result[0]);
        Assert.assertEquals((Object)"(df()sdf)", (Object)result[1]);
        Assert.assertEquals((Object)"(fds\"(),()\"fsdfg)", (Object)result[2]);
        Assert.assertEquals((Object)"(sdfsdfqs)", (Object)result[3]);
        test = "toto ?";
        result = StringUtil.split((String)test);
        Assert.assertEquals((long)1L, (long)result.length);
        Assert.assertEquals((Object)"toto ?", (Object)result[0]);
    }
}

