/*
 * #%L
 * Wikitty :: api
 * 
 * $Id: WikittyServiceCajoTest.java 693 2011-01-27 10:09:16Z jcouteau $
 * $HeadURL: http://svn.nuiton.org/svn/wikitty/tags/wikitty-3.0.3/wikitty-api/src/test/java/org/nuiton/wikitty/services/WikittyServiceCajoTest.java $
 * %%
 * Copyright (C) 2009 - 2011 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
package org.nuiton.wikitty.services;


import gnu.cajo.utils.ItemServer;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.Assert;
import org.junit.Test;
import org.nuiton.wikitty.WikittyConfig;
import org.nuiton.wikitty.WikittyProxy;
import org.nuiton.wikitty.WikittyService;
import org.nuiton.wikitty.WikittyServiceFactory;
import org.nuiton.wikitty.entities.Wikitty;
import org.nuiton.wikitty.entities.WikittyImpl;

/**
 *
 * @author poussin
 * @version $Revision: 693 $
 *
 * Last update: $Date: 2011-01-27 11:09:16 +0100 (jeu., 27 janv. 2011) $
 * by : $Author: jcouteau $
 */
public class WikittyServiceCajoTest {

    /** to use log facility, just put in your code: log.info(\"...\"); */
    static private Log log = LogFactory.getLog(WikittyServiceCajoTest.class);

    static final protected String url = "http://localhost:1198/ws";

    protected WikittyService startServer() throws Exception {
        Properties props = new Properties();
        props.setProperty(WikittyConfig.WikittyOption.WIKITTY_SERVER_URL.getKey(),
                url);
        props.setProperty(WikittyConfig.WikittyOption.WIKITTY_WIKITTYSERVICE_COMPONENTS.getKey(),
                WikittyServiceInMemory.class.getName() + "," +
                WikittyServiceCajoServer.class.getName());
        WikittyConfig config = new WikittyConfig(props);
        WikittyService result = WikittyServiceFactory.buildWikittyService(config);
        return result;
    }

    protected void stopServer(WikittyService ws) {
        if (ws instanceof WikittyServiceCajoServer) {
            ((WikittyServiceCajoServer)ws).stop();
        }
    }

    protected WikittyService getClient() throws Exception {
        Properties props = new Properties();
        props.setProperty(WikittyConfig.WikittyOption.WIKITTY_SERVER_URL.getKey(),
                url);
        props.setProperty(WikittyConfig.WikittyOption.WIKITTY_WIKITTYSERVICE_COMPONENTS.getKey(),
                WikittyServiceCajoClient.class.getName());
        WikittyConfig config = new WikittyConfig(props);
        WikittyService result = WikittyServiceFactory.buildWikittyService(config);
        return result;
    }


    @Test
    public void testCajo() throws Exception {
        WikittyService server = startServer();
        WikittyService client = getClient();

        WikittyProxy proxy = new WikittyProxy(client);

        Wikitty w = new WikittyImpl();
        proxy.store(w);

        List<Wikitty> list = server.restore(null, Collections.singletonList(w.getId()));
        Assert.assertEquals(1, list.size());

        stopServer(server);
    }

}
