package org.nuiton.web.security;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.TopiaDAOImpl;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.web.SecurityDAOHelper.SecurityEntityEnum;

public abstract class SecurityRoleDAOAbstract<E extends SecurityRole> extends TopiaDAOImpl<E> {

    @Override
    public Class<E> getEntityClass() {
        return (Class<E>)SecurityRole.class;
    }

    @Override
    public SecurityEntityEnum getTopiaEntityEnum() {
        return SecurityEntityEnum.SecurityRole;
    }

    @Override
    public void delete(E entity) throws TopiaException {
        {
            List<SecurityUser> list = getContext().getHibernate().createSQLQuery(
                    "SELECT main.topiaid " +
                    "from securityUser main, securityrole_securityuser secondary " +
                    "where main.topiaid=secondary.securityUser" +
                    " and secondary.securityRole='" + entity.getTopiaId() + "'")
                    .addEntity("main", org.nuiton.web.SecurityDAOHelper.getImplementationClass(SecurityUser.class)).list();

            for (SecurityUser item : list) {
                item.removeSecurityRole(entity);
            }
        }

        super.delete(entity);
    }

    public E findByName(String v) throws TopiaException {
        E result = findByProperty(SecurityRole.NAME, v);
        return result;
    }

    public List<E> findAllByName(String v) throws TopiaException {
        List<E> result = findAllByProperty(SecurityRole.NAME, v);
        return result;
    }

    public E findContainsPermissions(String v) throws TopiaException {
        E result = findContains(SecurityRole.PERMISSIONS, v);
        return result;
    }

    public List<E> findAllContainsPermissions(String v) throws TopiaException {
        List<E> result = findAllContains(SecurityRole.PERMISSIONS, v);
        return result;
    }

    @Override
    public <U extends TopiaEntity> List<U> findUsages(Class<U> type, E entity) throws TopiaException {
        List<?> result = new ArrayList();
        List tmp;

        if (type == SecurityUser.class) {
            SecurityUserDAO dao = (SecurityUserDAO)
                getContext().getDAO(SecurityUser.class);
            tmp = dao.findAllContainsSecurityRole(entity);
            result.addAll(tmp);
        }

        return (List<U>) result;
    }

    @Override
    public Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> findAllUsages(E entity) throws TopiaException {
        Map<Class<? extends TopiaEntity>,List<? extends TopiaEntity>> result;
        result = new HashMap<Class<? extends TopiaEntity>, List<? extends TopiaEntity>>(1);

        List<? extends TopiaEntity> list;

        list = findUsages(SecurityUser.class, entity);
        if (!list.isEmpty()) {
            result.put(SecurityUser.class, list);
        }

        return result;
    }

} //SecurityRoleDAOAbstract<E extends SecurityRole>
