package org.nuiton.topia.security.entities.user;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.TopiaSecurityDAOHelper.TopiaSecurityEntityEnum;
import org.nuiton.topia.persistence.TopiaDAOImpl;
import org.nuiton.topia.persistence.TopiaEntity;

@Generated(value = "org.nuiton.topia.generator.EntityDAOTransformer", date = "Thu Oct 31 23:55:04 CET 2013")
public abstract class TopiaGroupDAOAbstract<E extends TopiaGroup> extends TopiaDAOImpl<E> {

    @Override
    public Class<E> getEntityClass() {
        return (Class<E>)TopiaGroup.class;
    }

    @Override
    public TopiaSecurityEntityEnum getTopiaEntityEnum() {
        return TopiaSecurityEntityEnum.TopiaGroup;
    }

    @Override
    public void delete(E entity) throws TopiaException {
        {
            List<TopiaUser> list = getTopiaContext().getHibernateSession().createSQLQuery(
                    "SELECT main.topiaid " +
                    "from topiaUser main, topiagroup_topiauser secondary " +
                    "where main.topiaid=secondary.topiaUser" +
                    " and secondary.topiaGroup='" + entity.getTopiaId() + "'")
                    .addEntity("main", org.nuiton.topia.TopiaSecurityDAOHelper.getImplementationClass(TopiaUser.class)).list();

            for (TopiaUser item : list) {
                item.removeTopiaGroup(entity);
            }
        }

                                        {
                                        List<TopiaGroup> list = getTopiaContext()
                                                    .getDAO(TopiaGroup.class)
                                                    .findAllByProperties(TopiaGroup.SUPER_GROUP, entity);
                                            for (TopiaGroup item : list) {

                                                // sletellier : Set null only if target is concerned by deletion
                                                if (entity.equals(item.getSuperGroup())) {
                                                    item.setSuperGroup(null);
                                                }
                        
                    }
                }

        super.delete(entity);
    }

    public E findByName(String v) throws TopiaException {
        E result = findByProperty(TopiaGroup.NAME, v);
        return result;
    }

    public List<E> findAllByName(String v) throws TopiaException {
        List<E> result = findAllByProperty(TopiaGroup.NAME, v);
        return result;
    }

    public E findByDescription(String v) throws TopiaException {
        E result = findByProperty(TopiaGroup.DESCRIPTION, v);
        return result;
    }

    public List<E> findAllByDescription(String v) throws TopiaException {
        List<E> result = findAllByProperty(TopiaGroup.DESCRIPTION, v);
        return result;
    }

    public E findContainsTopiaUser(TopiaUser v) throws TopiaException {
        E result = findContains(TopiaGroup.TOPIA_USER, v);
        return result;
    }

    public List<E> findAllContainsTopiaUser(TopiaUser v) throws TopiaException {
        List<E> result = findAllContains(TopiaGroup.TOPIA_USER, v);
        return result;
    }

    public E findBySuperGroup(TopiaGroup v) throws TopiaException {
        E result = findByProperty(TopiaGroup.SUPER_GROUP, v);
        return result;
    }

    public List<E> findAllBySuperGroup(TopiaGroup v) throws TopiaException {
        List<E> result = findAllByProperty(TopiaGroup.SUPER_GROUP, v);
        return result;
    }

    public E findContainsSubGroup(TopiaGroup v) throws TopiaException {
        E result = findContains(TopiaGroup.SUB_GROUP, v);
        return result;
    }

    public List<E> findAllContainsSubGroup(TopiaGroup v) throws TopiaException {
        List<E> result = findAllContains(TopiaGroup.SUB_GROUP, v);
        return result;
    }

    @Override
    public <U extends TopiaEntity> List<U> findUsages(Class<U> type, E entity) throws TopiaException {
        List<?> result = new ArrayList();
        List tmp;

        if (type == TopiaUser.class) {
            TopiaUserDAO dao = (TopiaUserDAO)
                getTopiaContext().getDAO(TopiaUser.class);
            tmp = dao.findAllContainsTopiaGroup(entity);
            result.addAll(tmp);
        }

        if (type == TopiaGroup.class) {
            TopiaGroupDAO dao = (TopiaGroupDAO)
                getTopiaContext().getDAO(TopiaGroup.class);
            tmp = dao.findAllBySuperGroup(entity);
            result.addAll(tmp);
        }

        if (type == TopiaGroup.class) {
            TopiaGroupDAO dao = (TopiaGroupDAO)
                getTopiaContext().getDAO(TopiaGroup.class);
            tmp = dao.findAllContainsSubGroup(entity);
            result.addAll(tmp);
        }

        return (List<U>) result;
    }

    @Override
    public Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> findAllUsages(E entity) throws TopiaException {
        Map<Class<? extends TopiaEntity>,List<? extends TopiaEntity>> result;
        result = new HashMap<Class<? extends TopiaEntity>, List<? extends TopiaEntity>>(2);

        List<? extends TopiaEntity> list;

        list = findUsages(TopiaUser.class, entity);
        if (!list.isEmpty()) {
            result.put(TopiaUser.class, list);
        }

        list = findUsages(TopiaGroup.class, entity);
        if (!list.isEmpty()) {
            result.put(TopiaGroup.class, list);
        }

        return result;
    }

} //TopiaGroupDAOAbstract<E extends TopiaGroup>
