/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia.taas.event;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.topia.event.TopiaEntitiesEvent;
import org.nuiton.topia.event.TopiaEntityEvent;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.taas.TaasService;
import org.nuiton.topia.taas.entities.TaasAuthorization;
import org.nuiton.topia.taas.entities.TaasPrincipal;
import org.nuiton.topia.taas.entities.TaasUser;
import org.nuiton.topia.taas.event.TaasAccessEntity;

public class TaasEntityVetoable
implements TaasAccessEntity {
    private static Log log = LogFactory.getLog(TaasEntityVetoable.class);
    protected TaasService taasService;

    public TaasEntityVetoable(TaasService taasService) {
        this.taasService = taasService;
    }

    public void create(TopiaEntityEvent event) {
        TopiaEntity entity = event.getEntity();
        String topiaId = entity.getTopiaId();
        if (log.isDebugEnabled()) {
            log.debug((Object)("[Security] create entity : " + topiaId));
        }
        this.taasService.check(entity, 2);
    }

    public void delete(TopiaEntityEvent event) {
        TopiaEntity entity = event.getEntity();
        String topiaId = entity.getTopiaId();
        if (log.isDebugEnabled()) {
            log.debug((Object)("[Security] delete entity : " + topiaId));
        }
        this.taasService.check(entity, 8);
    }

    public void load(TopiaEntityEvent event) {
    }

    public void update(TopiaEntityEvent event) {
        TopiaEntity entity = event.getEntity();
        String topiaId = entity.getTopiaId();
        if (log.isDebugEnabled()) {
            log.debug((Object)("[Security] update entity : " + topiaId));
        }
        this.taasService.check(entity, 4);
    }

    public <E extends TopiaEntity> List<E> load(TopiaEntitiesEvent<E> event) {
        TopiaEntity entity;
        List entities;
        if (log.isDebugEnabled()) {
            log.debug((Object)"[Security] load entities");
        }
        if (!((entities = event.getEntities()).isEmpty() || (entity = (TopiaEntity)entities.get(0)) instanceof TaasUser || entity instanceof TaasPrincipal || entity instanceof TaasAuthorization)) {
            this.taasService.check(entities, 1);
        }
        return entities;
    }
}

