/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia.migration;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.nuiton.topia.migration.AbstractTopiaMigrationCallback;
import org.nuiton.topia.persistence.TopiaException;
import org.nuiton.topia.persistence.support.TopiaSqlSupport;
import org.nuiton.util.ObjectUtil;
import org.nuiton.util.version.Version;

public abstract class TopiaMigrationCallbackByClass
extends AbstractTopiaMigrationCallback {
    protected MigrationCallBackForVersionResolver callBackResolver;

    protected TopiaMigrationCallbackByClass(MigrationCallBackForVersionResolver callBackResolver) {
        this.callBackResolver = callBackResolver;
        for (Version version : this.getAvailableVersions()) {
            Class<? extends MigrationCallBackForVersion> callBack = this.callBackResolver.getCallBack(version);
            if (callBack != null) continue;
            throw new IllegalStateException("It misses a migration class for version " + version);
        }
    }

    @Override
    protected void migrateForVersion(Version version, TopiaSqlSupport sqlSupport, boolean showSql, boolean showProgression) throws Exception {
        Class<? extends MigrationCallBackForVersion> migratorClass = this.callBackResolver.getCallBack(version);
        MigrationCallBackForVersion migrator = (MigrationCallBackForVersion)ObjectUtil.newInstance(migratorClass, Arrays.asList(this), (boolean)true);
        String[] queries = migrator.prepareMigration(sqlSupport, showSql, showProgression);
        this.executeSQL(sqlSupport, showSql, showProgression, queries);
    }

    public static class MigrationCallBackForVersionResolverByMap
    implements MigrationCallBackForVersionResolver {
        protected final Map<Version, Class<? extends MigrationCallBackForVersion>> versionMigrationMapping;

        public MigrationCallBackForVersionResolverByMap(Map<Version, Class<? extends MigrationCallBackForVersion>> versionMigrationMapping) {
            this.versionMigrationMapping = versionMigrationMapping;
        }

        @Override
        public Class<? extends MigrationCallBackForVersion> getCallBack(Version version) {
            return this.versionMigrationMapping.get(version);
        }
    }

    public static interface MigrationCallBackForVersionResolver {
        public Class<? extends MigrationCallBackForVersion> getCallBack(Version var1);
    }

    public static abstract class MigrationCallBackForVersion {
        protected final Version version;
        protected final TopiaMigrationCallbackByClass callBack;

        public MigrationCallBackForVersion(Version version, TopiaMigrationCallbackByClass callBack) {
            this.version = version;
            this.callBack = callBack;
        }

        protected String[] prepareMigration(TopiaSqlSupport sqlSupport, boolean showSql, boolean showProgression) throws TopiaException {
            ArrayList<String> queries = new ArrayList<String>();
            this.prepareMigrationScript(sqlSupport, queries, showSql, showProgression);
            return queries.toArray(new String[queries.size()]);
        }

        protected abstract void prepareMigrationScript(TopiaSqlSupport var1, List<String> var2, boolean var3, boolean var4) throws TopiaException;

        public void executeSQL(TopiaSqlSupport sqlSupport, String ... sqls) throws TopiaException {
            this.callBack.executeSQL(sqlSupport, sqls);
        }

        public void executeSQL(TopiaSqlSupport sqlSupport, boolean showSql, boolean showProgression, String ... sqls) throws TopiaException {
            this.callBack.executeSQL(sqlSupport, showSql, showProgression, sqls);
        }
    }
}

