/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia.migration.mappings;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.EnumSet;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Criteria;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.boot.Metadata;
import org.hibernate.jdbc.Work;
import org.hibernate.tool.hbm2ddl.SchemaExport;
import org.hibernate.tool.schema.TargetType;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.TopiaRuntimeException;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.framework.TopiaUtil;
import org.nuiton.topia.migration.mappings.TMSVersion;
import org.nuiton.version.Version;
import org.nuiton.version.Versions;

public class TMSVersionDAO {
    private static final Log log = LogFactory.getLog(TMSVersionDAO.class);
    public static final String LEGACY_TABLE_NAME = "tmsVersion";
    public static final String TABLE_NAME = "tms_version";
    public static final String LEGACY_MAPPING = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<!DOCTYPE hibernate-mapping PUBLIC \"-//Hibernate/Hibernate Mapping DTD 3.0//EN\" \"classpath://org/hibernate/hibernate-mapping-3.0.dtd\">\n<hibernate-mapping>\n    <class name=\"" + TMSVersion.class.getName() + "\" table=\"" + "tmsVersion" + "\">\n    <id column=\"" + "version" + "\" name=\"" + "version" + "\"/>\n  </class>\n</hibernate-mapping>";

    public static TMSVersion get(TopiaContext tx) throws TopiaException {
        try {
            Session session = ((TopiaContextImplementor)tx).getHibernate();
            Criteria criteria = session.createCriteria(TMSVersion.class);
            List list = criteria.list();
            TMSVersion result = list.isEmpty() ? null : (TMSVersion)list.get(0);
            return result;
        }
        catch (HibernateException e) {
            throw new TopiaException("Could not obtain version", (Throwable)e);
        }
    }

    public static void createTable(Metadata metatada) {
        EnumSet<TargetType> targetTypes = EnumSet.of(TargetType.DATABASE);
        if (log.isDebugEnabled()) {
            targetTypes = EnumSet.of(TargetType.DATABASE, TargetType.STDOUT);
        }
        new SchemaExport().createOnly(targetTypes, metatada);
    }

    public static void dropTable(Metadata metatada) {
        EnumSet<TargetType> targetTypes = EnumSet.of(TargetType.DATABASE);
        if (log.isDebugEnabled()) {
            targetTypes = EnumSet.of(TargetType.DATABASE, TargetType.STDOUT);
        }
        new SchemaExport().drop(targetTypes, metatada);
    }

    public static TMSVersion create(TopiaContext tx, String version) throws TopiaException {
        try {
            Session session = ((TopiaContextImplementor)tx).getHibernate();
            TMSVersion result = TMSVersion.valueOf(version);
            session.save((Object)result);
            return result;
        }
        catch (HibernateException e) {
            throw new TopiaException("Could not create version " + version, (Throwable)e);
        }
    }

    public static void update(TopiaContext tx, TMSVersion version) throws TopiaException {
        try {
            Session session = ((TopiaContextImplementor)tx).getHibernate();
            session.saveOrUpdate((Object)version);
            tx.commitTransaction();
        }
        catch (HibernateException e) {
            throw new TopiaException("Could not update version " + version, (Throwable)e);
        }
    }

    public static void deleteAll(TopiaContext tx) throws TopiaException {
        try {
            Session session = ((TopiaContextImplementor)tx).getHibernate();
            Criteria criteria = session.createCriteria(TMSVersion.class);
            List list = criteria.list();
            for (Object o : list) {
                session.delete(o);
            }
        }
        catch (HibernateException e) {
            throw new TopiaException("Could not delete all versions", (Throwable)e);
        }
    }

    public static Version getVersion(TopiaContext tx, String tableName) {
        try {
            TopiaContextImplementor txImpl = (TopiaContextImplementor)tx;
            String schemaName = TopiaUtil.getSchemaName((TopiaContext)txImpl);
            GetVersionWork work = new GetVersionWork(schemaName, tableName);
            txImpl.getHibernate().doWork((Work)work);
            Version v = work.getVersion();
            return v;
        }
        catch (TopiaException e) {
            throw new TopiaRuntimeException("Can't obtain dbVersion for reason " + e.getMessage(), (Throwable)e);
        }
    }

    static /* synthetic */ Log access$000() {
        return log;
    }

    public static class GetVersionWork
    implements Work {
        protected Version version;
        private final String tableName;
        private final String schemaName;

        public GetVersionWork(String schemaName, String tableName) {
            this.tableName = tableName;
            this.schemaName = schemaName;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void execute(Connection connection) throws SQLException {
            String fullTableName = this.schemaName == null ? this.tableName : this.schemaName + "." + this.tableName;
            try (PreparedStatement st = connection.prepareStatement("select version from " + fullTableName + ";");){
                ResultSet set = st.executeQuery();
                if (set.next()) {
                    this.version = Versions.valueOf((String)set.getString(1));
                }
            }
        }

        public Version getVersion() {
            return this.version;
        }
    }
}

