/* *##% ToPIA - Index service
 * Copyright (C) 2004 - 2009 CodeLutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>. ##%*/

/* *
 * IndexEntry.java
 *
 * Created: 13 oct. 06 11:07:50
 *
 * @author poussin
 * @version $Revision: 1459 $
 *
 * Last update: $Date: 2009-05-16 09:56:47 +0200 (Sat, 16 May 2009) $
 * by : $Author: tchemit $
 */

package org.nuiton.topia.index;


/**
 * This class permit to store on result search with score
 * 
 * @author poussin
 */
public class IndexEntry implements Comparable<IndexEntry> {
    
    float score;
    String topiaId;
    
    /**
     * 
     */
    public IndexEntry(float score, String topiaId) {
        this.score = score;
        this.topiaId = topiaId;
    }
    
    /**
     * @return the score
     */
    public float getScore() {
        return this.score;
    }
    
    /**
     * @return the topiaId
     */
    public String getTopiaId() {
        return this.topiaId;
    }

    /**
     * Order is inverse of natural order, 1 compareTo 0 return -1 not 1
     * this permit to have the stronger score at beginning of sorted list
     * 
     * @see java.lang.Comparable#compareTo(java.lang.Object)
     */
    public int compareTo(IndexEntry o) {
        if (getScore() < o.getScore()) {
            return 1;
        } else if (getScore() > o.getScore()) {
            return -1;
        } else {
            return 0;
        }
    }
    
    /* (non-Javadoc)
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        String result = "score: " + getScore() + " topiaId: " + getTopiaId();
        return result;
    }
}


